/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.EnvFromSourceBuilder;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarSourceFluent;
import java.util.Objects;
import java.util.function.Predicate;

@Description(value="Add a environment variable to the container.")
public class AddEnvVarDecorator
extends ApplicationContainerDecorator<ContainerBuilder> {
    private final Env env;

    public AddEnvVarDecorator(Env env) {
        this(ANY, ANY, env);
    }

    public AddEnvVarDecorator(String deployment, String container, Env env) {
        super(deployment, container);
        this.env = env;
    }

    @Override
    public void andThenVisit(ContainerBuilder builder) {
        Predicate<EnvVarBuilder> matchingEnv = new Predicate<EnvVarBuilder>(){

            @Override
            public boolean test(EnvVarBuilder e) {
                if (e.getName() != null) {
                    return e.getName().equals(AddEnvVarDecorator.this.env.getName());
                }
                return false;
            }
        };
        Predicate<EnvFromSourceBuilder> matchingEnvFrom = new Predicate<EnvFromSourceBuilder>(){

            @Override
            public boolean test(EnvFromSourceBuilder e) {
                if (e.getSecretRef() != null && e.getSecretRef().getName() != null) {
                    return e.getSecretRef().getName().equals(AddEnvVarDecorator.this.env.getSecret());
                }
                if (e.getConfigMapRef() != null && e.editConfigMapRef().getName() != null) {
                    return e.editConfigMapRef().getName().equals(AddEnvVarDecorator.this.env.getConfigmap());
                }
                return false;
            }
        };
        builder.removeMatchingFromEnv((Predicate)matchingEnv);
        builder.removeMatchingFromEnvFrom((Predicate)matchingEnvFrom);
        if (Strings.isNotNullOrEmpty((String)this.env.getSecret())) {
            this.populateFromSecret(builder);
        } else if (Strings.isNotNullOrEmpty((String)this.env.getConfigmap())) {
            this.populateFromConfigMap(builder);
        } else if (Strings.isNotNullOrEmpty((String)this.env.getField())) {
            this.populateFromField(builder);
        } else if (Strings.isNotNullOrEmpty((String)this.env.getName())) {
            ((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withValue(this.env.getValue())).endEnv();
        } else if (Strings.isNotNullOrEmpty((String)this.env.getResourceField())) {
            this.populateFromResourceField(builder);
        }
    }

    private void populateFromSecret(ContainerBuilder builder) {
        if (Strings.isNotNullOrEmpty((String)this.env.getName()) && Strings.isNotNullOrEmpty((String)this.env.getValue())) {
            ((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewSecretKeyRef(this.env.getValue(), this.env.getSecret(), null)).endValueFrom()).endEnv();
        } else {
            ((ContainerFluent.EnvFromNested)builder.addNewEnvFrom().withNewSecretRef(this.env.getSecret(), null)).endEnvFrom();
        }
    }

    private void populateFromConfigMap(ContainerBuilder builder) {
        if (Strings.isNotNullOrEmpty((String)this.env.getName()) && Strings.isNotNullOrEmpty((String)this.env.getValue())) {
            ((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewConfigMapKeyRef(this.env.getValue(), this.env.getConfigmap(), null)).endValueFrom()).endEnv();
        } else {
            ((ContainerFluent.EnvFromNested)builder.addNewEnvFrom().withNewConfigMapRef(this.env.getConfigmap(), null)).endEnvFrom();
        }
    }

    private void populateFromField(ContainerBuilder builder) {
        ((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.FieldRefNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewFieldRef().withFieldPath(this.env.getField())).endFieldRef()).endValueFrom()).endEnv();
    }

    private void populateFromResourceField(ContainerBuilder builder) {
        ((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((EnvVarSourceFluent.ResourceFieldRefNested)((ContainerFluent.EnvNested)builder.addNewEnv().withName(this.env.getName())).withNewValueFrom().withNewResourceFieldRef().withResource(this.env.getResourceField())).endResourceFieldRef()).endValueFrom()).endEnv();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddEnvVarDecorator addEnvVarDecorator = (AddEnvVarDecorator)o;
        return Objects.equals(this.env, addEnvVarDecorator.env);
    }

    public int hashCode() {
        return Objects.hash(this.env);
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class};
    }
}

