/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.adapter.ContainerAdapter;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;

@Description(value="Add an init container to a pod template.")
public class AddSidecarDecorator
extends NamedResourceDecorator<PodSpecBuilder> {
    private final io.dekorate.kubernetes.config.Container container;

    public AddSidecarDecorator(io.dekorate.kubernetes.config.Container container) {
        this(ANY, container);
    }

    public AddSidecarDecorator(String deployment, io.dekorate.kubernetes.config.Container container) {
        super(deployment);
        this.container = container;
    }

    @Override
    public void andThenVisit(PodSpecBuilder podSpec, ObjectMeta resourceMeta) {
        podSpec.addToContainers(new Container[]{ContainerAdapter.adapt(this.container)});
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }
}

