/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ResourceProvidingDecorator<T>
extends Decorator<T> {
    private static final List<String> DEPLOYMENT_KINDS = Arrays.asList("Deployment", "DeploymentConfig", "Service", "StatefulSet", "Pipeline", "Task");
    protected static final String ANY = null;

    public boolean contains(KubernetesListBuilder list, String apiVersion, String kind, String name) {
        return list.getItems().stream().filter(i -> this.match((HasMetadata)i, apiVersion, kind, name)).findAny().isPresent();
    }

    public boolean match(HasMetadata h, String apiVersion, String kind, String name) {
        if (Strings.isNotNullOrEmpty((String)apiVersion) && !apiVersion.equals(h.getApiVersion())) {
            return false;
        }
        if (Strings.isNotNullOrEmpty((String)kind) && !kind.endsWith(h.getKind())) {
            return false;
        }
        return !Strings.isNotNullOrEmpty((String)name) || name.equals(h.getMetadata().getName());
    }

    public Optional<ObjectMeta> getDeploymentMetadata(KubernetesListBuilder list) {
        return list.getItems().stream().filter(h -> DEPLOYMENT_KINDS.contains(h.getKind())).map(HasMetadata::getMetadata).findFirst();
    }

    public Optional<HasMetadata> getDeploymentHasMetadata(KubernetesListBuilder list) {
        return list.getItems().stream().filter(h -> DEPLOYMENT_KINDS.contains(h.getKind())).findFirst();
    }

    public ObjectMeta getMandatoryDeploymentMetadata(KubernetesListBuilder list) {
        return this.getDeploymentMetadata(list).orElseThrow(() -> new IllegalStateException("Expected at least one of: " + DEPLOYMENT_KINDS.stream().collect(Collectors.joining(",")) + " to be present."));
    }

    public HasMetadata getMandatoryDeploymentHasMetadata(KubernetesListBuilder list) {
        return this.getDeploymentHasMetadata(list).orElseThrow(() -> new IllegalStateException("Expected at least one of: " + DEPLOYMENT_KINDS.stream().collect(Collectors.joining(",")) + " to be present."));
    }
}

