/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class KubernetesConfig
extends BaseConfig {
    private Container[] initContainers = new Container[0];
    private Integer replicas;
    private DeploymentStrategy deploymentStrategy;
    private RollingUpdate rollingUpdate;
    private Boolean headless;

    public KubernetesConfig() {
    }

    public KubernetesConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, Label[] labels, Annotation[] annotations, Env[] envVars, String workingDir, String[] command, String[] arguments, String serviceAccount, String host, Port[] ports, ServiceType serviceType, PersistentVolumeClaimVolume[] pvcVolumes, SecretVolume[] secretVolumes, ConfigMapVolume[] configMapVolumes, GitRepoVolume[] gitRepoVolumes, AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes, AzureDiskVolume[] azureDiskVolumes, AzureFileVolume[] azureFileVolumes, Mount[] mounts, ImagePullPolicy imagePullPolicy, String[] imagePullSecrets, HostAlias[] hostAliases, Probe livenessProbe, Probe readinessProbe, ResourceRequirements requestResources, ResourceRequirements limitResources, Container[] sidecars, Boolean expose, Boolean autoDeployEnabled, Container[] initContainers, Integer replicas, DeploymentStrategy deploymentStrategy, RollingUpdate rollingUpdate, Boolean headless) {
        super(project, attributes, partOf, name, version, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, host, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, hostAliases, livenessProbe, readinessProbe, requestResources, limitResources, sidecars, expose, autoDeployEnabled);
        this.initContainers = initContainers != null ? initContainers : new Container[]{};
        this.replicas = replicas;
        this.deploymentStrategy = deploymentStrategy;
        this.rollingUpdate = rollingUpdate;
        this.headless = headless;
    }

    public Container[] getInitContainers() {
        return this.initContainers;
    }

    public Integer getReplicas() {
        return this.replicas;
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    public RollingUpdate getRollingUpdate() {
        return this.rollingUpdate;
    }

    public Boolean getHeadless() {
        return this.headless;
    }

    public boolean isHeadless() {
        return this.headless != null && this.headless != false;
    }

    public static KubernetesConfigBuilder newKubernetesConfigBuilder() {
        return new KubernetesConfigBuilder();
    }

    public static KubernetesConfigBuilder newKubernetesConfigBuilderFromDefaults() {
        return (KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)((KubernetesConfigBuilder)new KubernetesConfigBuilder().withReplicas(1)).withDeploymentStrategy(DeploymentStrategy.None)).withServiceType(ServiceType.ClusterIP)).withImagePullPolicy(ImagePullPolicy.IfNotPresent)).withExpose(false)).withHeadless(false)).withAutoDeployEnabled(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesConfig that = (KubernetesConfig)((Object)o);
        if (this.initContainers != null ? !this.initContainers.equals(that.initContainers) : that.initContainers != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.deploymentStrategy != null ? !this.deploymentStrategy.equals((Object)that.deploymentStrategy) : that.deploymentStrategy != null) {
            return false;
        }
        if (this.rollingUpdate != null ? !this.rollingUpdate.equals(that.rollingUpdate) : that.rollingUpdate != null) {
            return false;
        }
        return !(this.headless != null ? !this.headless.equals(that.headless) : that.headless != null);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.initContainers, this.replicas, this.deploymentStrategy, this.rollingUpdate, this.headless, super.hashCode()});
    }
}

