/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import java.util.Map;
import java.util.Optional;

@Description(value="Add an ingress to the list.")
public class AddIngressDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final KubernetesConfig config;
    private final Map<String, String> allLabels;

    public AddIngressDecorator(KubernetesConfig config, Map<String, String> allLabels) {
        this.config = config;
        this.allLabels = allLabels;
    }

    public void visit(KubernetesListBuilder list) {
        Optional p = Ports.getHttpPort((BaseConfig)this.config);
        if (!p.isPresent() || !this.config.isExpose()) {
            return;
        }
        if (this.contains(list, ANY, "Ingress", this.config.getName())) {
            return;
        }
        Port port = (Port)p.get();
        list.addToItems(new HasMetadata[]{((IngressBuilder)((IngressFluent.SpecNested)((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressServiceBackendFluent.PortNested)((IngressServiceBackendFluent.PortNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)((IngressBuilder)((IngressFluent.MetadataNested)((IngressFluent.MetadataNested)new IngressBuilder().withNewMetadata().withName(this.config.getName())).withLabels(this.allLabels)).endMetadata()).withNewSpec().addNewRule().withHost(this.config.getHost())).withNewHttp().addNewPath().withNewPathType("Prefix")).withPath(Strings.isNotNullOrEmpty((String)port.getPath()) ? port.getPath() : "/")).withNewBackend().withNewService().withName(this.config.getName())).withNewPort().withName(port.getName())).withNumber(Strings.isNullOrEmpty((String)port.getName()) && port.getHostPort() != null && port.getHostPort() > 0 ? port.getHostPort() : null)).endPort()).endService()).endBackend()).endPath()).endHttp()).endRule()).endSpec()).build()});
    }
}

