/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.decorator.Decorator;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import io.fabric8.kubernetes.api.model.VolumeFluent;

@Description(value="Add a persistent volume claim volume to all pod specs.")
public class AddPvcVolumeDecorator
extends Decorator<PodSpecBuilder> {
    private final PersistentVolumeClaimVolume volume;

    public AddPvcVolumeDecorator(PersistentVolumeClaimVolume volume) {
        this.volume = volume;
    }

    public void visit(PodSpecBuilder podSpec) {
        ((PodSpecFluent.VolumesNested)((VolumeFluent.PersistentVolumeClaimNested)((VolumeFluent.PersistentVolumeClaimNested)((PodSpecFluent.VolumesNested)podSpec.addNewVolume().withName(this.volume.getVolumeName())).withNewPersistentVolumeClaim().withClaimName(this.volume.getClaimName())).withReadOnly(Boolean.valueOf(this.volume.isReadOnly()))).endPersistentVolumeClaim()).endVolume();
    }
}

