/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.EditablePort;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortFluent;
import io.dekorate.kubernetes.config.PortFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class PortBuilder
extends PortFluentImpl<PortBuilder>
implements VisitableBuilder<Port, PortBuilder> {
    PortFluent<?> fluent;
    Boolean validationEnabled;

    public PortBuilder() {
        this(false);
    }

    public PortBuilder(Boolean validationEnabled) {
        this(new Port(), validationEnabled);
    }

    public PortBuilder(PortFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public PortBuilder(PortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Port(), validationEnabled);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance) {
        this(fluent, instance, false);
    }

    public PortBuilder(PortFluent<?> fluent, Port instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withName(instance.getName());
        fluent.withContainerPort(instance.getContainerPort());
        fluent.withHostPort(instance.getHostPort());
        fluent.withPath(instance.getPath());
        fluent.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public PortBuilder(Port instance) {
        this(instance, (Boolean)false);
    }

    public PortBuilder(Port instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withName(instance.getName());
        this.withContainerPort(instance.getContainerPort());
        this.withHostPort(instance.getHostPort());
        this.withPath(instance.getPath());
        this.withProtocol(instance.getProtocol());
        this.validationEnabled = validationEnabled;
    }

    public EditablePort build() {
        EditablePort buildable = new EditablePort(this.fluent.getName(), this.fluent.getContainerPort(), this.fluent.getHostPort(), this.fluent.getPath(), this.fluent.getProtocol());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortBuilder that = (PortBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

