/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Predicates;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Objects;

@Description(value="Add port to to the specified container(s).")
public class AddPortDecorator
extends ApplicationContainerDecorator<ContainerBuilder> {
    private final Port port;

    public AddPortDecorator(Port port) {
        this(ANY, ANY, port);
    }

    public AddPortDecorator(String deployment, String container, Port port) {
        super(deployment, container);
        this.port = port;
    }

    @Override
    public void andThenVisit(ContainerBuilder container) {
        if (container.buildPorts().stream().anyMatch(Predicates.matches((Port)this.port))) {
            ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.editMatchingPort(Predicates.builderMatches((Port)this.port)).withName(this.port.getName())).withHostPort(null)).withContainerPort(this.port.getContainerPort())).withProtocol(this.port.getProtocol() != null ? this.port.getProtocol().name() : Protocol.TCP.name())).endPort();
        } else {
            ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withName(this.port.getName())).withHostPort(null)).withContainerPort(this.port.getContainerPort())).withProtocol(this.port.getProtocol() != null ? this.port.getProtocol().name() : Protocol.TCP.name())).endPort();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddPortDecorator addPortDecorator = (AddPortDecorator)o;
        return Objects.equals(this.port, addPortDecorator.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class};
    }
}

