/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.AddSidecarDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.fabric8.kubernetes.api.model.ContainerFluent;

@Description(value="A decorator that applies the command to the application container.")
public class ApplyCommandDecorator
extends ApplicationContainerDecorator<ContainerFluent> {
    private final String[] command;

    public ApplyCommandDecorator(String containerName, String ... command) {
        super(null, containerName);
        this.command = command;
    }

    public ApplyCommandDecorator(String deployment, String container, String ... command) {
        super(deployment, container);
        this.command = command;
    }

    @Override
    public void andThenVisit(ContainerFluent container) {
        if (this.isApplicable(container) && this.command != null && this.command.length > 0) {
            container.withCommand(this.command);
        }
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddSidecarDecorator.class};
    }
}

