/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Labels;
import io.dekorate.utils.Ports;
import io.fabric8.kubernetes.api.model.BaseKubernetesListFluent;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Description(value="Add a service to the list.")
public class AddServiceResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger();
    public static final int MIN_PORT_NUMBER = 1;
    public static final int MAX_PORT_NUMBER = 65535;
    public static final int MIN_NODE_PORT_VALUE = 30000;
    public static final int MAX_NODE_PORT_VALUE = 31999;
    private final BaseConfig config;

    public AddServiceResourceDecorator(BaseConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        if (this.contains(list, "v1", "Service", this.config.getName())) {
            return;
        }
        Map labels = Labels.createLabelsAsMap((BaseConfig)this.config, (String)"Service");
        ((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((BaseKubernetesListFluent.ServiceItemsNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)list.addNewServiceItem().withNewMetadata().withName(this.config.getName())).withLabels(labels)).endMetadata()).withNewSpec().withType(this.config.getServiceType() != null ? this.config.getServiceType().name() : "ClusterIP")).withSelector(labels)).withPorts(Arrays.asList(this.config.getPorts()).stream().filter(AddServiceResourceDecorator.distinct(p -> p.getName())).map(port -> this.toServicePort((Port)port, this.config.getServiceType().equals((Object)ServiceType.NodePort))).collect(Collectors.toList()))).endSpec()).endServiceItem();
    }

    private ServicePort toServicePort(Port port, boolean isNodePort) {
        ServicePortBuilder servicePortBuilder = (ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(port.getName())).withNewTargetPort(port.getContainerPort())).withPort(AddServiceResourceDecorator.calculateHostPort(port));
        if (isNodePort) {
            servicePortBuilder = (ServicePortBuilder)servicePortBuilder.withNodePort(Ports.calculateNodePort((String)this.config.getName(), (Port)port));
        }
        return servicePortBuilder.build();
    }

    public static Integer calculateHostPort(Port port) {
        if (port.getHostPort() != null && port.getHostPort() > 0) {
            return port.getHostPort();
        }
        return port.getContainerPort();
    }

    public static <T> Predicate<T> distinct(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            Object key = keyExtractor.apply(t);
            if (key == null) {
                LOGGER.warning("Found incomplete port definition (name is missing). The port will be ignored.");
                return false;
            }
            return map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
        };
    }
}

