/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.doc.Description;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import java.util.Arrays;
import java.util.List;

@Description(value="Apply the number of replicas to the DeploymentSpec.")
public class ApplyReplicasToDeploymentDecorator
extends NamedResourceDecorator<DeploymentSpecFluent>
implements WithConfigReferences {
    private final int replicas;

    public ApplyReplicasToDeploymentDecorator(int replicas) {
        this(ANY, replicas);
    }

    public ApplyReplicasToDeploymentDecorator(String deploymentName, int replicas) {
        super(deploymentName);
        this.replicas = replicas;
    }

    @Override
    public void andThenVisit(DeploymentSpecFluent deploymentSpec, ObjectMeta resourceMeta) {
        if (this.replicas > 0) {
            deploymentSpec.withReplicas(Integer.valueOf(this.replicas));
        }
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceReplicas());
    }

    private ConfigReference buildConfigReferenceReplicas() {
        String property = ConfigReference.generateConfigReferenceName((String)"replicas", (String[])new String[]{this.getName()});
        String jsonPath = "$.[?(@.kind == 'Deployment')].spec.replicas";
        if (!Strings.equals((String)this.getName(), (String)ANY)) {
            jsonPath = "$.[?(@.kind == 'Deployment' && @.metadata.name == '" + this.getName() + "')].spec.replicas";
        }
        return new ConfigReference(property, jsonPath);
    }
}

