package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import java.lang.String;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.util.List;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.Job;
import java.lang.Boolean;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import java.util.stream.Collectors;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.HostAlias;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.project.BuildInfo;
import java.lang.Object;
import io.dekorate.project.ScmInfo;
import java.util.Arrays;
import java.util.Map;
import io.dekorate.kubernetes.config.GitRepoVolume;

 /**
  * Generated
  */
public class KubernetesConfigAdapter{
  public static KubernetesConfig adapt(KubernetesApplication instance) {
    return newBuilder(instance).build();
  }
  public static KubernetesConfigBuilder newBuilder(io.dekorate.kubernetes.annotation.KubernetesApplication instance) {
    return new KubernetesConfigBuilder(new io.dekorate.kubernetes.config.KubernetesConfig(null,
            null,
            instance.partOf(),
            instance.name(),
            instance.version(),
            instance.deploymentKind(),
            Arrays.asList(instance.labels()).stream().map(i ->new Label(i.key(),
            i.value(),
            i.kinds())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Label[0]),
            Arrays.asList(instance.annotations()).stream().map(i ->new Annotation(i.key(),
            i.value(),
            i.kinds())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Annotation[0]),
            Arrays.asList(instance.envVars()).stream().map(i ->new Env(i.name(),
            i.value(),
            i.secret(),
            i.configmap(),
            i.field(),
            i.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            instance.workingDir(),
            instance.command(),
            instance.arguments(),
            instance.serviceAccount(),
            instance.host(),
            Arrays.asList(instance.ports()).stream().map(i ->new Port(i.name(),
            i.containerPort(),
            i.hostPort(),
            i.nodePort(),
            i.path(),
            i.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            instance.serviceType(),
            Arrays.asList(instance.pvcVolumes()).stream().map(i ->new PersistentVolumeClaimVolume(i.volumeName(),
            i.claimName(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[0]),
            Arrays.asList(instance.secretVolumes()).stream().map(i ->new SecretVolume(i.volumeName(),
            i.secretName(),
            i.defaultMode(),
            i.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.SecretVolume[0]),
            Arrays.asList(instance.configMapVolumes()).stream().map(i ->new ConfigMapVolume(i.volumeName(),
            i.configMapName(),
            i.defaultMode(),
            i.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.ConfigMapVolume[0]),
            Arrays.asList(instance.gitRepoVolumes()).stream().map(i ->new GitRepoVolume(i.volumeName(),
            i.repository(),
            i.directory(),
            i.revision())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.GitRepoVolume[0]),
            Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i ->new AwsElasticBlockStoreVolume(i.volumeName(),
            i.volumeId(),
            i.partition(),
            i.fsType(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[0]),
            Arrays.asList(instance.azureDiskVolumes()).stream().map(i ->new AzureDiskVolume(i.volumeName(),
            i.diskName(),
            i.diskURI(),
            i.kind(),
            i.cachingMode(),
            i.fsType(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureDiskVolume[0]),
            Arrays.asList(instance.azureFileVolumes()).stream().map(i ->new AzureFileVolume(i.volumeName(),
            i.shareName(),
            i.secretName(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureFileVolume[0]),
            Arrays.asList(instance.mounts()).stream().map(i ->new Mount(i.name(),
            i.path(),
            i.subPath(),
            i.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            instance.imagePullPolicy(),
            instance.imagePullSecrets(),
            Arrays.asList(instance.hostAliases()).stream().map(i ->new HostAlias(i.ip(),
            i.hostnames())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.HostAlias[0]),
            new Probe(instance.livenessProbe().httpActionPath(),
            instance.livenessProbe().execAction(),
            instance.livenessProbe().tcpSocketAction(),
            instance.livenessProbe().grpcAction(),
            instance.livenessProbe().initialDelaySeconds(),
            instance.livenessProbe().periodSeconds(),
            instance.livenessProbe().timeoutSeconds(),
            instance.livenessProbe().successThreshold(),
            instance.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(instance.readinessProbe().httpActionPath(),
            instance.readinessProbe().execAction(),
            instance.readinessProbe().tcpSocketAction(),
            instance.readinessProbe().grpcAction(),
            instance.readinessProbe().initialDelaySeconds(),
            instance.readinessProbe().periodSeconds(),
            instance.readinessProbe().timeoutSeconds(),
            instance.readinessProbe().successThreshold(),
            instance.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(instance.startupProbe().httpActionPath(),
            instance.startupProbe().execAction(),
            instance.startupProbe().tcpSocketAction(),
            instance.startupProbe().grpcAction(),
            instance.startupProbe().initialDelaySeconds(),
            instance.startupProbe().periodSeconds(),
            instance.startupProbe().timeoutSeconds(),
            instance.startupProbe().successThreshold(),
            instance.startupProbe().failureThreshold()),
            new ResourceRequirements(instance.requestResources().memory(),
            instance.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(instance.limitResources().memory(),
            instance.limitResources().cpu()),
            Arrays.asList(instance.sidecars()).stream().map(i ->new Container(i.image(),
            i.name(),
            Arrays.asList(i.envVars()).stream().map(j ->new io.dekorate.kubernetes.config.Env(j.name(),
            j.value(),
            j.secret(),
            j.configmap(),
            j.field(),
            j.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            i.workingDir(),
            i.command(),
            i.arguments(),
            Arrays.asList(i.ports()).stream().map(j ->new io.dekorate.kubernetes.config.Port(j.name(),
            j.containerPort(),
            j.hostPort(),
            j.nodePort(),
            j.path(),
            j.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(i.mounts()).stream().map(j ->new io.dekorate.kubernetes.config.Mount(j.name(),
            j.path(),
            j.subPath(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            i.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(i.livenessProbe().httpActionPath(),
            i.livenessProbe().execAction(),
            i.livenessProbe().tcpSocketAction(),
            i.livenessProbe().grpcAction(),
            i.livenessProbe().initialDelaySeconds(),
            i.livenessProbe().periodSeconds(),
            i.livenessProbe().timeoutSeconds(),
            i.livenessProbe().successThreshold(),
            i.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.readinessProbe().httpActionPath(),
            i.readinessProbe().execAction(),
            i.readinessProbe().tcpSocketAction(),
            i.readinessProbe().grpcAction(),
            i.readinessProbe().initialDelaySeconds(),
            i.readinessProbe().periodSeconds(),
            i.readinessProbe().timeoutSeconds(),
            i.readinessProbe().successThreshold(),
            i.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.startupProbe().httpActionPath(),
            i.startupProbe().execAction(),
            i.startupProbe().tcpSocketAction(),
            i.startupProbe().grpcAction(),
            i.startupProbe().initialDelaySeconds(),
            i.startupProbe().periodSeconds(),
            i.startupProbe().timeoutSeconds(),
            i.startupProbe().successThreshold(),
            i.startupProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.requestResources().memory(),
            i.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.limitResources().memory(),
            i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]),
            instance.expose(),
            instance.autoDeployEnabled(),
            Arrays.asList(instance.jobs()).stream().map(i ->new Job(i.name(),
            i.parallelism(),
            i.completions(),
            i.completionMode(),
            i.backoffLimit(),
            i.activeDeadlineSeconds(),
            i.ttlSecondsAfterFinished(),
            i.suspend(),
            i.restartPolicy(),
            Arrays.asList(i.pvcVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(j.volumeName(),
            j.claimName(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[0]),
            Arrays.asList(i.secretVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.SecretVolume(j.volumeName(),
            j.secretName(),
            j.defaultMode(),
            j.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.SecretVolume[0]),
            Arrays.asList(i.configMapVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.ConfigMapVolume(j.volumeName(),
            j.configMapName(),
            j.defaultMode(),
            j.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.ConfigMapVolume[0]),
            Arrays.asList(i.awsElasticBlockStoreVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(j.volumeName(),
            j.volumeId(),
            j.partition(),
            j.fsType(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[0]),
            Arrays.asList(i.azureDiskVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.AzureDiskVolume(j.volumeName(),
            j.diskName(),
            j.diskURI(),
            j.kind(),
            j.cachingMode(),
            j.fsType(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureDiskVolume[0]),
            Arrays.asList(i.azureFileVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.AzureFileVolume(j.volumeName(),
            j.shareName(),
            j.secretName(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureFileVolume[0]),
            Arrays.asList(i.containers()).stream().map(j ->new io.dekorate.kubernetes.config.Container(j.image(),
            j.name(),
            Arrays.asList(j.envVars()).stream().map(k ->new io.dekorate.kubernetes.config.Env(k.name(),
            k.value(),
            k.secret(),
            k.configmap(),
            k.field(),
            k.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            j.workingDir(),
            j.command(),
            j.arguments(),
            Arrays.asList(j.ports()).stream().map(k ->new io.dekorate.kubernetes.config.Port(k.name(),
            k.containerPort(),
            k.hostPort(),
            k.nodePort(),
            k.path(),
            k.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(j.mounts()).stream().map(k ->new io.dekorate.kubernetes.config.Mount(k.name(),
            k.path(),
            k.subPath(),
            k.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            j.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(j.livenessProbe().httpActionPath(),
            j.livenessProbe().execAction(),
            j.livenessProbe().tcpSocketAction(),
            j.livenessProbe().grpcAction(),
            j.livenessProbe().initialDelaySeconds(),
            j.livenessProbe().periodSeconds(),
            j.livenessProbe().timeoutSeconds(),
            j.livenessProbe().successThreshold(),
            j.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(j.readinessProbe().httpActionPath(),
            j.readinessProbe().execAction(),
            j.readinessProbe().tcpSocketAction(),
            j.readinessProbe().grpcAction(),
            j.readinessProbe().initialDelaySeconds(),
            j.readinessProbe().periodSeconds(),
            j.readinessProbe().timeoutSeconds(),
            j.readinessProbe().successThreshold(),
            j.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(j.startupProbe().httpActionPath(),
            j.startupProbe().execAction(),
            j.startupProbe().tcpSocketAction(),
            j.startupProbe().grpcAction(),
            j.startupProbe().initialDelaySeconds(),
            j.startupProbe().periodSeconds(),
            j.startupProbe().timeoutSeconds(),
            j.startupProbe().successThreshold(),
            j.startupProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(j.requestResources().memory(),
            j.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(j.limitResources().memory(),
            j.limitResources().cpu()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Job[0]),
            Arrays.asList(instance.cronJobs()).stream().map(i ->new CronJob(i.name(),
            i.schedule(),
            i.concurrencyPolicy(),
            i.startingDeadlineSeconds(),
            i.failedJobsHistoryLimit(),
            i.successfulJobsHistoryLimit(),
            i.parallelism(),
            i.completions(),
            i.completionMode(),
            i.backoffLimit(),
            i.activeDeadlineSeconds(),
            i.ttlSecondsAfterFinished(),
            i.suspend(),
            i.restartPolicy(),
            Arrays.asList(i.pvcVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(j.volumeName(),
            j.claimName(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[0]),
            Arrays.asList(i.secretVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.SecretVolume(j.volumeName(),
            j.secretName(),
            j.defaultMode(),
            j.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.SecretVolume[0]),
            Arrays.asList(i.configMapVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.ConfigMapVolume(j.volumeName(),
            j.configMapName(),
            j.defaultMode(),
            j.optional())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.ConfigMapVolume[0]),
            Arrays.asList(i.awsElasticBlockStoreVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(j.volumeName(),
            j.volumeId(),
            j.partition(),
            j.fsType(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[0]),
            Arrays.asList(i.azureDiskVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.AzureDiskVolume(j.volumeName(),
            j.diskName(),
            j.diskURI(),
            j.kind(),
            j.cachingMode(),
            j.fsType(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureDiskVolume[0]),
            Arrays.asList(i.azureFileVolumes()).stream().map(j ->new io.dekorate.kubernetes.config.AzureFileVolume(j.volumeName(),
            j.shareName(),
            j.secretName(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.AzureFileVolume[0]),
            Arrays.asList(i.containers()).stream().map(j ->new io.dekorate.kubernetes.config.Container(j.image(),
            j.name(),
            Arrays.asList(j.envVars()).stream().map(k ->new io.dekorate.kubernetes.config.Env(k.name(),
            k.value(),
            k.secret(),
            k.configmap(),
            k.field(),
            k.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            j.workingDir(),
            j.command(),
            j.arguments(),
            Arrays.asList(j.ports()).stream().map(k ->new io.dekorate.kubernetes.config.Port(k.name(),
            k.containerPort(),
            k.hostPort(),
            k.nodePort(),
            k.path(),
            k.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(j.mounts()).stream().map(k ->new io.dekorate.kubernetes.config.Mount(k.name(),
            k.path(),
            k.subPath(),
            k.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            j.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(j.livenessProbe().httpActionPath(),
            j.livenessProbe().execAction(),
            j.livenessProbe().tcpSocketAction(),
            j.livenessProbe().grpcAction(),
            j.livenessProbe().initialDelaySeconds(),
            j.livenessProbe().periodSeconds(),
            j.livenessProbe().timeoutSeconds(),
            j.livenessProbe().successThreshold(),
            j.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(j.readinessProbe().httpActionPath(),
            j.readinessProbe().execAction(),
            j.readinessProbe().tcpSocketAction(),
            j.readinessProbe().grpcAction(),
            j.readinessProbe().initialDelaySeconds(),
            j.readinessProbe().periodSeconds(),
            j.readinessProbe().timeoutSeconds(),
            j.readinessProbe().successThreshold(),
            j.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(j.startupProbe().httpActionPath(),
            j.startupProbe().execAction(),
            j.startupProbe().tcpSocketAction(),
            j.startupProbe().grpcAction(),
            j.startupProbe().initialDelaySeconds(),
            j.startupProbe().periodSeconds(),
            j.startupProbe().timeoutSeconds(),
            j.startupProbe().successThreshold(),
            j.startupProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(j.requestResources().memory(),
            j.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(j.limitResources().memory(),
            j.limitResources().cpu()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.CronJob[0]),
            Arrays.asList(instance.initContainers()).stream().map(i ->new io.dekorate.kubernetes.config.Container(i.image(),
            i.name(),
            Arrays.asList(i.envVars()).stream().map(j ->new io.dekorate.kubernetes.config.Env(j.name(),
            j.value(),
            j.secret(),
            j.configmap(),
            j.field(),
            j.resourceField())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Env[0]),
            i.workingDir(),
            i.command(),
            i.arguments(),
            Arrays.asList(i.ports()).stream().map(j ->new io.dekorate.kubernetes.config.Port(j.name(),
            j.containerPort(),
            j.hostPort(),
            j.nodePort(),
            j.path(),
            j.protocol())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Port[0]),
            Arrays.asList(i.mounts()).stream().map(j ->new io.dekorate.kubernetes.config.Mount(j.name(),
            j.path(),
            j.subPath(),
            j.readOnly())).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Mount[0]),
            i.imagePullPolicy(),
            new io.dekorate.kubernetes.config.Probe(i.livenessProbe().httpActionPath(),
            i.livenessProbe().execAction(),
            i.livenessProbe().tcpSocketAction(),
            i.livenessProbe().grpcAction(),
            i.livenessProbe().initialDelaySeconds(),
            i.livenessProbe().periodSeconds(),
            i.livenessProbe().timeoutSeconds(),
            i.livenessProbe().successThreshold(),
            i.livenessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.readinessProbe().httpActionPath(),
            i.readinessProbe().execAction(),
            i.readinessProbe().tcpSocketAction(),
            i.readinessProbe().grpcAction(),
            i.readinessProbe().initialDelaySeconds(),
            i.readinessProbe().periodSeconds(),
            i.readinessProbe().timeoutSeconds(),
            i.readinessProbe().successThreshold(),
            i.readinessProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.Probe(i.startupProbe().httpActionPath(),
            i.startupProbe().execAction(),
            i.startupProbe().tcpSocketAction(),
            i.startupProbe().grpcAction(),
            i.startupProbe().initialDelaySeconds(),
            i.startupProbe().periodSeconds(),
            i.startupProbe().timeoutSeconds(),
            i.startupProbe().successThreshold(),
            i.startupProbe().failureThreshold()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.requestResources().memory(),
            i.requestResources().cpu()),
            new io.dekorate.kubernetes.config.ResourceRequirements(i.limitResources().memory(),
            i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new io.dekorate.kubernetes.config.Container[0]),
            instance.replicas(),
            instance.deploymentStrategy(),
            new RollingUpdate(instance.rollingUpdate().maxUnavailable(),
            instance.rollingUpdate().maxSurge()),
            instance.headless()));
  }
  public static io.dekorate.kubernetes.config.KubernetesConfig adapt(Map map) {
    return new io.dekorate.kubernetes.config.KubernetesConfig(
null,
null,
               (String)(map instanceof Map ? ((Map)map).getOrDefault("partOf", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("deploymentKind", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Label(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Label[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Annotation(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Annotation[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("command")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("arguments")) : toStringArray(map),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("host", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
               Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               (ServiceType)(map instanceof Map ? ( ((Map)map).getOrDefault("serviceType", null) != null ? io.dekorate.kubernetes.annotation.ServiceType.valueOf(String.valueOf(((Map)map).getOrDefault("serviceType", null))) : null ) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
               (Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("directory", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("revision", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.GitRepoVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("partition", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("kind", "Managed") : "Managed"),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (ImagePullPolicy)(map instanceof Map ? ( ((Map)map).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)map).getOrDefault("imagePullPolicy", null))) : null ) : null),
map instanceof Map ? toStringArray(((Map)map).get("imagePullSecrets")) : toStringArray(map),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("hostAliases" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.HostAlias(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("ip", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("hostnames", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.HostAlias[size]),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("cpu", "") : "")),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("expose", null) : null),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("jobs" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Job(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
               JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
               (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
               JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]))).toArray(size-> new io.dekorate.kubernetes.config.Job[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("cronJobs" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.CronJob(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("schedule", null) : null),
               CronJobConcurrencyPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("concurrencyPolicy","Allow") : "Allow")),
               (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("startingDeadlineSeconds", -1L) : -1L),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("failedJobsHistoryLimit", 1) : 1),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("successfulJobsHistoryLimit", 3) : 3),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
               io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
               (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
               io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]))).toArray(size-> new io.dekorate.kubernetes.config.CronJob[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Integer)(map instanceof Map ? ((Map)map).getOrDefault("replicas", null) : null),
               (DeploymentStrategy)(map instanceof Map ? ( ((Map)map).getOrDefault("deploymentStrategy", null) != null ? io.dekorate.kubernetes.config.DeploymentStrategy.valueOf(String.valueOf(((Map)map).getOrDefault("deploymentStrategy", null))) : null ) : null),
new io.dekorate.kubernetes.config.RollingUpdate(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxUnavailable", "25%") : "25%"),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxSurge", "25%") : "25%")),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("headless", null) : null));
  }
  public static io.dekorate.kubernetes.config.KubernetesConfigBuilder newBuilder(java.util.Map map) {
    return new KubernetesConfigBuilder(new io.dekorate.kubernetes.config.KubernetesConfig(
null,
null,
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("partOf", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("name", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("version", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("deploymentKind", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("labels" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Label(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Label[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("annotations" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Annotation(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("key", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", null) : null),
i instanceof Map ? toStringArray(((Map)i).get("kinds")) : toStringArray(i))).toArray(size-> new io.dekorate.kubernetes.config.Annotation[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("value", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secret", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configmap", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("field", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("workingDir", null) : null),
map instanceof Map ? toStringArray(((Map)map).get("command")) : toStringArray(map),
map instanceof Map ? toStringArray(((Map)map).get("arguments")) : toStringArray(map),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("serviceAccount", null) : null),
               (java.lang.String)(map instanceof Map ? ((Map)map).getOrDefault("host", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("ports" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               (io.dekorate.kubernetes.annotation.ServiceType)(map instanceof Map ? ( ((Map)map).getOrDefault("serviceType", null) != null ? io.dekorate.kubernetes.annotation.ServiceType.valueOf(String.valueOf(((Map)map).getOrDefault("serviceType", null))) : null ) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("gitRepoVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.GitRepoVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("repository", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("directory", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("revision", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.GitRepoVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("partition", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("diskURI", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("kind", "Managed") : "Managed"),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("volumeName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("shareName", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("path", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               (io.dekorate.kubernetes.annotation.ImagePullPolicy)(map instanceof Map ? ( ((Map)map).getOrDefault("imagePullPolicy", null) != null ? io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(((Map)map).getOrDefault("imagePullPolicy", null))) : null ) : null),
map instanceof Map ? toStringArray(((Map)map).get("imagePullSecrets")) : toStringArray(map),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("hostAliases" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.HostAlias(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("ip", "") : ""),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("hostnames", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.HostAlias[size]),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("limitResources") : null))).getOrDefault("cpu", "") : "")),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("sidecars" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("expose", null) : null),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("autoDeployEnabled", null) : null),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("jobs" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Job(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
               io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
               (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
               io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]))).toArray(size-> new io.dekorate.kubernetes.config.Job[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("cronJobs" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.CronJob(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("schedule", null) : null),
               io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("concurrencyPolicy","Allow") : "Allow")),
               (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("startingDeadlineSeconds", -1L) : -1L),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("failedJobsHistoryLimit", 1) : 1),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("successfulJobsHistoryLimit", 3) : 3),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("parallelism", -1) : -1),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("completions", -1) : -1),
               io.dekorate.kubernetes.annotation.JobCompletionMode.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("completionMode","NonIndexed") : "NonIndexed")),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("backoffLimit", -1) : -1),
               (java.lang.Long)(i instanceof Map ? ((Map)i).getOrDefault("activeDeadlineSeconds", -1L) : -1L),
               (java.lang.Integer)(i instanceof Map ? ((Map)i).getOrDefault("ttlSecondsAfterFinished", -1) : -1),
               (java.lang.Boolean)(i instanceof Map ? ((Map)i).getOrDefault("suspend", false) : false),
               io.dekorate.kubernetes.annotation.JobRestartPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("restartPolicy","OnFailure") : "OnFailure")),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("pvcVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("claimName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.PersistentVolumeClaimVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("secretVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.SecretVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.SecretVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("configMapVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.ConfigMapVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configMapName", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("defaultMode", 384) : 384),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("optional", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.ConfigMapVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("awsElasticBlockStoreVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeId", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("partition", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureDiskVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureDiskVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("diskURI", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("kind", "Managed") : "Managed"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("cachingMode", "ReadWrite") : "ReadWrite"),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("fsType", "ext4") : "ext4"),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureDiskVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("azureFileVolumes" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.AzureFileVolume(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("volumeName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("shareName", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secretName", null) : null),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.AzureFileVolume[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("containers" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("image", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("value", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("secret", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("configmap", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("field", "") : ""),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("workingDir", "") : ""),
j instanceof Map ? toStringArray(((Map)j).get("command")) : toStringArray(j),
j instanceof Map ? toStringArray(((Map)j).get("arguments")) : toStringArray(j),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("ports" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(k instanceof Map ? ((Map)k).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(k instanceof Map ? ((Map)k).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(j instanceof Map ? ((Map)j).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(k ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("name", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("path", null) : null),
               (java.lang.String)(k instanceof Map ? ((Map)k).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(k instanceof Map ? ((Map)k).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(j instanceof Map ? ((Map)j).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]))).toArray(size-> new io.dekorate.kubernetes.config.CronJob[size]),
               Arrays.stream((Map[])(map instanceof Map ? ((Map)map).getOrDefault("initContainers" , new Map[0]) : new Map[0])).map(i ->new io.dekorate.kubernetes.config.Container(
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("image", null) : null),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("name", "") : ""),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("envVars" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Env(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("value", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("secret", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("configmap", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("field", "") : ""),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("resourceField", "") : ""))).toArray(size-> new io.dekorate.kubernetes.config.Env[size]),
               (java.lang.String)(i instanceof Map ? ((Map)i).getOrDefault("workingDir", "") : ""),
i instanceof Map ? toStringArray(((Map)i).get("command")) : toStringArray(i),
i instanceof Map ? toStringArray(((Map)i).get("arguments")) : toStringArray(i),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("ports" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Port(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("containerPort", null) : null),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("hostPort", 0) : 0),
               (java.lang.Integer)(j instanceof Map ? ((Map)j).getOrDefault("nodePort", 0) : 0),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", "/") : "/"),
               io.dekorate.kubernetes.annotation.Protocol.valueOf(String.valueOf(j instanceof Map ? ((Map)j).getOrDefault("protocol","TCP") : "TCP")))).toArray(size-> new io.dekorate.kubernetes.config.Port[size]),
               Arrays.stream((Map[])(i instanceof Map ? ((Map)i).getOrDefault("mounts" , new Map[0]) : new Map[0])).map(j ->new io.dekorate.kubernetes.config.Mount(
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("name", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("path", null) : null),
               (java.lang.String)(j instanceof Map ? ((Map)j).getOrDefault("subPath", "") : ""),
               (java.lang.Boolean)(j instanceof Map ? ((Map)j).getOrDefault("readOnly", false) : false))).toArray(size-> new io.dekorate.kubernetes.config.Mount[size]),
               io.dekorate.kubernetes.annotation.ImagePullPolicy.valueOf(String.valueOf(i instanceof Map ? ((Map)i).getOrDefault("imagePullPolicy","IfNotPresent") : "IfNotPresent")),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("livenessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("readinessProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.Probe(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("httpActionPath", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("execAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("tcpSocketAction", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("grpcAction", "") : ""),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("initialDelaySeconds", 0) : 0),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("periodSeconds", 30) : 30),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("timeoutSeconds", 10) : 10),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("successThreshold", 1) : 1),
                   (java.lang.Integer)(((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("startupProbe") : null))).getOrDefault("failureThreshold", 3) : 3)),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("requestResources") : null))).getOrDefault("cpu", "") : "")),
new io.dekorate.kubernetes.config.ResourceRequirements(
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("memory", "") : ""),
                   (java.lang.String)(((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null)) instanceof Map ? ((Map)((Map)(i instanceof Map ? ((Map)i).get("limitResources") : null))).getOrDefault("cpu", "") : "")))).toArray(size-> new io.dekorate.kubernetes.config.Container[size]),
               (java.lang.Integer)(map instanceof Map ? ((Map)map).getOrDefault("replicas", null) : null),
               (io.dekorate.kubernetes.config.DeploymentStrategy)(map instanceof Map ? ( ((Map)map).getOrDefault("deploymentStrategy", null) != null ? io.dekorate.kubernetes.config.DeploymentStrategy.valueOf(String.valueOf(((Map)map).getOrDefault("deploymentStrategy", null))) : null ) : null),
new io.dekorate.kubernetes.config.RollingUpdate(
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxUnavailable", "25%") : "25%"),
                   (java.lang.String)(((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null)) instanceof Map ? ((Map)((Map)(map instanceof Map ? ((Map)map).get("rollingUpdate") : null))).getOrDefault("maxSurge", "25%") : "25%")),
               (java.lang.Boolean)(map instanceof Map ? ((Map)map).getOrDefault("headless", null) : null)));
  }
  public static java.lang.String[] toStringArray(Object o) {
            if (o instanceof String[]) {
          return (String[]) o;
        }
        if (o instanceof String) {
          String s =  (String) o;
          return s.split(",[ ]*");
        }
        else if (o instanceof List) {
          List c = (List) o;
          String[] result = new String[c.size()]; 
          for (int i=0; i <= c.size(); i++) {
            result[i] = String.valueOf(c.get(i));
          }
          return result;
        }
        return new String[0];
    

  }
  
}