package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubernetesConfigFluentImpl<A extends KubernetesConfigFluent<A>> extends BaseConfigFluentImpl<A> implements KubernetesConfigFluent<A>{
  public KubernetesConfigFluentImpl() {
  }
  public KubernetesConfigFluentImpl(io.dekorate.kubernetes.config.KubernetesConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withPartOf(instance.getPartOf()); 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withDeploymentKind(instance.getDeploymentKind()); 
    this.withLabels(instance.getLabels()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withEnvVars(instance.getEnvVars()); 
    this.withWorkingDir(instance.getWorkingDir()); 
    this.withCommand(instance.getCommand()); 
    this.withArguments(instance.getArguments()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withHost(instance.getHost()); 
    this.withPorts(instance.getPorts()); 
    this.withServiceType(instance.getServiceType()); 
    this.withPvcVolumes(instance.getPvcVolumes()); 
    this.withSecretVolumes(instance.getSecretVolumes()); 
    this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
    this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
    this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
    this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
    this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
    this.withMounts(instance.getMounts()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withLivenessProbe(instance.getLivenessProbe()); 
    this.withReadinessProbe(instance.getReadinessProbe()); 
    this.withStartupProbe(instance.getStartupProbe()); 
    this.withRequestResources(instance.getRequestResources()); 
    this.withLimitResources(instance.getLimitResources()); 
    this.withSidecars(instance.getSidecars()); 
    this.withExpose(instance.getExpose()); 
    this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
    this.withJobs(instance.getJobs()); 
    this.withCronJobs(instance.getCronJobs()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withReplicas(instance.getReplicas()); 
    this.withDeploymentStrategy(instance.getDeploymentStrategy()); 
    this.withRollingUpdate(instance.getRollingUpdate()); 
    this.withHeadless(instance.getHeadless()); 
  }
  private ArrayList<ContainerBuilder> initContainers = new java.util.ArrayList<ContainerBuilder>();
  private Integer replicas;
  private DeploymentStrategy deploymentStrategy;
  private RollingUpdateBuilder rollingUpdate;
  private Boolean headless;
  public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (io.dekorate.kubernetes.config.Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   */
  @Deprecated
  public io.dekorate.kubernetes.config.Container[] getInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;
io.dekorate.kubernetes.config.Container[] result = new io.dekorate.kubernetes.config.Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends io.dekorate.kubernetes.config.Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.kubernetes.config.Container[] buildInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;
io.dekorate.kubernetes.config.Container[] result = new io.dekorate.kubernetes.config.Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.dekorate.kubernetes.config.Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

  }
  public io.dekorate.kubernetes.config.Container buildInitContainer(java.lang.Integer index) {
    return this.initContainers.get(index).build();
  }
  public io.dekorate.kubernetes.config.Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public io.dekorate.kubernetes.config.Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public io.dekorate.kubernetes.config.Container buildMatchingInitContainer(Predicate<io.dekorate.kubernetes.config.ContainerBuilder> predicate) {
    for (io.dekorate.kubernetes.config.ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingInitContainer(java.util.function.Predicate<io.dekorate.kubernetes.config.ContainerBuilder> predicate) {
    for (io.dekorate.kubernetes.config.ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToInitContainers(java.lang.Integer index,io.dekorate.kubernetes.config.Container item) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.dekorate.kubernetes.config.ContainerBuilder>();}
    io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(java.lang.Integer index,io.dekorate.kubernetes.config.Container item) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.dekorate.kubernetes.config.ContainerBuilder>();}
    io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.dekorate.kubernetes.config.ContainerBuilder>();}
    for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<io.dekorate.kubernetes.config.Container> items) {
    if (this.initContainers == null) {this.initContainers = new java.util.ArrayList<io.dekorate.kubernetes.config.ContainerBuilder>();}
    for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items) {
    for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(java.util.Collection<io.dekorate.kubernetes.config.Container> items) {
    for (io.dekorate.kubernetes.config.Container item : items) {io.dekorate.kubernetes.config.ContainerBuilder builder = new io.dekorate.kubernetes.config.ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(java.util.function.Predicate<io.dekorate.kubernetes.config.ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<io.dekorate.kubernetes.config.ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      io.dekorate.kubernetes.config.ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public java.lang.Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainer() {
    return new KubernetesConfigFluentImpl.InitContainersNestedImpl();
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<A> addNewInitContainerLike(io.dekorate.kubernetes.config.Container item) {
    return new KubernetesConfigFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<A> setNewInitContainerLike(java.lang.Integer index,io.dekorate.kubernetes.config.Container item) {
    return new io.dekorate.kubernetes.config.KubernetesConfigFluentImpl.InitContainersNestedImpl(index, item);
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<A> editInitContainer(java.lang.Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<A> editMatchingInitContainer(java.util.function.Predicate<io.dekorate.kubernetes.config.ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public io.dekorate.kubernetes.config.DeploymentStrategy getDeploymentStrategy() {
    return this.deploymentStrategy;
  }
  public A withDeploymentStrategy(io.dekorate.kubernetes.config.DeploymentStrategy deploymentStrategy) {
    this.deploymentStrategy=deploymentStrategy; return (A) this;
  }
  public java.lang.Boolean hasDeploymentStrategy() {
    return this.deploymentStrategy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRollingUpdate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.dekorate.kubernetes.config.RollingUpdate getRollingUpdate() {
    return this.rollingUpdate!=null ?this.rollingUpdate.build():null;
  }
  public io.dekorate.kubernetes.config.RollingUpdate buildRollingUpdate() {
    return this.rollingUpdate!=null ?this.rollingUpdate.build():null;
  }
  public A withRollingUpdate(io.dekorate.kubernetes.config.RollingUpdate rollingUpdate) {
    _visitables.get("rollingUpdate").remove(this.rollingUpdate);
    if (rollingUpdate!=null){ this.rollingUpdate= new RollingUpdateBuilder(rollingUpdate); _visitables.get("rollingUpdate").add(this.rollingUpdate);} return (A) this;
  }
  public java.lang.Boolean hasRollingUpdate() {
    return this.rollingUpdate != null;
  }
  public A withNewRollingUpdate(String maxUnavailable,java.lang.String maxSurge) {
    return (A)withRollingUpdate(new RollingUpdate(maxUnavailable, maxSurge));
  }
  public KubernetesConfigFluent.RollingUpdateNested<A> withNewRollingUpdate() {
    return new KubernetesConfigFluentImpl.RollingUpdateNestedImpl();
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.RollingUpdateNested<A> withNewRollingUpdateLike(io.dekorate.kubernetes.config.RollingUpdate item) {
    return new io.dekorate.kubernetes.config.KubernetesConfigFluentImpl.RollingUpdateNestedImpl(item);
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.RollingUpdateNested<A> editRollingUpdate() {
    return withNewRollingUpdateLike(getRollingUpdate());
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.RollingUpdateNested<A> editOrNewRollingUpdate() {
    return withNewRollingUpdateLike(getRollingUpdate() != null ? getRollingUpdate(): new io.dekorate.kubernetes.config.RollingUpdateBuilder().build());
  }
  public io.dekorate.kubernetes.config.KubernetesConfigFluent.RollingUpdateNested<A> editOrNewRollingUpdateLike(io.dekorate.kubernetes.config.RollingUpdate item) {
    return withNewRollingUpdateLike(getRollingUpdate() != null ? getRollingUpdate(): item);
  }
  public java.lang.Boolean getHeadless() {
    return this.headless;
  }
  public A withHeadless(java.lang.Boolean headless) {
    this.headless=headless; return (A) this;
  }
  public java.lang.Boolean hasHeadless() {
    return this.headless != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesConfigFluentImpl that = (KubernetesConfigFluentImpl) o;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (deploymentStrategy != null ? !deploymentStrategy.equals(that.deploymentStrategy) :that.deploymentStrategy != null) return false;
    if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
    if (headless != null ? !headless.equals(that.headless) :that.headless != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  deploymentStrategy,  rollingUpdate,  headless,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (deploymentStrategy != null) { sb.append("deploymentStrategy:"); sb.append(deploymentStrategy + ","); }
    if (rollingUpdate != null) { sb.append("rollingUpdate:"); sb.append(rollingUpdate + ","); }
    if (headless != null) { sb.append("headless:"); sb.append(headless); }
    sb.append("}");
    return sb.toString();
  }
  public A withHeadless() {
    return withHeadless(true);
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<KubernetesConfigFluent.InitContainersNested<N>> implements io.dekorate.kubernetes.config.KubernetesConfigFluent.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(java.lang.Integer index,io.dekorate.kubernetes.config.Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new io.dekorate.kubernetes.config.ContainerBuilder(this);
    }
    io.dekorate.kubernetes.config.ContainerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) KubernetesConfigFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class RollingUpdateNestedImpl<N> extends RollingUpdateFluentImpl<KubernetesConfigFluent.RollingUpdateNested<N>> implements io.dekorate.kubernetes.config.KubernetesConfigFluent.RollingUpdateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    RollingUpdateNestedImpl(io.dekorate.kubernetes.config.RollingUpdate item) {
      this.builder = new RollingUpdateBuilder(this, item);
    }
    RollingUpdateNestedImpl() {
      this.builder = new io.dekorate.kubernetes.config.RollingUpdateBuilder(this);
    }
    io.dekorate.kubernetes.config.RollingUpdateBuilder builder;
    public N and() {
      return (N) KubernetesConfigFluentImpl.this.withRollingUpdate(builder.build());
    }
    public N endRollingUpdate() {
      return and();
    }
    
  }
  
}