/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.IngressRule;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.builder.TypedVisitor;
import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1.HTTPIngressRuleValueFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent;
import io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort;
import io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortBuilder;
import java.util.Arrays;
import java.util.Optional;

public class AddIngressRuleDecorator
extends NamedResourceDecorator<IngressSpecBuilder> {
    private static final String DEFAULT_PREFIX = "Prefix";
    private static final String DEFAULT_PATH = "/";
    private final BaseConfig config;
    private final IngressRule rule;

    public AddIngressRuleDecorator(BaseConfig config, IngressRule rule) {
        super(config.getName());
        this.config = config;
        this.rule = rule;
    }

    @Override
    public void andThenVisit(IngressSpecBuilder spec, ObjectMeta meta) {
        Optional<Port> defaultHostPort = Arrays.asList(this.config.getPorts()).stream().filter(AddServiceResourceDecorator.distinct(p -> p.getName())).findFirst();
        if (!spec.hasMatchingRule(existingRule -> Strings.equals((String)this.rule.getHost(), (String)existingRule.getHost())).booleanValue()) {
            ((IngressSpecFluent.RulesNested)((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)((IngressSpecFluent.RulesNested)spec.addNewRule().withHost(this.rule.getHost())).withNewHttp().addNewPath().withPathType(Strings.defaultIfEmpty((String)this.rule.getPathType(), (String)DEFAULT_PREFIX))).withPath(Strings.defaultIfEmpty((String)this.rule.getPath(), (String)DEFAULT_PATH))).withNewBackend().withNewService().withName(this.serviceName())).withPort(this.createPort(defaultHostPort))).endService()).endBackend()).endPath()).endHttp()).endRule();
        } else {
            spec.accept(new Visitor[]{new HostVisitor(defaultHostPort)});
        }
    }

    private String serviceName() {
        return Strings.defaultIfEmpty((String)this.rule.getServiceName(), (String)this.name);
    }

    private ServiceBackendPort createPort(Optional<Port> defaultHostPort) {
        ServiceBackendPortBuilder builder = new ServiceBackendPortBuilder();
        if (Strings.isNotNullOrEmpty((String)this.rule.getServicePortName())) {
            builder.withName(this.rule.getServicePortName());
        } else if (this.rule.getServicePortNumber() != null && this.rule.getServicePortNumber() >= 0) {
            builder.withNumber(this.rule.getServicePortNumber());
        } else if (Strings.isNullOrEmpty((String)this.rule.getServiceName()) || Strings.equals((String)this.rule.getServiceName(), (String)this.name)) {
            Port servicePort = defaultHostPort.orElseThrow(() -> new RuntimeException("Could not find any matching port to configure the Ingress Rule. Specify the service port using `kubernetes.ingress.service-port-name`"));
            builder.withName(servicePort.getName());
        } else {
            throw new RuntimeException("The service port for '" + this.rule.getServiceName() + "' was not set. Specify one using `kubernetes.ingress.service-port-name`");
        }
        return builder.build();
    }

    private class ServiceVisitor
    extends TypedVisitor<IngressServiceBackendBuilder> {
        private final Optional<Port> defaultHostPort;

        public ServiceVisitor(Optional<Port> defaultHostPort) {
            this.defaultHostPort = defaultHostPort;
        }

        public void visit(IngressServiceBackendBuilder service) {
            ((IngressServiceBackendBuilder)service.withName(Strings.defaultIfEmpty((String)AddIngressRuleDecorator.this.rule.getServiceName(), (String)AddIngressRuleDecorator.this.name))).withPort(AddIngressRuleDecorator.this.createPort(this.defaultHostPort));
        }
    }

    private class PathVisitor
    extends TypedVisitor<HTTPIngressPathBuilder> {
        private final Optional<Port> defaultHostPort;

        public PathVisitor(Optional<Port> defaultHostPort) {
            this.defaultHostPort = defaultHostPort;
        }

        public void visit(HTTPIngressPathBuilder existingPath) {
            if (Strings.equals((String)existingPath.getPath(), (String)AddIngressRuleDecorator.this.rule.getPath())) {
                if (!existingPath.hasBackend().booleanValue()) {
                    ((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressBackendFluent.ServiceNested)existingPath.withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.serviceName())).withPort(AddIngressRuleDecorator.this.createPort(this.defaultHostPort))).endService()).endBackend();
                } else {
                    existingPath.accept(new Visitor[]{new ServiceVisitor(this.defaultHostPort)});
                }
            }
        }
    }

    private class HostVisitor
    extends TypedVisitor<IngressRuleBuilder> {
        private final Optional<Port> defaultHostPort;

        public HostVisitor(Optional<Port> defaultHostPort) {
            this.defaultHostPort = defaultHostPort;
        }

        public void visit(IngressRuleBuilder existingRule) {
            if (Strings.equals((String)existingRule.getHost(), (String)AddIngressRuleDecorator.this.rule.getHost())) {
                if (!existingRule.hasHttp().booleanValue()) {
                    ((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)existingRule.withNewHttp().addNewPath().withPathType(Strings.defaultIfEmpty((String)AddIngressRuleDecorator.this.rule.getPathType(), (String)AddIngressRuleDecorator.DEFAULT_PREFIX))).withPath(Strings.defaultIfEmpty((String)AddIngressRuleDecorator.this.rule.getPath(), (String)AddIngressRuleDecorator.DEFAULT_PATH))).withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.serviceName())).withPort(AddIngressRuleDecorator.this.createPort(this.defaultHostPort))).endService()).endBackend()).endPath()).endHttp();
                } else if (existingRule.getHttp().getPaths().stream().noneMatch(p -> Strings.equals((String)p.getPath(), (String)AddIngressRuleDecorator.this.rule.getPath()))) {
                    ((IngressRuleFluent.HttpNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressPathFluent.BackendNested)((IngressBackendFluent.ServiceNested)((IngressBackendFluent.ServiceNested)((HTTPIngressRuleValueFluent.PathsNested)((HTTPIngressRuleValueFluent.PathsNested)existingRule.editHttp().addNewPath().withPathType(Strings.defaultIfEmpty((String)AddIngressRuleDecorator.this.rule.getPathType(), (String)AddIngressRuleDecorator.DEFAULT_PREFIX))).withPath(Strings.defaultIfEmpty((String)AddIngressRuleDecorator.this.rule.getPath(), (String)AddIngressRuleDecorator.DEFAULT_PATH))).withNewBackend().withNewService().withName(AddIngressRuleDecorator.this.serviceName())).withPort(AddIngressRuleDecorator.this.createPort(this.defaultHostPort))).endService()).endBackend()).endPath()).endHttp();
                } else {
                    existingRule.accept(new Visitor[]{new PathVisitor(this.defaultHostPort)});
                }
            }
        }
    }
}

