package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class Ingress{
  public Ingress() {
  }
  public Ingress(String host,Boolean expose,String tlsSecretName,String[] tlsHosts,IngressRule[] rules) {
    this.host = host;
    this.expose = expose;
    this.tlsSecretName = tlsSecretName;
    this.tlsHosts = tlsHosts != null ? tlsHosts : new String[0];
    this.rules = rules != null ? rules : new IngressRule[0];
  }
  private String host;
  private Boolean expose;
  private String tlsSecretName;
  private String[] tlsHosts = new String[0];
  private IngressRule[] rules = new IngressRule[0];
  
  /**
   * The host under which the application is going to be exposed.
   * @return The hostname.
   */
public String getHost() {
    return this.host;
  }
  
  /**
   * Controls whether the application should be exposed via Ingress
   */
public Boolean getExpose() {
    return this.expose;
  }
  
  /**
   * Controls whether the application should be exposed via Ingress
   */
public boolean isExpose() {
    return this.expose != null &&  this.expose;
  }
  
  /**
   * @return The name of the secret used to configure TLS.
   */
public String getTlsSecretName() {
    return this.tlsSecretName;
  }
  
  /**
   * @return The list of hosts to be included in the TLS certificate. By default, it will use the application host.
   */
public String[] getTlsHosts() {
    return this.tlsHosts;
  }
  
  /**
   * Controls the generated ingress rules to be exposed as part of the Ingress resource.
   */
public IngressRule[] getRules() {
    return this.rules;
  }
  public static IngressBuilder newBuilder() {
    return new IngressBuilder();
  }
  public static IngressBuilder newBuilderFromDefaults() {
    return new IngressBuilder().withExpose(false);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Ingress that = (Ingress) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (expose != null ? !expose.equals(that.expose) :that.expose != null) return false;
    if (tlsSecretName != null ? !tlsSecretName.equals(that.tlsSecretName) :that.tlsSecretName != null) return false;
    if (tlsHosts != null ? !tlsHosts.equals(that.tlsHosts) :that.tlsHosts != null) return false;
    if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  expose,  tlsSecretName,  tlsHosts,  rules,  super.hashCode());
  }
  
}