/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.EditableIngress;
import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.config.IngressFluent;
import io.dekorate.kubernetes.config.IngressFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class IngressBuilder
extends IngressFluentImpl<IngressBuilder>
implements VisitableBuilder<Ingress, IngressBuilder> {
    IngressFluent<?> fluent;
    Boolean validationEnabled;

    public IngressBuilder() {
        this(false);
    }

    public IngressBuilder(Boolean validationEnabled) {
        this(new Ingress(), validationEnabled);
    }

    public IngressBuilder(IngressFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public IngressBuilder(IngressFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Ingress(), validationEnabled);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance) {
        this(fluent, instance, false);
    }

    public IngressBuilder(IngressFluent<?> fluent, Ingress instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHost(instance.getHost());
        fluent.withExpose(instance.getExpose());
        fluent.withTlsSecretName(instance.getTlsSecretName());
        fluent.withTlsHosts(instance.getTlsHosts());
        fluent.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public IngressBuilder(Ingress instance) {
        this(instance, (Boolean)false);
    }

    public IngressBuilder(Ingress instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHost(instance.getHost());
        this.withExpose(instance.getExpose());
        this.withTlsSecretName(instance.getTlsSecretName());
        this.withTlsHosts(instance.getTlsHosts());
        this.withRules(instance.getRules());
        this.validationEnabled = validationEnabled;
    }

    public EditableIngress build() {
        EditableIngress buildable = new EditableIngress(this.fluent.getHost(), this.fluent.getExpose(), this.fluent.getTlsSecretName(), this.fluent.getTlsHosts(), this.fluent.getRules());
        return buildable;
    }
}

