package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface IngressFluent<A extends IngressFluent<A>> extends Fluent<A>{
  public String getHost();
  public A withHost(String host);
  public Boolean hasHost();
  public String getIngressClassName();
  public A withIngressClassName(String ingressClassName);
  public Boolean hasIngressClassName();
  public String getTargetPort();
  public A withTargetPort(String targetPort);
  public Boolean hasTargetPort();
  public Boolean getExpose();
  public A withExpose(Boolean expose);
  public Boolean hasExpose();
  public String getTlsSecretName();
  public A withTlsSecretName(String tlsSecretName);
  public Boolean hasTlsSecretName();
  public A withTlsHosts(java.lang.String... tlsHosts);
  public String[] getTlsHosts();
  public A addToTlsHosts(Integer index,String item);
  public A setToTlsHosts(Integer index,String item);
  public A addToTlsHosts(java.lang.String... items);
  public A addAllToTlsHosts(Collection<String> items);
  public A removeFromTlsHosts(java.lang.String... items);
  public A removeAllFromTlsHosts(Collection<String> items);
  public Boolean hasTlsHosts();
  public A withRules(io.dekorate.kubernetes.config.IngressRule... rules);
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   */
  @Deprecated
  public IngressRule[] getRules();
  public IngressRule[] buildRules();
  public IngressRule buildRule(Integer index);
  public IngressRule buildFirstRule();
  public IngressRule buildLastRule();
  public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate);
  public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate);
  public A addToRules(Integer index,IngressRule item);
  public A setToRules(Integer index,IngressRule item);
  public A addToRules(io.dekorate.kubernetes.config.IngressRule... items);
  public A addAllToRules(Collection<IngressRule> items);
  public A removeFromRules(io.dekorate.kubernetes.config.IngressRule... items);
  public A removeAllFromRules(Collection<IngressRule> items);
  public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate);
  public Boolean hasRules();
  public IngressFluent.RulesNested<A> addNewRule();
  public IngressFluent.RulesNested<A> addNewRuleLike(IngressRule item);
  public IngressFluent.RulesNested<A> setNewRuleLike(Integer index,IngressRule item);
  public IngressFluent.RulesNested<A> editRule(Integer index);
  public IngressFluent.RulesNested<A> editFirstRule();
  public IngressFluent.RulesNested<A> editLastRule();
  public IngressFluent.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate);
  public A withExpose();
  public interface RulesNested<N> extends Nested<N>,IngressRuleFluent<IngressFluent.RulesNested<N>>{
    public N and();
    public N endRule();
    
  }
  
}