/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.ItemBuilder;
import io.dekorate.kubernetes.config.ItemFluentImpl;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class SecretVolumeFluentImpl<A extends SecretVolumeFluent<A>>
extends BaseFluent<A>
implements SecretVolumeFluent<A> {
    private String volumeName;
    private String secretName;
    private Integer defaultMode;
    private Boolean optional;
    private ArrayList<ItemBuilder> items = new ArrayList();

    public SecretVolumeFluentImpl() {
    }

    public SecretVolumeFluentImpl(SecretVolume instance) {
        this.withVolumeName(instance.getVolumeName());
        this.withSecretName(instance.getSecretName());
        this.withDefaultMode(instance.getDefaultMode());
        this.withOptional(instance.getOptional());
        this.withItems(instance.getItems());
    }

    @Override
    public String getVolumeName() {
        return this.volumeName;
    }

    @Override
    public A withVolumeName(String volumeName) {
        this.volumeName = volumeName;
        return (A)this;
    }

    @Override
    public Boolean hasVolumeName() {
        return this.volumeName != null;
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public Boolean getOptional() {
        return this.optional;
    }

    @Override
    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    @Override
    public Boolean hasOptional() {
        return this.optional != null;
    }

    @Override
    public A withItems(Item ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (Item item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Item[] getItems() {
        int size = this.items != null ? this.items.size() : 0;
        Item[] result = new Item[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.items) {
            result[index++] = (Item)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Item[] buildItems() {
        int size = this.items != null ? this.items.size() : 0;
        Item[] result = new Item[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.items) {
            result[index++] = (Item)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Item buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public Item buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public Item buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public Item buildMatchingItem(Predicate<ItemBuilder> predicate) {
        for (ItemBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ItemBuilder> predicate) {
        for (ItemBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToItems(Integer index, Item item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ItemBuilder builder = new ItemBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, Item item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ItemBuilder builder = new ItemBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(Item ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<Item> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(Item ... items) {
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<Item> items) {
        for (Item item : items) {
            ItemBuilder builder = new ItemBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ItemBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ItemBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ItemBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public A addNewItem(String key, String path, Integer mode) {
        return this.addToItems(new Item(key, path, mode));
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> addNewItemLike(Item item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> setNewItemLike(Integer index, Item item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public SecretVolumeFluent.ItemsNested<A> editMatchingItem(Predicate<ItemBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecretVolumeFluentImpl that = (SecretVolumeFluentImpl)o;
        if (this.volumeName != null ? !this.volumeName.equals(that.volumeName) : that.volumeName != null) {
            return false;
        }
        if (this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null) {
            return false;
        }
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        if (this.optional != null ? !this.optional.equals(that.optional) : that.optional != null) {
            return false;
        }
        return !(this.items != null ? !this.items.equals(that.items) : that.items != null);
    }

    public int hashCode() {
        return Objects.hash(this.volumeName, this.secretName, this.defaultMode, this.optional, this.items, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.volumeName != null) {
            sb.append("volumeName:");
            sb.append(this.volumeName + ",");
        }
        if (this.secretName != null) {
            sb.append("secretName:");
            sb.append(this.secretName + ",");
        }
        if (this.defaultMode != null) {
            sb.append("defaultMode:");
            sb.append(this.defaultMode + ",");
        }
        if (this.optional != null) {
            sb.append("optional:");
            sb.append(this.optional + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withOptional() {
        return this.withOptional(true);
    }

    class ItemsNestedImpl<N>
    extends ItemFluentImpl<SecretVolumeFluent.ItemsNested<N>>
    implements SecretVolumeFluent.ItemsNested<N>,
    Nested<N> {
        ItemBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, Item item) {
            this.index = index;
            this.builder = new ItemBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ItemBuilder(this);
        }

        @Override
        public N and() {
            return (N)SecretVolumeFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

