/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy;
import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeBuilder;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolumeFluentImpl;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureDiskVolumeBuilder;
import io.dekorate.kubernetes.config.AzureDiskVolumeFluentImpl;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.AzureFileVolumeBuilder;
import io.dekorate.kubernetes.config.AzureFileVolumeFluentImpl;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.ConfigMapVolumeBuilder;
import io.dekorate.kubernetes.config.ConfigMapVolumeFluentImpl;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.ContainerFluentImpl;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.config.CronJobFluent;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.EmptyDirVolumeBuilder;
import io.dekorate.kubernetes.config.EmptyDirVolumeFluentImpl;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolumeFluentImpl;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.kubernetes.config.SecretVolumeBuilder;
import io.dekorate.kubernetes.config.SecretVolumeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class CronJobFluentImpl<A extends CronJobFluent<A>>
extends BaseFluent<A>
implements CronJobFluent<A> {
    private String name;
    private String schedule;
    private CronJobConcurrencyPolicy concurrencyPolicy;
    private Long startingDeadlineSeconds;
    private Integer failedJobsHistoryLimit;
    private Integer successfulJobsHistoryLimit;
    private Integer parallelism;
    private Integer completions;
    private JobCompletionMode completionMode;
    private Integer backoffLimit;
    private Long activeDeadlineSeconds;
    private Integer ttlSecondsAfterFinished;
    private Boolean suspend;
    private JobRestartPolicy restartPolicy;
    private ArrayList<PersistentVolumeClaimVolumeBuilder> pvcVolumes = new ArrayList();
    private ArrayList<SecretVolumeBuilder> secretVolumes = new ArrayList();
    private ArrayList<ConfigMapVolumeBuilder> configMapVolumes = new ArrayList();
    private ArrayList<EmptyDirVolumeBuilder> emptyDirVolumes = new ArrayList();
    private ArrayList<AwsElasticBlockStoreVolumeBuilder> awsElasticBlockStoreVolumes = new ArrayList();
    private ArrayList<AzureDiskVolumeBuilder> azureDiskVolumes = new ArrayList();
    private ArrayList<AzureFileVolumeBuilder> azureFileVolumes = new ArrayList();
    private ArrayList<ContainerBuilder> containers = new ArrayList();

    public CronJobFluentImpl() {
    }

    public CronJobFluentImpl(CronJob instance) {
        this.withName(instance.getName());
        this.withSchedule(instance.getSchedule());
        this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
        this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
        this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
        this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
        this.withParallelism(instance.getParallelism());
        this.withCompletions(instance.getCompletions());
        this.withCompletionMode(instance.getCompletionMode());
        this.withBackoffLimit(instance.getBackoffLimit());
        this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
        this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
        this.withSuspend(instance.getSuspend());
        this.withRestartPolicy(instance.getRestartPolicy());
        this.withPvcVolumes(instance.getPvcVolumes());
        this.withSecretVolumes(instance.getSecretVolumes());
        this.withConfigMapVolumes(instance.getConfigMapVolumes());
        this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
        this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
        this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
        this.withAzureFileVolumes(instance.getAzureFileVolumes());
        this.withContainers(instance.getContainers());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)this;
    }

    @Override
    public Boolean hasSchedule() {
        return this.schedule != null;
    }

    @Override
    public CronJobConcurrencyPolicy getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    @Override
    public A withConcurrencyPolicy(CronJobConcurrencyPolicy concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasConcurrencyPolicy() {
        return this.concurrencyPolicy != null;
    }

    @Override
    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    @Override
    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds != null;
    }

    @Override
    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    @Override
    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    @Override
    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    @Override
    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    @Override
    public Integer getParallelism() {
        return this.parallelism;
    }

    @Override
    public A withParallelism(Integer parallelism) {
        this.parallelism = parallelism;
        return (A)this;
    }

    @Override
    public Boolean hasParallelism() {
        return this.parallelism != null;
    }

    @Override
    public Integer getCompletions() {
        return this.completions;
    }

    @Override
    public A withCompletions(Integer completions) {
        this.completions = completions;
        return (A)this;
    }

    @Override
    public Boolean hasCompletions() {
        return this.completions != null;
    }

    @Override
    public JobCompletionMode getCompletionMode() {
        return this.completionMode;
    }

    @Override
    public A withCompletionMode(JobCompletionMode completionMode) {
        this.completionMode = completionMode;
        return (A)this;
    }

    @Override
    public Boolean hasCompletionMode() {
        return this.completionMode != null;
    }

    @Override
    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    @Override
    public A withBackoffLimit(Integer backoffLimit) {
        this.backoffLimit = backoffLimit;
        return (A)this;
    }

    @Override
    public Boolean hasBackoffLimit() {
        return this.backoffLimit != null;
    }

    @Override
    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    @Override
    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds != null;
    }

    @Override
    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    @Override
    public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        return (A)this;
    }

    @Override
    public Boolean hasTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished != null;
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    public JobRestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    @Override
    public A withRestartPolicy(JobRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    @Override
    public A withPvcVolumes(PersistentVolumeClaimVolume ... pvcVolumes) {
        if (this.pvcVolumes != null) {
            this.pvcVolumes.clear();
        }
        if (pvcVolumes != null) {
            for (PersistentVolumeClaimVolume item : pvcVolumes) {
                this.addToPvcVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public PersistentVolumeClaimVolume[] getPvcVolumes() {
        int size = this.pvcVolumes != null ? this.pvcVolumes.size() : 0;
        PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.pvcVolumes) {
            result[index++] = (PersistentVolumeClaimVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public PersistentVolumeClaimVolume[] buildPvcVolumes() {
        int size = this.pvcVolumes != null ? this.pvcVolumes.size() : 0;
        PersistentVolumeClaimVolume[] result = new PersistentVolumeClaimVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.pvcVolumes) {
            result[index++] = (PersistentVolumeClaimVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public PersistentVolumeClaimVolume buildPvcVolume(Integer index) {
        return this.pvcVolumes.get(index).build();
    }

    @Override
    public PersistentVolumeClaimVolume buildFirstPvcVolume() {
        return this.pvcVolumes.get(0).build();
    }

    @Override
    public PersistentVolumeClaimVolume buildLastPvcVolume() {
        return this.pvcVolumes.get(this.pvcVolumes.size() - 1).build();
    }

    @Override
    public PersistentVolumeClaimVolume buildMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        for (PersistentVolumeClaimVolumeBuilder item : this.pvcVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToPvcVolumes(Integer index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        this._visitables.get((Object)"pvcVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"pvcVolumes").size(), builder);
        this.pvcVolumes.add(index >= 0 ? index.intValue() : this.pvcVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPvcVolumes(Integer index, PersistentVolumeClaimVolume item) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"pvcVolumes").size()) {
            this._visitables.get((Object)"pvcVolumes").add(builder);
        } else {
            this._visitables.get((Object)"pvcVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.pvcVolumes.size()) {
            this.pvcVolumes.add(builder);
        } else {
            this.pvcVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPvcVolumes(PersistentVolumeClaimVolume ... items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        if (this.pvcVolumes == null) {
            this.pvcVolumes = new ArrayList();
        }
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").add(builder);
            this.pvcVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPvcVolumes(PersistentVolumeClaimVolume ... items) {
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove(builder);
            if (this.pvcVolumes == null) continue;
            this.pvcVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPvcVolumes(Collection<PersistentVolumeClaimVolume> items) {
        for (PersistentVolumeClaimVolume item : items) {
            PersistentVolumeClaimVolumeBuilder builder = new PersistentVolumeClaimVolumeBuilder(item);
            this._visitables.get((Object)"pvcVolumes").remove(builder);
            if (this.pvcVolumes == null) continue;
            this.pvcVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPvcVolumes(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        if (this.pvcVolumes == null) {
            return (A)this;
        }
        Iterator<PersistentVolumeClaimVolumeBuilder> each = this.pvcVolumes.iterator();
        List visitables = this._visitables.get((Object)"pvcVolumes");
        while (each.hasNext()) {
            PersistentVolumeClaimVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasPvcVolumes() {
        return this.pvcVolumes != null && !this.pvcVolumes.isEmpty();
    }

    @Override
    public A addNewPvcVolume(String volumeName, String claimName, Boolean readOnly) {
        return this.addToPvcVolumes(new PersistentVolumeClaimVolume(volumeName, claimName, readOnly));
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> addNewPvcVolume() {
        return new PvcVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> addNewPvcVolumeLike(PersistentVolumeClaimVolume item) {
        return new PvcVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> setNewPvcVolumeLike(Integer index, PersistentVolumeClaimVolume item) {
        return new PvcVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> editPvcVolume(Integer index) {
        if (this.pvcVolumes.size() <= index) {
            throw new RuntimeException("Can't edit pvcVolumes. Index exceeds size.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> editFirstPvcVolume() {
        if (this.pvcVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(0, this.buildPvcVolume(0));
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> editLastPvcVolume() {
        int index = this.pvcVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pvcVolumes. The list is empty.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    @Override
    public CronJobFluent.PvcVolumesNested<A> editMatchingPvcVolume(Predicate<PersistentVolumeClaimVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pvcVolumes.size(); ++i) {
            if (!predicate.test(this.pvcVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pvcVolumes. No match found.");
        }
        return this.setNewPvcVolumeLike(index, this.buildPvcVolume(index));
    }

    @Override
    public A withSecretVolumes(SecretVolume ... secretVolumes) {
        if (this.secretVolumes != null) {
            this.secretVolumes.clear();
        }
        if (secretVolumes != null) {
            for (SecretVolume item : secretVolumes) {
                this.addToSecretVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public SecretVolume[] getSecretVolumes() {
        int size = this.secretVolumes != null ? this.secretVolumes.size() : 0;
        SecretVolume[] result = new SecretVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.secretVolumes) {
            result[index++] = (SecretVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public SecretVolume[] buildSecretVolumes() {
        int size = this.secretVolumes != null ? this.secretVolumes.size() : 0;
        SecretVolume[] result = new SecretVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.secretVolumes) {
            result[index++] = (SecretVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public SecretVolume buildSecretVolume(Integer index) {
        return this.secretVolumes.get(index).build();
    }

    @Override
    public SecretVolume buildFirstSecretVolume() {
        return this.secretVolumes.get(0).build();
    }

    @Override
    public SecretVolume buildLastSecretVolume() {
        return this.secretVolumes.get(this.secretVolumes.size() - 1).build();
    }

    @Override
    public SecretVolume buildMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        for (SecretVolumeBuilder item : this.secretVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToSecretVolumes(Integer index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        this._visitables.get((Object)"secretVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"secretVolumes").size(), builder);
        this.secretVolumes.add(index >= 0 ? index.intValue() : this.secretVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecretVolumes(Integer index, SecretVolume item) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"secretVolumes").size()) {
            this._visitables.get((Object)"secretVolumes").add(builder);
        } else {
            this._visitables.get((Object)"secretVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.secretVolumes.size()) {
            this.secretVolumes.add(builder);
        } else {
            this.secretVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecretVolumes(SecretVolume ... items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecretVolumes(Collection<SecretVolume> items) {
        if (this.secretVolumes == null) {
            this.secretVolumes = new ArrayList();
        }
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").add(builder);
            this.secretVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecretVolumes(SecretVolume ... items) {
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove(builder);
            if (this.secretVolumes == null) continue;
            this.secretVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecretVolumes(Collection<SecretVolume> items) {
        for (SecretVolume item : items) {
            SecretVolumeBuilder builder = new SecretVolumeBuilder(item);
            this._visitables.get((Object)"secretVolumes").remove(builder);
            if (this.secretVolumes == null) continue;
            this.secretVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecretVolumes(Predicate<SecretVolumeBuilder> predicate) {
        if (this.secretVolumes == null) {
            return (A)this;
        }
        Iterator<SecretVolumeBuilder> each = this.secretVolumes.iterator();
        List visitables = this._visitables.get((Object)"secretVolumes");
        while (each.hasNext()) {
            SecretVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecretVolumes() {
        return this.secretVolumes != null && !this.secretVolumes.isEmpty();
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> addNewSecretVolume() {
        return new SecretVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> addNewSecretVolumeLike(SecretVolume item) {
        return new SecretVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> setNewSecretVolumeLike(Integer index, SecretVolume item) {
        return new SecretVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> editSecretVolume(Integer index) {
        if (this.secretVolumes.size() <= index) {
            throw new RuntimeException("Can't edit secretVolumes. Index exceeds size.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> editFirstSecretVolume() {
        if (this.secretVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(0, this.buildSecretVolume(0));
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> editLastSecretVolume() {
        int index = this.secretVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secretVolumes. The list is empty.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    @Override
    public CronJobFluent.SecretVolumesNested<A> editMatchingSecretVolume(Predicate<SecretVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secretVolumes.size(); ++i) {
            if (!predicate.test(this.secretVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secretVolumes. No match found.");
        }
        return this.setNewSecretVolumeLike(index, this.buildSecretVolume(index));
    }

    @Override
    public A withConfigMapVolumes(ConfigMapVolume ... configMapVolumes) {
        if (this.configMapVolumes != null) {
            this.configMapVolumes.clear();
        }
        if (configMapVolumes != null) {
            for (ConfigMapVolume item : configMapVolumes) {
                this.addToConfigMapVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public ConfigMapVolume[] getConfigMapVolumes() {
        int size = this.configMapVolumes != null ? this.configMapVolumes.size() : 0;
        ConfigMapVolume[] result = new ConfigMapVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.configMapVolumes) {
            result[index++] = (ConfigMapVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ConfigMapVolume[] buildConfigMapVolumes() {
        int size = this.configMapVolumes != null ? this.configMapVolumes.size() : 0;
        ConfigMapVolume[] result = new ConfigMapVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.configMapVolumes) {
            result[index++] = (ConfigMapVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public ConfigMapVolume buildConfigMapVolume(Integer index) {
        return this.configMapVolumes.get(index).build();
    }

    @Override
    public ConfigMapVolume buildFirstConfigMapVolume() {
        return this.configMapVolumes.get(0).build();
    }

    @Override
    public ConfigMapVolume buildLastConfigMapVolume() {
        return this.configMapVolumes.get(this.configMapVolumes.size() - 1).build();
    }

    @Override
    public ConfigMapVolume buildMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        for (ConfigMapVolumeBuilder item : this.configMapVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToConfigMapVolumes(Integer index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        this._visitables.get((Object)"configMapVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"configMapVolumes").size(), builder);
        this.configMapVolumes.add(index >= 0 ? index.intValue() : this.configMapVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConfigMapVolumes(Integer index, ConfigMapVolume item) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"configMapVolumes").size()) {
            this._visitables.get((Object)"configMapVolumes").add(builder);
        } else {
            this._visitables.get((Object)"configMapVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.configMapVolumes.size()) {
            this.configMapVolumes.add(builder);
        } else {
            this.configMapVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConfigMapVolumes(ConfigMapVolume ... items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConfigMapVolumes(Collection<ConfigMapVolume> items) {
        if (this.configMapVolumes == null) {
            this.configMapVolumes = new ArrayList();
        }
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").add(builder);
            this.configMapVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConfigMapVolumes(ConfigMapVolume ... items) {
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove(builder);
            if (this.configMapVolumes == null) continue;
            this.configMapVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConfigMapVolumes(Collection<ConfigMapVolume> items) {
        for (ConfigMapVolume item : items) {
            ConfigMapVolumeBuilder builder = new ConfigMapVolumeBuilder(item);
            this._visitables.get((Object)"configMapVolumes").remove(builder);
            if (this.configMapVolumes == null) continue;
            this.configMapVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConfigMapVolumes(Predicate<ConfigMapVolumeBuilder> predicate) {
        if (this.configMapVolumes == null) {
            return (A)this;
        }
        Iterator<ConfigMapVolumeBuilder> each = this.configMapVolumes.iterator();
        List visitables = this._visitables.get((Object)"configMapVolumes");
        while (each.hasNext()) {
            ConfigMapVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigMapVolumes() {
        return this.configMapVolumes != null && !this.configMapVolumes.isEmpty();
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> addNewConfigMapVolume() {
        return new ConfigMapVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> addNewConfigMapVolumeLike(ConfigMapVolume item) {
        return new ConfigMapVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> setNewConfigMapVolumeLike(Integer index, ConfigMapVolume item) {
        return new ConfigMapVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> editConfigMapVolume(Integer index) {
        if (this.configMapVolumes.size() <= index) {
            throw new RuntimeException("Can't edit configMapVolumes. Index exceeds size.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> editFirstConfigMapVolume() {
        if (this.configMapVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(0, this.buildConfigMapVolume(0));
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> editLastConfigMapVolume() {
        int index = this.configMapVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last configMapVolumes. The list is empty.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    @Override
    public CronJobFluent.ConfigMapVolumesNested<A> editMatchingConfigMapVolume(Predicate<ConfigMapVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.configMapVolumes.size(); ++i) {
            if (!predicate.test(this.configMapVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching configMapVolumes. No match found.");
        }
        return this.setNewConfigMapVolumeLike(index, this.buildConfigMapVolume(index));
    }

    @Override
    public A withEmptyDirVolumes(EmptyDirVolume ... emptyDirVolumes) {
        if (this.emptyDirVolumes != null) {
            this.emptyDirVolumes.clear();
        }
        if (emptyDirVolumes != null) {
            for (EmptyDirVolume item : emptyDirVolumes) {
                this.addToEmptyDirVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public EmptyDirVolume[] getEmptyDirVolumes() {
        int size = this.emptyDirVolumes != null ? this.emptyDirVolumes.size() : 0;
        EmptyDirVolume[] result = new EmptyDirVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.emptyDirVolumes) {
            result[index++] = (EmptyDirVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public EmptyDirVolume[] buildEmptyDirVolumes() {
        int size = this.emptyDirVolumes != null ? this.emptyDirVolumes.size() : 0;
        EmptyDirVolume[] result = new EmptyDirVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.emptyDirVolumes) {
            result[index++] = (EmptyDirVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public EmptyDirVolume buildEmptyDirVolume(Integer index) {
        return this.emptyDirVolumes.get(index).build();
    }

    @Override
    public EmptyDirVolume buildFirstEmptyDirVolume() {
        return this.emptyDirVolumes.get(0).build();
    }

    @Override
    public EmptyDirVolume buildLastEmptyDirVolume() {
        return this.emptyDirVolumes.get(this.emptyDirVolumes.size() - 1).build();
    }

    @Override
    public EmptyDirVolume buildMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        for (EmptyDirVolumeBuilder item : this.emptyDirVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEmptyDirVolumes(Integer index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        this._visitables.get((Object)"emptyDirVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"emptyDirVolumes").size(), builder);
        this.emptyDirVolumes.add(index >= 0 ? index.intValue() : this.emptyDirVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEmptyDirVolumes(Integer index, EmptyDirVolume item) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"emptyDirVolumes").size()) {
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
        } else {
            this._visitables.get((Object)"emptyDirVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.emptyDirVolumes.size()) {
            this.emptyDirVolumes.add(builder);
        } else {
            this.emptyDirVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEmptyDirVolumes(EmptyDirVolume ... items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        if (this.emptyDirVolumes == null) {
            this.emptyDirVolumes = new ArrayList();
        }
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").add(builder);
            this.emptyDirVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEmptyDirVolumes(EmptyDirVolume ... items) {
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove(builder);
            if (this.emptyDirVolumes == null) continue;
            this.emptyDirVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEmptyDirVolumes(Collection<EmptyDirVolume> items) {
        for (EmptyDirVolume item : items) {
            EmptyDirVolumeBuilder builder = new EmptyDirVolumeBuilder(item);
            this._visitables.get((Object)"emptyDirVolumes").remove(builder);
            if (this.emptyDirVolumes == null) continue;
            this.emptyDirVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEmptyDirVolumes(Predicate<EmptyDirVolumeBuilder> predicate) {
        if (this.emptyDirVolumes == null) {
            return (A)this;
        }
        Iterator<EmptyDirVolumeBuilder> each = this.emptyDirVolumes.iterator();
        List visitables = this._visitables.get((Object)"emptyDirVolumes");
        while (each.hasNext()) {
            EmptyDirVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasEmptyDirVolumes() {
        return this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty();
    }

    @Override
    public A addNewEmptyDirVolume(String volumeName) {
        return this.addToEmptyDirVolumes(new EmptyDirVolume(volumeName));
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> addNewEmptyDirVolume() {
        return new EmptyDirVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> addNewEmptyDirVolumeLike(EmptyDirVolume item) {
        return new EmptyDirVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> setNewEmptyDirVolumeLike(Integer index, EmptyDirVolume item) {
        return new EmptyDirVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> editEmptyDirVolume(Integer index) {
        if (this.emptyDirVolumes.size() <= index) {
            throw new RuntimeException("Can't edit emptyDirVolumes. Index exceeds size.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> editFirstEmptyDirVolume() {
        if (this.emptyDirVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(0, this.buildEmptyDirVolume(0));
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> editLastEmptyDirVolume() {
        int index = this.emptyDirVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last emptyDirVolumes. The list is empty.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    @Override
    public CronJobFluent.EmptyDirVolumesNested<A> editMatchingEmptyDirVolume(Predicate<EmptyDirVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.emptyDirVolumes.size(); ++i) {
            if (!predicate.test(this.emptyDirVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching emptyDirVolumes. No match found.");
        }
        return this.setNewEmptyDirVolumeLike(index, this.buildEmptyDirVolume(index));
    }

    @Override
    public A withAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... awsElasticBlockStoreVolumes) {
        if (this.awsElasticBlockStoreVolumes != null) {
            this.awsElasticBlockStoreVolumes.clear();
        }
        if (awsElasticBlockStoreVolumes != null) {
            for (AwsElasticBlockStoreVolume item : awsElasticBlockStoreVolumes) {
                this.addToAwsElasticBlockStoreVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
        int size = this.awsElasticBlockStoreVolumes != null ? this.awsElasticBlockStoreVolumes.size() : 0;
        AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.awsElasticBlockStoreVolumes) {
            result[index++] = (AwsElasticBlockStoreVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AwsElasticBlockStoreVolume[] buildAwsElasticBlockStoreVolumes() {
        int size = this.awsElasticBlockStoreVolumes != null ? this.awsElasticBlockStoreVolumes.size() : 0;
        AwsElasticBlockStoreVolume[] result = new AwsElasticBlockStoreVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.awsElasticBlockStoreVolumes) {
            result[index++] = (AwsElasticBlockStoreVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AwsElasticBlockStoreVolume buildAwsElasticBlockStoreVolume(Integer index) {
        return this.awsElasticBlockStoreVolumes.get(index).build();
    }

    @Override
    public AwsElasticBlockStoreVolume buildFirstAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(0).build();
    }

    @Override
    public AwsElasticBlockStoreVolume buildLastAwsElasticBlockStoreVolume() {
        return this.awsElasticBlockStoreVolumes.get(this.awsElasticBlockStoreVolumes.size() - 1).build();
    }

    @Override
    public AwsElasticBlockStoreVolume buildMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        for (AwsElasticBlockStoreVolumeBuilder item : this.awsElasticBlockStoreVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAwsElasticBlockStoreVolumes(Integer index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"awsElasticBlockStoreVolumes").size(), builder);
        this.awsElasticBlockStoreVolumes.add(index >= 0 ? index.intValue() : this.awsElasticBlockStoreVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAwsElasticBlockStoreVolumes(Integer index, AwsElasticBlockStoreVolume item) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"awsElasticBlockStoreVolumes").size()) {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
        } else {
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.awsElasticBlockStoreVolumes.size()) {
            this.awsElasticBlockStoreVolumes.add(builder);
        } else {
            this.awsElasticBlockStoreVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        if (this.awsElasticBlockStoreVolumes == null) {
            this.awsElasticBlockStoreVolumes = new ArrayList();
        }
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").add(builder);
            this.awsElasticBlockStoreVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAwsElasticBlockStoreVolumes(AwsElasticBlockStoreVolume ... items) {
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove(builder);
            if (this.awsElasticBlockStoreVolumes == null) continue;
            this.awsElasticBlockStoreVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAwsElasticBlockStoreVolumes(Collection<AwsElasticBlockStoreVolume> items) {
        for (AwsElasticBlockStoreVolume item : items) {
            AwsElasticBlockStoreVolumeBuilder builder = new AwsElasticBlockStoreVolumeBuilder(item);
            this._visitables.get((Object)"awsElasticBlockStoreVolumes").remove(builder);
            if (this.awsElasticBlockStoreVolumes == null) continue;
            this.awsElasticBlockStoreVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAwsElasticBlockStoreVolumes(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        if (this.awsElasticBlockStoreVolumes == null) {
            return (A)this;
        }
        Iterator<AwsElasticBlockStoreVolumeBuilder> each = this.awsElasticBlockStoreVolumes.iterator();
        List visitables = this._visitables.get((Object)"awsElasticBlockStoreVolumes");
        while (each.hasNext()) {
            AwsElasticBlockStoreVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty();
    }

    @Override
    public A addNewAwsElasticBlockStoreVolume(String volumeName, String volumeId, Integer partition, String fsType, Boolean readOnly) {
        return this.addToAwsElasticBlockStoreVolumes(new AwsElasticBlockStoreVolume(volumeName, volumeId, partition, fsType, readOnly));
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolume() {
        return new AwsElasticBlockStoreVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> addNewAwsElasticBlockStoreVolumeLike(AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> setNewAwsElasticBlockStoreVolumeLike(Integer index, AwsElasticBlockStoreVolume item) {
        return new AwsElasticBlockStoreVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> editAwsElasticBlockStoreVolume(Integer index) {
        if (this.awsElasticBlockStoreVolumes.size() <= index) {
            throw new RuntimeException("Can't edit awsElasticBlockStoreVolumes. Index exceeds size.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> editFirstAwsElasticBlockStoreVolume() {
        if (this.awsElasticBlockStoreVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(0, this.buildAwsElasticBlockStoreVolume(0));
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> editLastAwsElasticBlockStoreVolume() {
        int index = this.awsElasticBlockStoreVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last awsElasticBlockStoreVolumes. The list is empty.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    @Override
    public CronJobFluent.AwsElasticBlockStoreVolumesNested<A> editMatchingAwsElasticBlockStoreVolume(Predicate<AwsElasticBlockStoreVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.awsElasticBlockStoreVolumes.size(); ++i) {
            if (!predicate.test(this.awsElasticBlockStoreVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching awsElasticBlockStoreVolumes. No match found.");
        }
        return this.setNewAwsElasticBlockStoreVolumeLike(index, this.buildAwsElasticBlockStoreVolume(index));
    }

    @Override
    public A withAzureDiskVolumes(AzureDiskVolume ... azureDiskVolumes) {
        if (this.azureDiskVolumes != null) {
            this.azureDiskVolumes.clear();
        }
        if (azureDiskVolumes != null) {
            for (AzureDiskVolume item : azureDiskVolumes) {
                this.addToAzureDiskVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AzureDiskVolume[] getAzureDiskVolumes() {
        int size = this.azureDiskVolumes != null ? this.azureDiskVolumes.size() : 0;
        AzureDiskVolume[] result = new AzureDiskVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureDiskVolumes) {
            result[index++] = (AzureDiskVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureDiskVolume[] buildAzureDiskVolumes() {
        int size = this.azureDiskVolumes != null ? this.azureDiskVolumes.size() : 0;
        AzureDiskVolume[] result = new AzureDiskVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureDiskVolumes) {
            result[index++] = (AzureDiskVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureDiskVolume buildAzureDiskVolume(Integer index) {
        return this.azureDiskVolumes.get(index).build();
    }

    @Override
    public AzureDiskVolume buildFirstAzureDiskVolume() {
        return this.azureDiskVolumes.get(0).build();
    }

    @Override
    public AzureDiskVolume buildLastAzureDiskVolume() {
        return this.azureDiskVolumes.get(this.azureDiskVolumes.size() - 1).build();
    }

    @Override
    public AzureDiskVolume buildMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        for (AzureDiskVolumeBuilder item : this.azureDiskVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAzureDiskVolumes(Integer index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        this._visitables.get((Object)"azureDiskVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"azureDiskVolumes").size(), builder);
        this.azureDiskVolumes.add(index >= 0 ? index.intValue() : this.azureDiskVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAzureDiskVolumes(Integer index, AzureDiskVolume item) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"azureDiskVolumes").size()) {
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
        } else {
            this._visitables.get((Object)"azureDiskVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.azureDiskVolumes.size()) {
            this.azureDiskVolumes.add(builder);
        } else {
            this.azureDiskVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAzureDiskVolumes(AzureDiskVolume ... items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        if (this.azureDiskVolumes == null) {
            this.azureDiskVolumes = new ArrayList();
        }
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").add(builder);
            this.azureDiskVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAzureDiskVolumes(AzureDiskVolume ... items) {
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove(builder);
            if (this.azureDiskVolumes == null) continue;
            this.azureDiskVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAzureDiskVolumes(Collection<AzureDiskVolume> items) {
        for (AzureDiskVolume item : items) {
            AzureDiskVolumeBuilder builder = new AzureDiskVolumeBuilder(item);
            this._visitables.get((Object)"azureDiskVolumes").remove(builder);
            if (this.azureDiskVolumes == null) continue;
            this.azureDiskVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAzureDiskVolumes(Predicate<AzureDiskVolumeBuilder> predicate) {
        if (this.azureDiskVolumes == null) {
            return (A)this;
        }
        Iterator<AzureDiskVolumeBuilder> each = this.azureDiskVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureDiskVolumes");
        while (each.hasNext()) {
            AzureDiskVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzureDiskVolumes() {
        return this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty();
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> addNewAzureDiskVolume() {
        return new AzureDiskVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> addNewAzureDiskVolumeLike(AzureDiskVolume item) {
        return new AzureDiskVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> setNewAzureDiskVolumeLike(Integer index, AzureDiskVolume item) {
        return new AzureDiskVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> editAzureDiskVolume(Integer index) {
        if (this.azureDiskVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureDiskVolumes. Index exceeds size.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> editFirstAzureDiskVolume() {
        if (this.azureDiskVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(0, this.buildAzureDiskVolume(0));
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> editLastAzureDiskVolume() {
        int index = this.azureDiskVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureDiskVolumes. The list is empty.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    @Override
    public CronJobFluent.AzureDiskVolumesNested<A> editMatchingAzureDiskVolume(Predicate<AzureDiskVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureDiskVolumes.size(); ++i) {
            if (!predicate.test(this.azureDiskVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureDiskVolumes. No match found.");
        }
        return this.setNewAzureDiskVolumeLike(index, this.buildAzureDiskVolume(index));
    }

    @Override
    public A withAzureFileVolumes(AzureFileVolume ... azureFileVolumes) {
        if (this.azureFileVolumes != null) {
            this.azureFileVolumes.clear();
        }
        if (azureFileVolumes != null) {
            for (AzureFileVolume item : azureFileVolumes) {
                this.addToAzureFileVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public AzureFileVolume[] getAzureFileVolumes() {
        int size = this.azureFileVolumes != null ? this.azureFileVolumes.size() : 0;
        AzureFileVolume[] result = new AzureFileVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureFileVolumes) {
            result[index++] = (AzureFileVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureFileVolume[] buildAzureFileVolumes() {
        int size = this.azureFileVolumes != null ? this.azureFileVolumes.size() : 0;
        AzureFileVolume[] result = new AzureFileVolume[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.azureFileVolumes) {
            result[index++] = (AzureFileVolume)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public AzureFileVolume buildAzureFileVolume(Integer index) {
        return this.azureFileVolumes.get(index).build();
    }

    @Override
    public AzureFileVolume buildFirstAzureFileVolume() {
        return this.azureFileVolumes.get(0).build();
    }

    @Override
    public AzureFileVolume buildLastAzureFileVolume() {
        return this.azureFileVolumes.get(this.azureFileVolumes.size() - 1).build();
    }

    @Override
    public AzureFileVolume buildMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        for (AzureFileVolumeBuilder item : this.azureFileVolumes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToAzureFileVolumes(Integer index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        this._visitables.get((Object)"azureFileVolumes").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"azureFileVolumes").size(), builder);
        this.azureFileVolumes.add(index >= 0 ? index.intValue() : this.azureFileVolumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToAzureFileVolumes(Integer index, AzureFileVolume item) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"azureFileVolumes").size()) {
            this._visitables.get((Object)"azureFileVolumes").add(builder);
        } else {
            this._visitables.get((Object)"azureFileVolumes").set(index, builder);
        }
        if (index < 0 || index >= this.azureFileVolumes.size()) {
            this.azureFileVolumes.add(builder);
        } else {
            this.azureFileVolumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToAzureFileVolumes(AzureFileVolume ... items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToAzureFileVolumes(Collection<AzureFileVolume> items) {
        if (this.azureFileVolumes == null) {
            this.azureFileVolumes = new ArrayList();
        }
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").add(builder);
            this.azureFileVolumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromAzureFileVolumes(AzureFileVolume ... items) {
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove(builder);
            if (this.azureFileVolumes == null) continue;
            this.azureFileVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAzureFileVolumes(Collection<AzureFileVolume> items) {
        for (AzureFileVolume item : items) {
            AzureFileVolumeBuilder builder = new AzureFileVolumeBuilder(item);
            this._visitables.get((Object)"azureFileVolumes").remove(builder);
            if (this.azureFileVolumes == null) continue;
            this.azureFileVolumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromAzureFileVolumes(Predicate<AzureFileVolumeBuilder> predicate) {
        if (this.azureFileVolumes == null) {
            return (A)this;
        }
        Iterator<AzureFileVolumeBuilder> each = this.azureFileVolumes.iterator();
        List visitables = this._visitables.get((Object)"azureFileVolumes");
        while (each.hasNext()) {
            AzureFileVolumeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasAzureFileVolumes() {
        return this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty();
    }

    @Override
    public A addNewAzureFileVolume(String volumeName, String shareName, String secretName, Boolean readOnly) {
        return this.addToAzureFileVolumes(new AzureFileVolume(volumeName, shareName, secretName, readOnly));
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> addNewAzureFileVolume() {
        return new AzureFileVolumesNestedImpl();
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> addNewAzureFileVolumeLike(AzureFileVolume item) {
        return new AzureFileVolumesNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> setNewAzureFileVolumeLike(Integer index, AzureFileVolume item) {
        return new AzureFileVolumesNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> editAzureFileVolume(Integer index) {
        if (this.azureFileVolumes.size() <= index) {
            throw new RuntimeException("Can't edit azureFileVolumes. Index exceeds size.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> editFirstAzureFileVolume() {
        if (this.azureFileVolumes.size() == 0) {
            throw new RuntimeException("Can't edit first azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(0, this.buildAzureFileVolume(0));
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> editLastAzureFileVolume() {
        int index = this.azureFileVolumes.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last azureFileVolumes. The list is empty.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    @Override
    public CronJobFluent.AzureFileVolumesNested<A> editMatchingAzureFileVolume(Predicate<AzureFileVolumeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.azureFileVolumes.size(); ++i) {
            if (!predicate.test(this.azureFileVolumes.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching azureFileVolumes. No match found.");
        }
        return this.setNewAzureFileVolumeLike(index, this.buildAzureFileVolume(index));
    }

    @Override
    public A withContainers(Container ... containers) {
        if (this.containers != null) {
            this.containers.clear();
        }
        if (containers != null) {
            for (Container item : containers) {
                this.addToContainers(item);
            }
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public Container[] getContainers() {
        int size = this.containers != null ? this.containers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.containers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container[] buildContainers() {
        int size = this.containers != null ? this.containers.size() : 0;
        Container[] result = new Container[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.containers) {
            result[index++] = (Container)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Container buildContainer(Integer index) {
        return this.containers.get(index).build();
    }

    @Override
    public Container buildFirstContainer() {
        return this.containers.get(0).build();
    }

    @Override
    public Container buildLastContainer() {
        return this.containers.get(this.containers.size() - 1).build();
    }

    @Override
    public Container buildMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainer(Predicate<ContainerBuilder> predicate) {
        for (ContainerBuilder item : this.containers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        this._visitables.get((Object)"containers").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"containers").size(), builder);
        this.containers.add(index >= 0 ? index.intValue() : this.containers.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainers(Integer index, Container item) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        ContainerBuilder builder = new ContainerBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"containers").size()) {
            this._visitables.get((Object)"containers").add(builder);
        } else {
            this._visitables.get((Object)"containers").set(index, builder);
        }
        if (index < 0 || index >= this.containers.size()) {
            this.containers.add(builder);
        } else {
            this.containers.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainers(Container ... items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainers(Collection<Container> items) {
        if (this.containers == null) {
            this.containers = new ArrayList();
        }
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").add(builder);
            this.containers.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainers(Container ... items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainers(Collection<Container> items) {
        for (Container item : items) {
            ContainerBuilder builder = new ContainerBuilder(item);
            this._visitables.get((Object)"containers").remove(builder);
            if (this.containers == null) continue;
            this.containers.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainers(Predicate<ContainerBuilder> predicate) {
        if (this.containers == null) {
            return (A)this;
        }
        Iterator<ContainerBuilder> each = this.containers.iterator();
        List visitables = this._visitables.get((Object)"containers");
        while (each.hasNext()) {
            ContainerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainers() {
        return this.containers != null && !this.containers.isEmpty();
    }

    @Override
    public CronJobFluent.ContainersNested<A> addNewContainer() {
        return new ContainersNestedImpl();
    }

    @Override
    public CronJobFluent.ContainersNested<A> addNewContainerLike(Container item) {
        return new ContainersNestedImpl(-1, item);
    }

    @Override
    public CronJobFluent.ContainersNested<A> setNewContainerLike(Integer index, Container item) {
        return new ContainersNestedImpl(index, item);
    }

    @Override
    public CronJobFluent.ContainersNested<A> editContainer(Integer index) {
        if (this.containers.size() <= index) {
            throw new RuntimeException("Can't edit containers. Index exceeds size.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public CronJobFluent.ContainersNested<A> editFirstContainer() {
        if (this.containers.size() == 0) {
            throw new RuntimeException("Can't edit first containers. The list is empty.");
        }
        return this.setNewContainerLike(0, this.buildContainer(0));
    }

    @Override
    public CronJobFluent.ContainersNested<A> editLastContainer() {
        int index = this.containers.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containers. The list is empty.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    @Override
    public CronJobFluent.ContainersNested<A> editMatchingContainer(Predicate<ContainerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containers.size(); ++i) {
            if (!predicate.test(this.containers.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containers. No match found.");
        }
        return this.setNewContainerLike(index, this.buildContainer(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronJobFluentImpl that = (CronJobFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) {
            return false;
        }
        if (this.concurrencyPolicy != null ? !this.concurrencyPolicy.equals((Object)that.concurrencyPolicy) : that.concurrencyPolicy != null) {
            return false;
        }
        if (this.startingDeadlineSeconds != null ? !this.startingDeadlineSeconds.equals(that.startingDeadlineSeconds) : that.startingDeadlineSeconds != null) {
            return false;
        }
        if (this.failedJobsHistoryLimit != null ? !this.failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) : that.failedJobsHistoryLimit != null) {
            return false;
        }
        if (this.successfulJobsHistoryLimit != null ? !this.successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) : that.successfulJobsHistoryLimit != null) {
            return false;
        }
        if (this.parallelism != null ? !this.parallelism.equals(that.parallelism) : that.parallelism != null) {
            return false;
        }
        if (this.completions != null ? !this.completions.equals(that.completions) : that.completions != null) {
            return false;
        }
        if (this.completionMode != null ? !this.completionMode.equals((Object)that.completionMode) : that.completionMode != null) {
            return false;
        }
        if (this.backoffLimit != null ? !this.backoffLimit.equals(that.backoffLimit) : that.backoffLimit != null) {
            return false;
        }
        if (this.activeDeadlineSeconds != null ? !this.activeDeadlineSeconds.equals(that.activeDeadlineSeconds) : that.activeDeadlineSeconds != null) {
            return false;
        }
        if (this.ttlSecondsAfterFinished != null ? !this.ttlSecondsAfterFinished.equals(that.ttlSecondsAfterFinished) : that.ttlSecondsAfterFinished != null) {
            return false;
        }
        if (this.suspend != null ? !this.suspend.equals(that.suspend) : that.suspend != null) {
            return false;
        }
        if (this.restartPolicy != null ? !this.restartPolicy.equals((Object)that.restartPolicy) : that.restartPolicy != null) {
            return false;
        }
        if (this.pvcVolumes != null ? !this.pvcVolumes.equals(that.pvcVolumes) : that.pvcVolumes != null) {
            return false;
        }
        if (this.secretVolumes != null ? !this.secretVolumes.equals(that.secretVolumes) : that.secretVolumes != null) {
            return false;
        }
        if (this.configMapVolumes != null ? !this.configMapVolumes.equals(that.configMapVolumes) : that.configMapVolumes != null) {
            return false;
        }
        if (this.emptyDirVolumes != null ? !this.emptyDirVolumes.equals(that.emptyDirVolumes) : that.emptyDirVolumes != null) {
            return false;
        }
        if (this.awsElasticBlockStoreVolumes != null ? !this.awsElasticBlockStoreVolumes.equals(that.awsElasticBlockStoreVolumes) : that.awsElasticBlockStoreVolumes != null) {
            return false;
        }
        if (this.azureDiskVolumes != null ? !this.azureDiskVolumes.equals(that.azureDiskVolumes) : that.azureDiskVolumes != null) {
            return false;
        }
        if (this.azureFileVolumes != null ? !this.azureFileVolumes.equals(that.azureFileVolumes) : that.azureFileVolumes != null) {
            return false;
        }
        return !(this.containers != null ? !this.containers.equals(that.containers) : that.containers != null);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.schedule, this.concurrencyPolicy, this.startingDeadlineSeconds, this.failedJobsHistoryLimit, this.successfulJobsHistoryLimit, this.parallelism, this.completions, this.completionMode, this.backoffLimit, this.activeDeadlineSeconds, this.ttlSecondsAfterFinished, this.suspend, this.restartPolicy, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.emptyDirVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.containers, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule + ",");
        }
        if (this.concurrencyPolicy != null) {
            sb.append("concurrencyPolicy:");
            sb.append(this.concurrencyPolicy + ",");
        }
        if (this.startingDeadlineSeconds != null) {
            sb.append("startingDeadlineSeconds:");
            sb.append(this.startingDeadlineSeconds + ",");
        }
        if (this.failedJobsHistoryLimit != null) {
            sb.append("failedJobsHistoryLimit:");
            sb.append(this.failedJobsHistoryLimit + ",");
        }
        if (this.successfulJobsHistoryLimit != null) {
            sb.append("successfulJobsHistoryLimit:");
            sb.append(this.successfulJobsHistoryLimit + ",");
        }
        if (this.parallelism != null) {
            sb.append("parallelism:");
            sb.append(this.parallelism + ",");
        }
        if (this.completions != null) {
            sb.append("completions:");
            sb.append(this.completions + ",");
        }
        if (this.completionMode != null) {
            sb.append("completionMode:");
            sb.append(this.completionMode + ",");
        }
        if (this.backoffLimit != null) {
            sb.append("backoffLimit:");
            sb.append(this.backoffLimit + ",");
        }
        if (this.activeDeadlineSeconds != null) {
            sb.append("activeDeadlineSeconds:");
            sb.append(this.activeDeadlineSeconds + ",");
        }
        if (this.ttlSecondsAfterFinished != null) {
            sb.append("ttlSecondsAfterFinished:");
            sb.append(this.ttlSecondsAfterFinished + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.pvcVolumes != null && !this.pvcVolumes.isEmpty()) {
            sb.append("pvcVolumes:");
            sb.append(this.pvcVolumes + ",");
        }
        if (this.secretVolumes != null && !this.secretVolumes.isEmpty()) {
            sb.append("secretVolumes:");
            sb.append(this.secretVolumes + ",");
        }
        if (this.configMapVolumes != null && !this.configMapVolumes.isEmpty()) {
            sb.append("configMapVolumes:");
            sb.append(this.configMapVolumes + ",");
        }
        if (this.emptyDirVolumes != null && !this.emptyDirVolumes.isEmpty()) {
            sb.append("emptyDirVolumes:");
            sb.append(this.emptyDirVolumes + ",");
        }
        if (this.awsElasticBlockStoreVolumes != null && !this.awsElasticBlockStoreVolumes.isEmpty()) {
            sb.append("awsElasticBlockStoreVolumes:");
            sb.append(this.awsElasticBlockStoreVolumes + ",");
        }
        if (this.azureDiskVolumes != null && !this.azureDiskVolumes.isEmpty()) {
            sb.append("azureDiskVolumes:");
            sb.append(this.azureDiskVolumes + ",");
        }
        if (this.azureFileVolumes != null && !this.azureFileVolumes.isEmpty()) {
            sb.append("azureFileVolumes:");
            sb.append(this.azureFileVolumes + ",");
        }
        if (this.containers != null && !this.containers.isEmpty()) {
            sb.append("containers:");
            sb.append(this.containers);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSuspend() {
        return this.withSuspend(true);
    }

    class ContainersNestedImpl<N>
    extends ContainerFluentImpl<CronJobFluent.ContainersNested<N>>
    implements CronJobFluent.ContainersNested<N>,
    Nested<N> {
        ContainerBuilder builder;
        Integer index;

        ContainersNestedImpl(Integer index, Container item) {
            this.index = index;
            this.builder = new ContainerBuilder(this, item);
        }

        ContainersNestedImpl() {
            this.index = -1;
            this.builder = new ContainerBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToContainers(this.index, this.builder.build());
        }

        @Override
        public N endContainer() {
            return this.and();
        }
    }

    class AzureFileVolumesNestedImpl<N>
    extends AzureFileVolumeFluentImpl<CronJobFluent.AzureFileVolumesNested<N>>
    implements CronJobFluent.AzureFileVolumesNested<N>,
    Nested<N> {
        AzureFileVolumeBuilder builder;
        Integer index;

        AzureFileVolumesNestedImpl(Integer index, AzureFileVolume item) {
            this.index = index;
            this.builder = new AzureFileVolumeBuilder(this, item);
        }

        AzureFileVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AzureFileVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToAzureFileVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAzureFileVolume() {
            return this.and();
        }
    }

    class AzureDiskVolumesNestedImpl<N>
    extends AzureDiskVolumeFluentImpl<CronJobFluent.AzureDiskVolumesNested<N>>
    implements CronJobFluent.AzureDiskVolumesNested<N>,
    Nested<N> {
        AzureDiskVolumeBuilder builder;
        Integer index;

        AzureDiskVolumesNestedImpl(Integer index, AzureDiskVolume item) {
            this.index = index;
            this.builder = new AzureDiskVolumeBuilder(this, item);
        }

        AzureDiskVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AzureDiskVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToAzureDiskVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAzureDiskVolume() {
            return this.and();
        }
    }

    class AwsElasticBlockStoreVolumesNestedImpl<N>
    extends AwsElasticBlockStoreVolumeFluentImpl<CronJobFluent.AwsElasticBlockStoreVolumesNested<N>>
    implements CronJobFluent.AwsElasticBlockStoreVolumesNested<N>,
    Nested<N> {
        AwsElasticBlockStoreVolumeBuilder builder;
        Integer index;

        AwsElasticBlockStoreVolumesNestedImpl(Integer index, AwsElasticBlockStoreVolume item) {
            this.index = index;
            this.builder = new AwsElasticBlockStoreVolumeBuilder(this, item);
        }

        AwsElasticBlockStoreVolumesNestedImpl() {
            this.index = -1;
            this.builder = new AwsElasticBlockStoreVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToAwsElasticBlockStoreVolumes(this.index, this.builder.build());
        }

        @Override
        public N endAwsElasticBlockStoreVolume() {
            return this.and();
        }
    }

    class EmptyDirVolumesNestedImpl<N>
    extends EmptyDirVolumeFluentImpl<CronJobFluent.EmptyDirVolumesNested<N>>
    implements CronJobFluent.EmptyDirVolumesNested<N>,
    Nested<N> {
        EmptyDirVolumeBuilder builder;
        Integer index;

        EmptyDirVolumesNestedImpl(Integer index, EmptyDirVolume item) {
            this.index = index;
            this.builder = new EmptyDirVolumeBuilder(this, item);
        }

        EmptyDirVolumesNestedImpl() {
            this.index = -1;
            this.builder = new EmptyDirVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToEmptyDirVolumes(this.index, this.builder.build());
        }

        @Override
        public N endEmptyDirVolume() {
            return this.and();
        }
    }

    class ConfigMapVolumesNestedImpl<N>
    extends ConfigMapVolumeFluentImpl<CronJobFluent.ConfigMapVolumesNested<N>>
    implements CronJobFluent.ConfigMapVolumesNested<N>,
    Nested<N> {
        ConfigMapVolumeBuilder builder;
        Integer index;

        ConfigMapVolumesNestedImpl(Integer index, ConfigMapVolume item) {
            this.index = index;
            this.builder = new ConfigMapVolumeBuilder(this, item);
        }

        ConfigMapVolumesNestedImpl() {
            this.index = -1;
            this.builder = new ConfigMapVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToConfigMapVolumes(this.index, this.builder.build());
        }

        @Override
        public N endConfigMapVolume() {
            return this.and();
        }
    }

    class SecretVolumesNestedImpl<N>
    extends SecretVolumeFluentImpl<CronJobFluent.SecretVolumesNested<N>>
    implements CronJobFluent.SecretVolumesNested<N>,
    Nested<N> {
        SecretVolumeBuilder builder;
        Integer index;

        SecretVolumesNestedImpl(Integer index, SecretVolume item) {
            this.index = index;
            this.builder = new SecretVolumeBuilder(this, item);
        }

        SecretVolumesNestedImpl() {
            this.index = -1;
            this.builder = new SecretVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToSecretVolumes(this.index, this.builder.build());
        }

        @Override
        public N endSecretVolume() {
            return this.and();
        }
    }

    class PvcVolumesNestedImpl<N>
    extends PersistentVolumeClaimVolumeFluentImpl<CronJobFluent.PvcVolumesNested<N>>
    implements CronJobFluent.PvcVolumesNested<N>,
    Nested<N> {
        PersistentVolumeClaimVolumeBuilder builder;
        Integer index;

        PvcVolumesNestedImpl(Integer index, PersistentVolumeClaimVolume item) {
            this.index = index;
            this.builder = new PersistentVolumeClaimVolumeBuilder(this, item);
        }

        PvcVolumesNestedImpl() {
            this.index = -1;
            this.builder = new PersistentVolumeClaimVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobFluentImpl.this.setToPvcVolumes(this.index, this.builder.build());
        }

        @Override
        public N endPvcVolume() {
            return this.and();
        }
    }
}

