/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.decorator.AddPortDecorator;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.ApplyApplicationContainerDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Ports;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ExecAction;
import io.fabric8.kubernetes.api.model.GRPCAction;
import io.fabric8.kubernetes.api.model.HTTPGetAction;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.TCPSocketAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class AbstractAddProbeDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>>
implements WithConfigReferences {
    private static final String PATH_ALL_EXPRESSION = "*.spec.containers.";
    private static final String PATH_DEPLOYMENT_CONTAINER_EXPRESSION = "(metadata.name == %s).spec.template.spec.containers.(name == %s).";
    private static final String PATH_DEPLOYMENT_EXPRESSION = "(metadata.name == %s).spec.template.spec.containers.";
    private static final String PATH_CONTAINER_EXPRESSION = "*.spec.containers.(name == %s).";
    private static final Object AUTO_DISCOVER = null;
    protected final Probe probe;

    protected abstract void doCreateProbe(ContainerFluent<?> var1, Actions var2);

    protected abstract String getProbeName();

    public AbstractAddProbeDecorator(String containerName, Probe probe) {
        this(null, containerName, probe);
    }

    public AbstractAddProbeDecorator(String deploymentName, String containerName, Probe probe) {
        super(deploymentName, containerName);
        this.probe = probe;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        if (this.probe == null) {
            return;
        }
        ExecAction execAction = this.execAction(this.probe);
        TCPSocketAction tcpSocketAction = this.tcpSocketAction(this.probe);
        GRPCAction grpcAction = this.grpcAction(this.probe);
        HTTPGetAction httpGetAction = null;
        if (!this.isExecOrTcpOrGrpcActionSet()) {
            httpGetAction = this.httpGetAction(this.probe, container);
        }
        this.doCreateProbe(container, new Actions(execAction, tcpSocketAction, httpGetAction, grpcAction));
    }

    @Override
    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class, ApplyApplicationContainerDecorator.class, AddPortDecorator.class};
    }

    public List<ConfigReference> getConfigReferences() {
        ArrayList<ConfigReference> configReferences = new ArrayList<ConfigReference>();
        configReferences.add(this.buildConfigReference("failureThreshold", this.probe.getFailureThreshold(), "The failure threshold to use."));
        configReferences.add(this.buildConfigReference("initialDelaySeconds", this.probe.getInitialDelaySeconds(), "The amount of time to wait before starting to probe."));
        configReferences.add(this.buildConfigReference("periodSeconds", this.probe.getPeriodSeconds(), "The period in which the action should be called."));
        configReferences.add(this.buildConfigReference("successThreshold", this.probe.getSuccessThreshold(), "The success threshold to use."));
        configReferences.add(this.buildConfigReference("timeoutSeconds", this.probe.getTimeoutSeconds(), "The amount of time to wait for each action."));
        if (this.isExecOrTcpOrGrpcActionSet()) {
            if (Strings.isNotNullOrEmpty((String)this.probe.getExecAction())) {
                configReferences.add(this.buildConfigReference("exec.command", AUTO_DISCOVER, "The command to use for the probe."));
            } else if (Strings.isNotNullOrEmpty((String)this.probe.getGrpcAction())) {
                configReferences.add(this.buildConfigReference("grpc.port", AUTO_DISCOVER, "The grpc port to use for the probe."));
                configReferences.add(this.buildConfigReference("grpc.service", AUTO_DISCOVER, "The grpc service to use for the probe."));
            } else if (Strings.isNotNullOrEmpty((String)this.probe.getTcpSocketAction())) {
                configReferences.add(this.buildConfigReference("tcpSocket.host", AUTO_DISCOVER, "The tcp host socket to use for the probe."));
                configReferences.add(this.buildConfigReference("tcpSocket.port", AUTO_DISCOVER, "The tcp port socket to use for the probe."));
            }
        } else {
            configReferences.add(this.buildConfigReference("httpGet.path", this.probe.getHttpActionPath(), "The http path to use for the probe."));
            configReferences.add(this.buildConfigReference("httpGet.port", AUTO_DISCOVER, "The http port to use for the probe."));
            configReferences.add(this.buildConfigReference("httpGet.scheme", AUTO_DISCOVER, "The http schema to use for the probe."));
        }
        return configReferences;
    }

    private ConfigReference buildConfigReference(String propertyName, Object value, String description) {
        String expression = PATH_ALL_EXPRESSION;
        if (Strings.isNotNullOrEmpty((String)this.getDeploymentName()) && Strings.isNotNullOrEmpty((String)this.getContainerName())) {
            expression = String.format(PATH_DEPLOYMENT_CONTAINER_EXPRESSION, this.getDeploymentName(), this.getContainerName());
        } else if (Strings.isNotNullOrEmpty((String)this.getDeploymentName())) {
            expression = String.format(PATH_DEPLOYMENT_EXPRESSION, this.getDeploymentName());
        } else if (Strings.isNotNullOrEmpty((String)this.getContainerName())) {
            expression = String.format(PATH_CONTAINER_EXPRESSION, this.getContainerName());
        }
        String property = ConfigReference.joinProperties((String[])new String[]{this.getProbeName(), propertyName});
        String yamlPath = expression + this.getProbeName() + "." + propertyName;
        return new ConfigReference.Builder(property, yamlPath).withDescription(description).withValue(value).build();
    }

    private boolean isExecOrTcpOrGrpcActionSet() {
        return Strings.isNotNullOrEmpty((String)this.probe.getExecAction()) || Strings.isNotNullOrEmpty((String)this.probe.getTcpSocketAction()) || Strings.isNotNullOrEmpty((String)this.probe.getGrpcAction());
    }

    private ExecAction execAction(Probe probe) {
        if (Strings.isNullOrEmpty((String)probe.getExecAction())) {
            return null;
        }
        return new ExecAction(Arrays.asList(probe.getExecAction().split(" ")));
    }

    private HTTPGetAction httpGetAction(Probe probe, ContainerFluent<?> container) {
        if (!container.hasPorts().booleanValue()) {
            return new HTTPGetAction(null, Collections.emptyList(), probe.getHttpActionPath(), new IntOrString((Object)8080), "HTTP");
        }
        int port = ((ContainerPort)Ports.getHttpPort(container).get()).getContainerPort();
        String schema = "HTTP";
        if (Ports.isHttps((int)port)) {
            schema = "HTTPS";
        }
        return new HTTPGetAction(null, Collections.emptyList(), probe.getHttpActionPath(), new IntOrString((Object)port), schema);
    }

    private TCPSocketAction tcpSocketAction(Probe probe) {
        if (Strings.isNullOrEmpty((String)probe.getTcpSocketAction())) {
            return null;
        }
        String[] parts = probe.getTcpSocketAction().split(":");
        if (parts.length == 1) {
            try {
                int port = Integer.parseInt(parts[0]);
                return new TCPSocketAction(null, new IntOrString((Object)port));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid port for tcp socket action! Expected: integer <port>. Found:" + probe.getTcpSocketAction() + ".");
            }
        }
        if (parts.length == 2) {
            return new TCPSocketAction(parts[0], new IntOrString((Object)parts[1]));
        }
        throw new RuntimeException("Invalid format for tcp socket action! Expected: <port> or <host>:<port>. Found:" + probe.getTcpSocketAction() + ".");
    }

    private GRPCAction grpcAction(Probe probe) {
        String grpcActionExpression = probe.getGrpcAction();
        if (Strings.isNullOrEmpty((String)grpcActionExpression)) {
            return null;
        }
        try {
            GRPCAction grpcAction;
            if (grpcActionExpression.contains(":")) {
                String[] parts = grpcActionExpression.split(":");
                grpcAction = new GRPCAction(Integer.valueOf(parts[0]), parts[1]);
            } else {
                grpcAction = new GRPCAction(Integer.valueOf(grpcActionExpression), null);
            }
            return grpcAction;
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException("Wrong port format set in the gRPC probe. Got: " + grpcActionExpression, ex);
        }
    }

    protected static class Actions {
        protected final ExecAction execAction;
        protected final TCPSocketAction tcpSocketAction;
        protected final HTTPGetAction httpGetAction;
        protected final GRPCAction grpcAction;

        protected Actions(ExecAction execAction, TCPSocketAction tcpSocketAction, HTTPGetAction httpGetAction, GRPCAction grpcAction) {
            this.execAction = execAction;
            this.tcpSocketAction = tcpSocketAction;
            this.httpGetAction = httpGetAction;
            this.grpcAction = grpcAction;
        }
    }
}

