package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressFluentImpl<A extends IngressFluent<A>> extends BaseFluent<A> implements IngressFluent<A>{
  public IngressFluentImpl() {
  }
  public IngressFluentImpl(Ingress instance) {
    this.withHost(instance.getHost()); 
    this.withIngressClassName(instance.getIngressClassName()); 
    this.withTargetPort(instance.getTargetPort()); 
    this.withExpose(instance.getExpose()); 
    this.withTlsSecretName(instance.getTlsSecretName()); 
    this.withTlsHosts(instance.getTlsHosts()); 
    this.withRules(instance.getRules()); 
  }
  private String host;
  private String ingressClassName;
  private String targetPort;
  private Boolean expose;
  private String tlsSecretName;
  private List<String> tlsHosts = new ArrayList<String>();
  private ArrayList<IngressRuleBuilder> rules = new ArrayList<IngressRuleBuilder>();
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public String getIngressClassName() {
    return this.ingressClassName;
  }
  public A withIngressClassName(String ingressClassName) {
    this.ingressClassName=ingressClassName; return (A) this;
  }
  public Boolean hasIngressClassName() {
    return this.ingressClassName != null;
  }
  public String getTargetPort() {
    return this.targetPort;
  }
  public A withTargetPort(String targetPort) {
    this.targetPort=targetPort; return (A) this;
  }
  public Boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public Boolean getExpose() {
    return this.expose;
  }
  public A withExpose(Boolean expose) {
    this.expose=expose; return (A) this;
  }
  public Boolean hasExpose() {
    return this.expose != null;
  }
  public String getTlsSecretName() {
    return this.tlsSecretName;
  }
  public A withTlsSecretName(String tlsSecretName) {
    this.tlsSecretName=tlsSecretName; return (A) this;
  }
  public Boolean hasTlsSecretName() {
    return this.tlsSecretName != null;
  }
  public A withTlsHosts(java.lang.String... tlsHosts) {
    if (this.tlsHosts != null) {this.tlsHosts.clear();}
    if (tlsHosts != null) {for (String item :tlsHosts){ this.addToTlsHosts(item);}} return (A) this;
  }
  public String[] getTlsHosts() {
    //This needs to work with primitives, so we use arrays.
int size = tlsHosts != null ? tlsHosts.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : tlsHosts) {
    result[index++]=item;
}
return result;

  }
  public A addToTlsHosts(Integer index,String item) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    this.tlsHosts.add(index, item);
    return (A)this;
  }
  public A setToTlsHosts(Integer index,String item) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    this.tlsHosts.set(index, item); return (A)this;
  }
  public A addToTlsHosts(java.lang.String... items) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    for (String item : items) {this.tlsHosts.add(item);} return (A)this;
  }
  public A addAllToTlsHosts(Collection<String> items) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    for (String item : items) {this.tlsHosts.add(item);} return (A)this;
  }
  public A removeFromTlsHosts(java.lang.String... items) {
    for (String item : items) {if (this.tlsHosts!= null){ this.tlsHosts.remove(item);}} return (A)this;
  }
  public A removeAllFromTlsHosts(Collection<String> items) {
    for (String item : items) {if (this.tlsHosts!= null){ this.tlsHosts.remove(item);}} return (A)this;
  }
  public Boolean hasTlsHosts() {
    return tlsHosts != null && !tlsHosts.isEmpty();
  }
  public A withRules(io.dekorate.kubernetes.config.IngressRule... rules) {
    if (this.rules != null) {this.rules.clear();}
    if (rules != null) {for (IngressRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   */
  @Deprecated
  public IngressRule[] getRules() {
    int size = rules != null ? rules.size() : 0;
IngressRule[] result = new IngressRule[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends IngressRule,?> builder : rules) {
    result[index++]=builder.build();
}
return result;

  }
  public IngressRule[] buildRules() {
    int size = rules != null ? rules.size() : 0;
IngressRule[] result = new IngressRule[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends IngressRule,?> builder : rules) {
    result[index++]=builder.build();
}
return result;

  }
  public IngressRule buildRule(Integer index) {
    return this.rules.get(index).build();
  }
  public IngressRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public IngressRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    for (IngressRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    for (IngressRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToRules(Integer index,IngressRule item) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(index >= 0 ? index : _visitables.get("rules").size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
  }
  public A setToRules(Integer index,IngressRule item) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    IngressRuleBuilder builder = new IngressRuleBuilder(item);
    if (index < 0 || index >= _visitables.get("rules").size()) { _visitables.get("rules").add(builder); } else { _visitables.get("rules").set(index, builder);}
    if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
     return (A)this;
  }
  public A addToRules(io.dekorate.kubernetes.config.IngressRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<IngressRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.dekorate.kubernetes.config.IngressRule... items) {
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<IngressRule> items) {
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<IngressRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      IngressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public IngressFluent.RulesNested<A> addNewRule() {
    return new IngressFluentImpl.RulesNestedImpl();
  }
  public IngressFluent.RulesNested<A> addNewRuleLike(IngressRule item) {
    return new IngressFluentImpl.RulesNestedImpl(-1, item);
  }
  public IngressFluent.RulesNested<A> setNewRuleLike(Integer index,IngressRule item) {
    return new IngressFluentImpl.RulesNestedImpl(index, item);
  }
  public IngressFluent.RulesNested<A> editRule(Integer index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public IngressFluent.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public IngressFluent.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public IngressFluent.RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressFluentImpl that = (IngressFluentImpl) o;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (ingressClassName != null ? !ingressClassName.equals(that.ingressClassName) :that.ingressClassName != null) return false;
    if (targetPort != null ? !targetPort.equals(that.targetPort) :that.targetPort != null) return false;
    if (expose != null ? !expose.equals(that.expose) :that.expose != null) return false;
    if (tlsSecretName != null ? !tlsSecretName.equals(that.tlsSecretName) :that.tlsSecretName != null) return false;
    if (tlsHosts != null ? !tlsHosts.equals(that.tlsHosts) :that.tlsHosts != null) return false;
    if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  ingressClassName,  targetPort,  expose,  tlsSecretName,  tlsHosts,  rules,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (ingressClassName != null) { sb.append("ingressClassName:"); sb.append(ingressClassName + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (expose != null) { sb.append("expose:"); sb.append(expose + ","); }
    if (tlsSecretName != null) { sb.append("tlsSecretName:"); sb.append(tlsSecretName + ","); }
    if (tlsHosts != null && !tlsHosts.isEmpty()) { sb.append("tlsHosts:"); sb.append(tlsHosts + ","); }
    if (rules != null && !rules.isEmpty()) { sb.append("rules:"); sb.append(rules); }
    sb.append("}");
    return sb.toString();
  }
  public A withExpose() {
    return withExpose(true);
  }
  class RulesNestedImpl<N> extends IngressRuleFluentImpl<IngressFluent.RulesNested<N>> implements IngressFluent.RulesNested<N>,Nested<N>{
    RulesNestedImpl(Integer index,IngressRule item) {
      this.index = index;
      this.builder = new IngressRuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new IngressRuleBuilder(this);
    }
    IngressRuleBuilder builder;
    Integer index;
    public N and() {
      return (N) IngressFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}