/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.Quantity;

public class ApplyRequestsCpuDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    private static final String CPU = "cpu";
    private final String amount;

    public ApplyRequestsCpuDecorator(String containerName, String amount) {
        super(containerName);
        this.amount = amount;
    }

    public ApplyRequestsCpuDecorator(String deploymentName, String containerName, String amount) {
        super(deploymentName, containerName);
        this.amount = amount;
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        System.out.println("Apply requests cpu to:" + container.getName());
        ((ContainerFluent.ResourcesNested)container.editOrNewResources().addToRequests(CPU, new Quantity(this.amount))).endResources();
    }
}

