package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class KubernetesConfigFluentImpl<A extends KubernetesConfigFluent<A>> extends BaseConfigFluentImpl<A> implements KubernetesConfigFluent<A>{
  public KubernetesConfigFluentImpl() {
  }
  public KubernetesConfigFluentImpl(KubernetesConfig instance) {
    this.withProject(instance.getProject()); 
    this.withAttributes(instance.getAttributes()); 
    this.withPartOf(instance.getPartOf()); 
    this.withName(instance.getName()); 
    this.withVersion(instance.getVersion()); 
    this.withDeploymentKind(instance.getDeploymentKind()); 
    this.withLabels(instance.getLabels()); 
    this.withAnnotations(instance.getAnnotations()); 
    this.withEnvVars(instance.getEnvVars()); 
    this.withWorkingDir(instance.getWorkingDir()); 
    this.withCommand(instance.getCommand()); 
    this.withArguments(instance.getArguments()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withPorts(instance.getPorts()); 
    this.withServiceType(instance.getServiceType()); 
    this.withPvcVolumes(instance.getPvcVolumes()); 
    this.withSecretVolumes(instance.getSecretVolumes()); 
    this.withConfigMapVolumes(instance.getConfigMapVolumes()); 
    this.withEmptyDirVolumes(instance.getEmptyDirVolumes()); 
    this.withGitRepoVolumes(instance.getGitRepoVolumes()); 
    this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes()); 
    this.withAzureDiskVolumes(instance.getAzureDiskVolumes()); 
    this.withAzureFileVolumes(instance.getAzureFileVolumes()); 
    this.withMounts(instance.getMounts()); 
    this.withImagePullPolicy(instance.getImagePullPolicy()); 
    this.withImagePullSecrets(instance.getImagePullSecrets()); 
    this.withHostAliases(instance.getHostAliases()); 
    this.withLivenessProbe(instance.getLivenessProbe()); 
    this.withReadinessProbe(instance.getReadinessProbe()); 
    this.withStartupProbe(instance.getStartupProbe()); 
    this.withRequestResources(instance.getRequestResources()); 
    this.withLimitResources(instance.getLimitResources()); 
    this.withSidecars(instance.getSidecars()); 
    this.withAutoDeployEnabled(instance.getAutoDeployEnabled()); 
    this.withJobs(instance.getJobs()); 
    this.withCronJobs(instance.getCronJobs()); 
    this.withInitContainers(instance.getInitContainers()); 
    this.withReplicas(instance.getReplicas()); 
    this.withDeploymentStrategy(instance.getDeploymentStrategy()); 
    this.withRollingUpdate(instance.getRollingUpdate()); 
    this.withIngress(instance.getIngress()); 
    this.withHeadless(instance.getHeadless()); 
  }
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Integer replicas;
  private DeploymentStrategy deploymentStrategy;
  private RollingUpdateBuilder rollingUpdate;
  private IngressBuilder ingress;
  private Boolean headless;
  public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers) {
    if (this.initContainers != null) {this.initContainers.clear();}
    if (initContainers != null) {for (Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
  }
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   */
  @Deprecated
  public Container[] getInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;
Container[] result = new Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Container[] buildInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;
Container[] result = new Container[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<? extends Container,?> builder : initContainers) {
    result[index++]=builder.build();
}
return result;

  }
  public Container buildInitContainer(Integer index) {
    return this.initContainers.get(index).build();
  }
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    for (ContainerBuilder item: initContainers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(index >= 0 ? index : _visitables.get("initContainers").size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
  }
  public A setToInitContainers(Integer index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= _visitables.get("initContainers").size()) { _visitables.get("initContainers").add(builder); } else { _visitables.get("initContainers").set(index, builder);}
    if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
     return (A)this;
  }
  public A addToInitContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeAllFromInitContainers(Collection<Container> items) {
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public Boolean hasInitContainers() {
    return initContainers != null && !initContainers.isEmpty();
  }
  public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainer() {
    return new KubernetesConfigFluentImpl.InitContainersNestedImpl();
  }
  public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new KubernetesConfigFluentImpl.InitContainersNestedImpl(-1, item);
  }
  public KubernetesConfigFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item) {
    return new KubernetesConfigFluentImpl.InitContainersNestedImpl(index, item);
  }
  public KubernetesConfigFluent.InitContainersNested<A> editInitContainer(Integer index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public KubernetesConfigFluent.InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  public KubernetesConfigFluent.InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public KubernetesConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public DeploymentStrategy getDeploymentStrategy() {
    return this.deploymentStrategy;
  }
  public A withDeploymentStrategy(DeploymentStrategy deploymentStrategy) {
    this.deploymentStrategy=deploymentStrategy; return (A) this;
  }
  public Boolean hasDeploymentStrategy() {
    return this.deploymentStrategy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildRollingUpdate instead.
   * @return The buildable object.
   */
  @Deprecated
  public RollingUpdate getRollingUpdate() {
    return this.rollingUpdate!=null ?this.rollingUpdate.build():null;
  }
  public RollingUpdate buildRollingUpdate() {
    return this.rollingUpdate!=null ?this.rollingUpdate.build():null;
  }
  public A withRollingUpdate(RollingUpdate rollingUpdate) {
    _visitables.get("rollingUpdate").remove(this.rollingUpdate);
    if (rollingUpdate!=null){ this.rollingUpdate= new RollingUpdateBuilder(rollingUpdate); _visitables.get("rollingUpdate").add(this.rollingUpdate);} else { this.rollingUpdate = null; _visitables.get("rollingUpdate").remove(this.rollingUpdate); } return (A) this;
  }
  public Boolean hasRollingUpdate() {
    return this.rollingUpdate != null;
  }
  public A withNewRollingUpdate(String maxUnavailable,String maxSurge) {
    return (A)withRollingUpdate(new RollingUpdate(maxUnavailable, maxSurge));
  }
  public KubernetesConfigFluent.RollingUpdateNested<A> withNewRollingUpdate() {
    return new KubernetesConfigFluentImpl.RollingUpdateNestedImpl();
  }
  public KubernetesConfigFluent.RollingUpdateNested<A> withNewRollingUpdateLike(RollingUpdate item) {
    return new KubernetesConfigFluentImpl.RollingUpdateNestedImpl(item);
  }
  public KubernetesConfigFluent.RollingUpdateNested<A> editRollingUpdate() {
    return withNewRollingUpdateLike(getRollingUpdate());
  }
  public KubernetesConfigFluent.RollingUpdateNested<A> editOrNewRollingUpdate() {
    return withNewRollingUpdateLike(getRollingUpdate() != null ? getRollingUpdate(): new RollingUpdateBuilder().build());
  }
  public KubernetesConfigFluent.RollingUpdateNested<A> editOrNewRollingUpdateLike(RollingUpdate item) {
    return withNewRollingUpdateLike(getRollingUpdate() != null ? getRollingUpdate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Ingress getIngress() {
    return this.ingress!=null ?this.ingress.build():null;
  }
  public Ingress buildIngress() {
    return this.ingress!=null ?this.ingress.build():null;
  }
  public A withIngress(Ingress ingress) {
    _visitables.get("ingress").remove(this.ingress);
    if (ingress!=null){ this.ingress= new IngressBuilder(ingress); _visitables.get("ingress").add(this.ingress);} else { this.ingress = null; _visitables.get("ingress").remove(this.ingress); } return (A) this;
  }
  public Boolean hasIngress() {
    return this.ingress != null;
  }
  public KubernetesConfigFluent.IngressNested<A> withNewIngress() {
    return new KubernetesConfigFluentImpl.IngressNestedImpl();
  }
  public KubernetesConfigFluent.IngressNested<A> withNewIngressLike(Ingress item) {
    return new KubernetesConfigFluentImpl.IngressNestedImpl(item);
  }
  public KubernetesConfigFluent.IngressNested<A> editIngress() {
    return withNewIngressLike(getIngress());
  }
  public KubernetesConfigFluent.IngressNested<A> editOrNewIngress() {
    return withNewIngressLike(getIngress() != null ? getIngress(): new IngressBuilder().build());
  }
  public KubernetesConfigFluent.IngressNested<A> editOrNewIngressLike(Ingress item) {
    return withNewIngressLike(getIngress() != null ? getIngress(): item);
  }
  public Boolean getHeadless() {
    return this.headless;
  }
  public A withHeadless(Boolean headless) {
    this.headless=headless; return (A) this;
  }
  public Boolean hasHeadless() {
    return this.headless != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesConfigFluentImpl that = (KubernetesConfigFluentImpl) o;
    if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (deploymentStrategy != null ? !deploymentStrategy.equals(that.deploymentStrategy) :that.deploymentStrategy != null) return false;
    if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
    if (ingress != null ? !ingress.equals(that.ingress) :that.ingress != null) return false;
    if (headless != null ? !headless.equals(that.headless) :that.headless != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  deploymentStrategy,  rollingUpdate,  ingress,  headless,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (deploymentStrategy != null) { sb.append("deploymentStrategy:"); sb.append(deploymentStrategy + ","); }
    if (rollingUpdate != null) { sb.append("rollingUpdate:"); sb.append(rollingUpdate + ","); }
    if (ingress != null) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (headless != null) { sb.append("headless:"); sb.append(headless); }
    sb.append("}");
    return sb.toString();
  }
  public A withHeadless() {
    return withHeadless(true);
  }
  class InitContainersNestedImpl<N> extends ContainerFluentImpl<KubernetesConfigFluent.InitContainersNested<N>> implements KubernetesConfigFluent.InitContainersNested<N>,Nested<N>{
    InitContainersNestedImpl(Integer index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    InitContainersNestedImpl() {
      this.index = -1;
      this.builder = new ContainerBuilder(this);
    }
    ContainerBuilder builder;
    Integer index;
    public N and() {
      return (N) KubernetesConfigFluentImpl.this.setToInitContainers(index,builder.build());
    }
    public N endInitContainer() {
      return and();
    }
    
  }
  class RollingUpdateNestedImpl<N> extends RollingUpdateFluentImpl<KubernetesConfigFluent.RollingUpdateNested<N>> implements KubernetesConfigFluent.RollingUpdateNested<N>,Nested<N>{
    RollingUpdateNestedImpl(RollingUpdate item) {
      this.builder = new RollingUpdateBuilder(this, item);
    }
    RollingUpdateNestedImpl() {
      this.builder = new RollingUpdateBuilder(this);
    }
    RollingUpdateBuilder builder;
    public N and() {
      return (N) KubernetesConfigFluentImpl.this.withRollingUpdate(builder.build());
    }
    public N endRollingUpdate() {
      return and();
    }
    
  }
  class IngressNestedImpl<N> extends IngressFluentImpl<KubernetesConfigFluent.IngressNested<N>> implements KubernetesConfigFluent.IngressNested<N>,Nested<N>{
    IngressNestedImpl(Ingress item) {
      this.builder = new IngressBuilder(this, item);
    }
    IngressNestedImpl() {
      this.builder = new IngressBuilder(this);
    }
    IngressBuilder builder;
    public N and() {
      return (N) KubernetesConfigFluentImpl.this.withIngress(builder.build());
    }
    public N endIngress() {
      return and();
    }
    
  }
  
}