/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.fabric8.kubernetes.api.model.apps.DeploymentStrategyFluent;
import io.fabric8.kubernetes.api.model.apps.RollingUpdateDeploymentFluent;

public class ApplyDeploymentStrategyDecorator
extends NamedResourceDecorator<DeploymentSpecFluent<?>> {
    private final DeploymentStrategy strategy;
    private final RollingUpdate rollingUpdate;

    public ApplyDeploymentStrategyDecorator(String name, DeploymentStrategy strategy) {
        this(name, strategy, null);
    }

    public ApplyDeploymentStrategyDecorator(String name, DeploymentStrategy strategy, RollingUpdate rollingUpdate) {
        super(name);
        this.strategy = strategy;
        this.rollingUpdate = rollingUpdate;
    }

    public void andThenVisit(DeploymentSpecFluent<?> spec, ObjectMeta resourceMeta) {
        boolean hasCustomRollingUpdate = this.hasCusomRollingUpdateConfig(this.rollingUpdate);
        if (this.strategy == DeploymentStrategy.Recreate) {
            if (hasCustomRollingUpdate) {
                throw new IllegalStateException("Detected both Recreate strategy and custom Rolling Update config. Please use one or the other!");
            }
            ((DeploymentSpecFluent.StrategyNested)spec.withNewStrategy().withType("Recreate")).endStrategy();
        } else if (this.strategy == DeploymentStrategy.RollingUpdate || hasCustomRollingUpdate) {
            ((DeploymentSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingUpdateNested)((RollingUpdateDeploymentFluent.MaxUnavailableNested)((DeploymentStrategyFluent.RollingUpdateNested)((RollingUpdateDeploymentFluent.MaxSurgeNested)((DeploymentSpecFluent.StrategyNested)spec.withNewStrategy().withType("RollingUpdate")).withNewRollingUpdate().withNewMaxSurge().withValue((Object)this.rollingUpdate.getMaxSurge())).endMaxSurge()).withNewMaxUnavailable().withValue((Object)this.rollingUpdate.getMaxUnavailable())).endMaxUnavailable()).endRollingUpdate()).endStrategy();
        }
    }

    private boolean hasCusomRollingUpdateConfig(RollingUpdate rollingUpdate) {
        return rollingUpdate != null && (rollingUpdate.getMaxUnavailable() != null && !rollingUpdate.getMaxUnavailable().equals("25%") || rollingUpdate.getMaxSurge() != null && !rollingUpdate.getMaxSurge().equals("25%"));
    }
}

