/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;

public class AddImagePullSecretDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final String imagePullSecret;

    public AddImagePullSecretDecorator(String deploymentName, String imagePullSecret) {
        super(deploymentName);
        this.imagePullSecret = imagePullSecret;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.imagePullSecret) && !podSpec.hasMatchingImagePullSecret(r -> this.imagePullSecret.equals(r.getName())).booleanValue()) {
            ((PodSpecFluent.ImagePullSecretsNested)podSpec.addNewImagePullSecret().withName(this.imagePullSecret)).endImagePullSecret();
        }
    }
}

