package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface KubernetesConfigFluent<A extends KubernetesConfigFluent<A>> extends BaseConfigFluent<A>{
  public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers);
  
  /**
   * This method has been deprecated, please use method buildInitContainers instead.
   */
  @Deprecated
  public Container[] getInitContainers();
  public Container[] buildInitContainers();
  public Container buildInitContainer(Integer index);
  public Container buildFirstInitContainer();
  public Container buildLastInitContainer();
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public A addToInitContainers(Integer index,Container item);
  public A setToInitContainers(Integer index,Container item);
  public A addToInitContainers(io.dekorate.kubernetes.config.Container... items);
  public A addAllToInitContainers(Collection<Container> items);
  public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items);
  public A removeAllFromInitContainers(Collection<Container> items);
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate);
  public Boolean hasInitContainers();
  public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainer();
  public KubernetesConfigFluent.InitContainersNested<A> addNewInitContainerLike(Container item);
  public KubernetesConfigFluent.InitContainersNested<A> setNewInitContainerLike(Integer index,Container item);
  public KubernetesConfigFluent.InitContainersNested<A> editInitContainer(Integer index);
  public KubernetesConfigFluent.InitContainersNested<A> editFirstInitContainer();
  public KubernetesConfigFluent.InitContainersNested<A> editLastInitContainer();
  public KubernetesConfigFluent.InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate);
  public Integer getReplicas();
  public A withReplicas(Integer replicas);
  public Boolean hasReplicas();
  
  /**
   * This method has been deprecated, please use method buildIngress instead.
   * @return The buildable object.
   */
  @Deprecated
  public Ingress getIngress();
  public Ingress buildIngress();
  public A withIngress(Ingress ingress);
  public Boolean hasIngress();
  public KubernetesConfigFluent.IngressNested<A> withNewIngress();
  public KubernetesConfigFluent.IngressNested<A> withNewIngressLike(Ingress item);
  public KubernetesConfigFluent.IngressNested<A> editIngress();
  public KubernetesConfigFluent.IngressNested<A> editOrNewIngress();
  public KubernetesConfigFluent.IngressNested<A> editOrNewIngressLike(Ingress item);
  public Boolean getHeadless();
  public A withHeadless(Boolean headless);
  public Boolean hasHeadless();
  public A withHeadless();
  public interface InitContainersNested<N> extends Nested<N>,ContainerFluent<KubernetesConfigFluent.InitContainersNested<N>>{
    public N and();
    public N endInitContainer();
    
  }
  public interface IngressNested<N> extends Nested<N>,IngressFluent<KubernetesConfigFluent.IngressNested<N>>{
    public N and();
    public N endIngress();
    
  }
  
}