package io.dekorate.kubernetes.config;

import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;

 /**
  * Generated
  */
  @Buildable(builderPackage = "io.fabric8.kubernetes.api.builder")
  public class Ingress{
  public Ingress() {
  }
  public Ingress(String host,String ingressClassName,String targetPort,Boolean expose,String tlsSecretName,String[] tlsHosts,IngressRule[] rules) {
    this.host = host;
    this.ingressClassName = ingressClassName;
    this.targetPort = targetPort;
    this.expose = expose;
    this.tlsSecretName = tlsSecretName;
    this.tlsHosts = tlsHosts != null ? tlsHosts : new String[0];
    this.rules = rules != null ? rules : new IngressRule[0];
  }
  private String host;
  private String ingressClassName;
  private String targetPort;
  private Boolean expose;
  private String tlsSecretName;
  private String[] tlsHosts = new String[0];
  private IngressRule[] rules = new IngressRule[0];
  
  /**
   * The host under which the application is going to be exposed.
   * @return The hostname.
   */
public String getHost() {
    return this.host;
  }
  
  /**
   * The class of the Ingress. If the ingressClassName is omitted, a default Ingress class is used.
   * @return The class of the Ingress.
   */
public String getIngressClassName() {
    return this.ingressClassName;
  }
  
  /**
   * @return The target port name to use. If not provided, it will be deducted from the Service resource ports.
   */
public String getTargetPort() {
    return this.targetPort;
  }
  
  /**
   * Controls whether the application should be exposed via Ingress
   */
public Boolean getExpose() {
    return this.expose;
  }
  
  /**
   * Controls whether the application should be exposed via Ingress
   */
public boolean isExpose() {
    return this.expose != null &&  this.expose;
  }
  
  /**
   * @return The name of the secret used to configure TLS.
   */
public String getTlsSecretName() {
    return this.tlsSecretName;
  }
  
  /**
   * @return The list of hosts to be included in the TLS certificate. By default, it will use the application host.
   */
public String[] getTlsHosts() {
    return this.tlsHosts;
  }
  
  /**
   * Controls the generated ingress rules to be exposed as part of the Ingress resource.
   */
public IngressRule[] getRules() {
    return this.rules;
  }
  public static IngressBuilder newBuilder() {
    return new IngressBuilder();
  }
  public static IngressBuilder newBuilderFromDefaults() {
    return new IngressBuilder().withTargetPort("http").withExpose(false);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    Ingress that = (Ingress) o;
    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(ingressClassName, that.ingressClassName)) return false;

    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;

    if (!java.util.Objects.equals(expose, that.expose)) return false;

    if (!java.util.Objects.equals(tlsSecretName, that.tlsSecretName)) return false;

    if (!java.util.Objects.equals(tlsHosts, that.tlsHosts)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  ingressClassName,  targetPort,  expose,  tlsSecretName,  tlsHosts,  rules,  super.hashCode());
  }
  
}