package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class IngressBuilder extends IngressFluent<IngressBuilder> implements VisitableBuilder<Ingress,IngressBuilder>{
  public IngressBuilder() {
    this(false);
  }
  public IngressBuilder(Boolean validationEnabled) {
    this(new Ingress(), validationEnabled);
  }
  public IngressBuilder(IngressFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressBuilder(IngressFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Ingress(), validationEnabled);
  }
  public IngressBuilder(IngressFluent<?> fluent,Ingress instance) {
    this(fluent, instance, false);
  }
  public IngressBuilder(IngressFluent<?> fluent,Ingress instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Ingress());

    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withIngressClassName(instance.getIngressClassName());
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withExpose(instance.getExpose());
      fluent.withTlsSecretName(instance.getTlsSecretName());
      fluent.withTlsHosts(instance.getTlsHosts());
      fluent.withRules(instance.getRules());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressBuilder(Ingress instance) {
    this(instance,false);
  }
  public IngressBuilder(Ingress instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Ingress());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withIngressClassName(instance.getIngressClassName());
      this.withTargetPort(instance.getTargetPort());
      this.withExpose(instance.getExpose());
      this.withTlsSecretName(instance.getTlsSecretName());
      this.withTlsHosts(instance.getTlsHosts());
      this.withRules(instance.getRules());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressFluent<?> fluent;
  Boolean validationEnabled;
  public EditableIngress build() {
    EditableIngress buildable = new EditableIngress(fluent.getHost(),fluent.getIngressClassName(),fluent.getTargetPort(),fluent.getExpose(),fluent.getTlsSecretName(),fluent.getTlsHosts(),fluent.buildRules());
    return buildable;
  }
  
}