package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressFluent<A extends IngressFluent<A>> extends BaseFluent<A>{
  public IngressFluent() {
  }
  public IngressFluent(Ingress instance) {
    instance = (instance != null ? instance : new Ingress());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withIngressClassName(instance.getIngressClassName());
      this.withTargetPort(instance.getTargetPort());
      this.withExpose(instance.getExpose());
      this.withTlsSecretName(instance.getTlsSecretName());
      this.withTlsHosts(instance.getTlsHosts());
      this.withRules(instance.getRules());
    }
  }
  private String host;
  private String ingressClassName;
  private String targetPort;
  private Boolean expose;
  private String tlsSecretName;
  private List<String> tlsHosts = new ArrayList<String>();
  private ArrayList<IngressRuleBuilder> rules = new ArrayList<IngressRuleBuilder>();
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public boolean hasHost() {
    return this.host != null;
  }
  public String getIngressClassName() {
    return this.ingressClassName;
  }
  public A withIngressClassName(String ingressClassName) {
    this.ingressClassName=ingressClassName; return (A) this;
  }
  public boolean hasIngressClassName() {
    return this.ingressClassName != null;
  }
  public String getTargetPort() {
    return this.targetPort;
  }
  public A withTargetPort(String targetPort) {
    this.targetPort=targetPort; return (A) this;
  }
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  public Boolean getExpose() {
    return this.expose;
  }
  public A withExpose(Boolean expose) {
    this.expose=expose; return (A) this;
  }
  public boolean hasExpose() {
    return this.expose != null;
  }
  public String getTlsSecretName() {
    return this.tlsSecretName;
  }
  public A withTlsSecretName(String tlsSecretName) {
    this.tlsSecretName=tlsSecretName; return (A) this;
  }
  public boolean hasTlsSecretName() {
    return this.tlsSecretName != null;
  }
  public A withTlsHosts(java.lang.String... tlsHosts) {
    if (this.tlsHosts != null) {this.tlsHosts.clear(); _visitables.remove("tlsHosts"); }
    if (tlsHosts != null) {for (String item :tlsHosts){ this.addToTlsHosts(item);}} return (A) this;
  }
  public String[] getTlsHosts() {
    //This needs to work with primitives, so we use arrays.
int size = tlsHosts != null ? tlsHosts.size() : 0;
String[] result = new String[size];
if (size == 0) {
   return result;
}
int index = 0;
for (String item : tlsHosts) {
    result[index++]=item;
}
return result;

  }
  public A addToTlsHosts(int index,String item) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    this.tlsHosts.add(index, item);
    return (A)this;
  }
  public A setToTlsHosts(int index,String item) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    this.tlsHosts.set(index, item); return (A)this;
  }
  public A addToTlsHosts(java.lang.String... items) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    for (String item : items) {this.tlsHosts.add(item);} return (A)this;
  }
  public A addAllToTlsHosts(Collection<String> items) {
    if (this.tlsHosts == null) {this.tlsHosts = new ArrayList<String>();}
    for (String item : items) {this.tlsHosts.add(item);} return (A)this;
  }
  public A removeFromTlsHosts(java.lang.String... items) {
    if (this.tlsHosts == null) return (A)this;
    for (String item : items) { this.tlsHosts.remove(item);} return (A)this;
  }
  public A removeAllFromTlsHosts(Collection<String> items) {
    if (this.tlsHosts == null) return (A)this;
    for (String item : items) { this.tlsHosts.remove(item);} return (A)this;
  }
  public boolean hasTlsHosts() {
    return tlsHosts != null && !tlsHosts.isEmpty();
  }
  public A withRules(io.dekorate.kubernetes.config.IngressRule... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (IngressRule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public IngressRule[] buildRules() {
    int size = rules != null ? rules.size() : 0;
IngressRule[] result = new IngressRule[size];
if (size == 0) {
   return result;
}
int index = 0;
for (VisitableBuilder<IngressRule,IngressRuleBuilder> builder : rules) {
    result[index++]=builder.build();
}
return result;

  }
  public IngressRule buildRule(int index) {
    return this.rules.get(index).build();
  }
  public IngressRule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public IngressRule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public IngressRule buildMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    for (IngressRuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    for (IngressRuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A addToRules(int index,IngressRule item) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    IngressRuleBuilder builder = new IngressRuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  public A setToRules(int index,IngressRule item) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    IngressRuleBuilder builder = new IngressRuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  public A addToRules(io.dekorate.kubernetes.config.IngressRule... items) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<IngressRule> items) {
    if (this.rules == null) {this.rules = new ArrayList<IngressRuleBuilder>();}
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.dekorate.kubernetes.config.IngressRule... items) {
    if (this.rules == null) return (A)this;
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  public A removeAllFromRules(Collection<IngressRule> items) {
    if (this.rules == null) return (A)this;
    for (IngressRule item : items) {IngressRuleBuilder builder = new IngressRuleBuilder(item);_visitables.get("rules").remove(builder); this.rules.remove(builder);} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<IngressRuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<IngressRuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      IngressRuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public RulesNested<A> addNewRule() {
    return new RulesNested(-1, null);
  }
  public RulesNested<A> addNewRuleLike(IngressRule item) {
    return new RulesNested(-1, item);
  }
  public RulesNested<A> setNewRuleLike(int index,IngressRule item) {
    return new RulesNested(index, item);
  }
  public RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public RulesNested<A> editMatchingRule(Predicate<IngressRuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressFluent that = (IngressFluent) o;
    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(ingressClassName, that.ingressClassName)) return false;

    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;

    if (!java.util.Objects.equals(expose, that.expose)) return false;

    if (!java.util.Objects.equals(tlsSecretName, that.tlsSecretName)) return false;

    if (!java.util.Objects.equals(tlsHosts, that.tlsHosts)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  ingressClassName,  targetPort,  expose,  tlsSecretName,  tlsHosts,  rules,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (ingressClassName != null) { sb.append("ingressClassName:"); sb.append(ingressClassName + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (expose != null) { sb.append("expose:"); sb.append(expose + ","); }
    if (tlsSecretName != null) { sb.append("tlsSecretName:"); sb.append(tlsSecretName + ","); }
    if (tlsHosts != null && !tlsHosts.isEmpty()) { sb.append("tlsHosts:"); sb.append(tlsHosts + ","); }
    if (rules != null) { sb.append("rules:"); sb.append(rules); }
    sb.append("}");
    return sb.toString();
  }
  public A withExpose() {
    return withExpose(true);
  }
  public class RulesNested<N> extends IngressRuleFluent<RulesNested<N>> implements Nested<N>{
    RulesNested(int index,IngressRule item) {
      this.index = index;
      this.builder = new IngressRuleBuilder(this, item);
    }
    IngressRuleBuilder builder;
    int index;
    public N and() {
      return (N) IngressFluent.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  
}