package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.Object;
import java.lang.String;

 /**
  * Generated
  */
public class IngressRule{
  public IngressRule() {
  }
  public IngressRule(String host,String path,String pathType,String serviceName,String servicePortName,Integer servicePortNumber) {
    this.host = host;
    this.path = path;
    this.pathType = pathType;
    this.serviceName = serviceName;
    this.servicePortName = servicePortName;
    this.servicePortNumber = servicePortNumber;
  }
  private String host;
  private String path;
  private String pathType;
  private String serviceName;
  private String servicePortName;
  private Integer servicePortNumber;
  
  /**
   * The host under which the rule is going to be used.
   */
public String getHost() {
    return this.host;
  }
  
  /**
   * The path under which the rule is going to be used. Default is "/".
   */
public String getPath() {
    return this.path;
  }
  
  /**
   * The path type strategy to use by the Ingress rule. Default is "Prefix".
   */
public String getPathType() {
    return this.pathType;
  }
  
  /**
   * The service name to be used by this Ingress rule. Default is the generated service name of the application.
   */
public String getServiceName() {
    return this.serviceName;
  }
  
  /**
   * The service port name to be used by this Ingress rule. Default is the port name of the generated service
   * of the application.
   */
public String getServicePortName() {
    return this.servicePortName;
  }
  
  /**
   * The service port number to be used by this Ingress rule. This is only used when the servicePortName is not set.
   */
public Integer getServicePortNumber() {
    return this.servicePortNumber;
  }
  public static IngressRuleBuilder newBuilder() {
    return new IngressRuleBuilder();
  }
  public static IngressRuleBuilder newBuilderFromDefaults() {
    return new IngressRuleBuilder().withPath("/").withPathType("Prefix").withServicePortNumber(-1);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressRule that = (IngressRule) o;
    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(pathType, that.pathType)) return false;

    if (!java.util.Objects.equals(serviceName, that.serviceName)) return false;

    if (!java.util.Objects.equals(servicePortName, that.servicePortName)) return false;

    if (!java.util.Objects.equals(servicePortNumber, that.servicePortNumber)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(host,  path,  pathType,  serviceName,  servicePortName,  servicePortNumber,  super.hashCode());
  }
  
}