package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressRuleBuilder extends IngressRuleFluent<IngressRuleBuilder> implements VisitableBuilder<IngressRule,IngressRuleBuilder>{
  public IngressRuleBuilder() {
    this(false);
  }
  public IngressRuleBuilder(Boolean validationEnabled) {
    this(new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,IngressRule instance) {
    this(fluent, instance, false);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent,IngressRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressRule());

    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withPath(instance.getPath());
      fluent.withPathType(instance.getPathType());
      fluent.withServiceName(instance.getServiceName());
      fluent.withServicePortName(instance.getServicePortName());
      fluent.withServicePortNumber(instance.getServicePortNumber());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressRuleBuilder(IngressRule instance) {
    this(instance,false);
  }
  public IngressRuleBuilder(IngressRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressRule());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPath(instance.getPath());
      this.withPathType(instance.getPathType());
      this.withServiceName(instance.getServiceName());
      this.withServicePortName(instance.getServicePortName());
      this.withServicePortNumber(instance.getServicePortNumber());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressRuleFluent<?> fluent;
  Boolean validationEnabled;
  public IngressRule build() {
    IngressRule buildable = new IngressRule(fluent.getHost(),fluent.getPath(),fluent.getPathType(),fluent.getServiceName(),fluent.getServicePortName(),fluent.getServicePortNumber());
    return buildable;
  }
  
}