package io.dekorate.kubernetes.config;

import java.lang.String;
import io.dekorate.kubernetes.annotation.ServiceType;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import java.lang.Integer;
import io.dekorate.project.Project;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @Buildable(refs = {@io.sundr.builder.annotations.BuildableReference(value = io.dekorate.project.Project.class),@io.sundr.builder.annotations.BuildableReference(value = io.dekorate.project.BuildInfo.class)} ,builderPackage = "io.fabric8.kubernetes.api.builder")
  public class KubernetesConfig extends BaseConfig{
  public KubernetesConfig() {
  }
  public KubernetesConfig(Project project,Map<ConfigKey,Object> attributes,String partOf,String name,String version,String deploymentKind,Label[] labels,Annotation[] annotations,Env[] envVars,String workingDir,String[] command,String[] arguments,String serviceAccount,Port[] ports,ServiceType serviceType,PersistentVolumeClaimVolume[] pvcVolumes,SecretVolume[] secretVolumes,ConfigMapVolume[] configMapVolumes,EmptyDirVolume[] emptyDirVolumes,GitRepoVolume[] gitRepoVolumes,AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes,AzureDiskVolume[] azureDiskVolumes,AzureFileVolume[] azureFileVolumes,Mount[] mounts,ImagePullPolicy imagePullPolicy,String[] imagePullSecrets,DeploymentStrategy deploymentStrategy,RollingUpdate rollingUpdate,HostAlias[] hostAliases,Probe livenessProbe,Probe readinessProbe,Probe startupProbe,ResourceRequirements requestResources,ResourceRequirements limitResources,Container[] sidecars,Boolean autoDeployEnabled,Job[] jobs,CronJob[] cronJobs,Container[] initContainers,Integer replicas,Ingress ingress,Boolean headless) {
    super(project, attributes, partOf, name, version, deploymentKind, labels, annotations, envVars, workingDir, command, arguments, serviceAccount, ports, serviceType, pvcVolumes, secretVolumes, configMapVolumes, emptyDirVolumes, gitRepoVolumes, awsElasticBlockStoreVolumes, azureDiskVolumes, azureFileVolumes, mounts, imagePullPolicy, imagePullSecrets, deploymentStrategy, rollingUpdate, hostAliases, livenessProbe, readinessProbe, startupProbe, requestResources, limitResources, sidecars, autoDeployEnabled, jobs, cronJobs);
    this.initContainers = initContainers != null ? initContainers : new Container[0];
    this.replicas = replicas;
    this.ingress = ingress;
    this.headless = headless;
  }
  private Container[] initContainers = new Container[0];
  private Integer replicas;
  private Ingress ingress;
  private Boolean headless;
  
  /**
   * The init containers.
   * @return the init containers.
   */
public Container[] getInitContainers() {
    return this.initContainers;
  }
  
  /**
   * The number of replicas to use.
   * @return The number of replicas.
   */
public Integer getReplicas() {
    return this.replicas;
  }
  
  /**
   * @return the Ingress resource configuration.
   */
public Ingress getIngress() {
    return this.ingress;
  }
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
public Boolean getHeadless() {
    return this.headless;
  }
  
  /**
   * Controls whether the generated {@link Service} will be headless.
   * @return true if headless.
   */
public boolean isHeadless() {
    return this.headless != null &&  this.headless;
  }
  public static KubernetesConfigBuilder newKubernetesConfigBuilder() {
    return new KubernetesConfigBuilder();
  }
  public static KubernetesConfigBuilder newKubernetesConfigBuilderFromDefaults() {
    return new KubernetesConfigBuilder().withDeploymentKind("Deployment").withReplicas(1).withDeploymentStrategy(io.dekorate.kubernetes.config.DeploymentStrategy.None).withServiceType(io.dekorate.kubernetes.annotation.ServiceType.ClusterIP).withImagePullPolicy(io.dekorate.kubernetes.annotation.ImagePullPolicy.IfNotPresent).withIngress(new Ingress()).withHeadless(false).withAutoDeployEnabled(false);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesConfig that = (KubernetesConfig) o;
    if (!java.util.Objects.equals(initContainers, that.initContainers)) return false;

    if (!java.util.Objects.equals(replicas, that.replicas)) return false;

    if (!java.util.Objects.equals(ingress, that.ingress)) return false;

    if (!java.util.Objects.equals(headless, that.headless)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  ingress,  headless,  super.hashCode());
  }
  
}