package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;

 /**
  * Generated
  */
public class KubernetesConfigBuilder extends KubernetesConfigFluent<KubernetesConfigBuilder> implements VisitableBuilder<KubernetesConfig,KubernetesConfigBuilder>{
  public KubernetesConfigBuilder() {
    this(false);
  }
  public KubernetesConfigBuilder(Boolean validationEnabled) {
    this(new KubernetesConfig(), validationEnabled);
  }
  public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new KubernetesConfig(), validationEnabled);
  }
  public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent,KubernetesConfig instance) {
    this(fluent, instance, false);
  }
  public KubernetesConfigBuilder(KubernetesConfigFluent<?> fluent,KubernetesConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new KubernetesConfig());

    if (instance != null) {
      fluent.withProject(instance.getProject());
      fluent.withAttributes(instance.getAttributes());
      fluent.withPartOf(instance.getPartOf());
      fluent.withName(instance.getName());
      fluent.withVersion(instance.getVersion());
      fluent.withDeploymentKind(instance.getDeploymentKind());
      fluent.withLabels(instance.getLabels());
      fluent.withAnnotations(instance.getAnnotations());
      fluent.withEnvVars(instance.getEnvVars());
      fluent.withWorkingDir(instance.getWorkingDir());
      fluent.withCommand(instance.getCommand());
      fluent.withArguments(instance.getArguments());
      fluent.withServiceAccount(instance.getServiceAccount());
      fluent.withPorts(instance.getPorts());
      fluent.withServiceType(instance.getServiceType());
      fluent.withPvcVolumes(instance.getPvcVolumes());
      fluent.withSecretVolumes(instance.getSecretVolumes());
      fluent.withConfigMapVolumes(instance.getConfigMapVolumes());
      fluent.withEmptyDirVolumes(instance.getEmptyDirVolumes());
      fluent.withGitRepoVolumes(instance.getGitRepoVolumes());
      fluent.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
      fluent.withAzureDiskVolumes(instance.getAzureDiskVolumes());
      fluent.withAzureFileVolumes(instance.getAzureFileVolumes());
      fluent.withMounts(instance.getMounts());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withImagePullSecrets(instance.getImagePullSecrets());
      fluent.withDeploymentStrategy(instance.getDeploymentStrategy());
      fluent.withRollingUpdate(instance.getRollingUpdate());
      fluent.withHostAliases(instance.getHostAliases());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withStartupProbe(instance.getStartupProbe());
      fluent.withRequestResources(instance.getRequestResources());
      fluent.withLimitResources(instance.getLimitResources());
      fluent.withSidecars(instance.getSidecars());
      fluent.withAutoDeployEnabled(instance.getAutoDeployEnabled());
      fluent.withJobs(instance.getJobs());
      fluent.withCronJobs(instance.getCronJobs());
      fluent.withInitContainers(instance.getInitContainers());
      fluent.withReplicas(instance.getReplicas());
      fluent.withIngress(instance.getIngress());
      fluent.withHeadless(instance.getHeadless());
      fluent.withPartOf(instance.getPartOf());
      fluent.withName(instance.getName());
      fluent.withVersion(instance.getVersion());
      fluent.withProject(instance.getProject());
      fluent.withAttributes(instance.getAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  public KubernetesConfigBuilder(KubernetesConfig instance) {
    this(instance,false);
  }
  public KubernetesConfigBuilder(KubernetesConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new KubernetesConfig());

    if (instance != null) {
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
      this.withPartOf(instance.getPartOf());
      this.withName(instance.getName());
      this.withVersion(instance.getVersion());
      this.withDeploymentKind(instance.getDeploymentKind());
      this.withLabels(instance.getLabels());
      this.withAnnotations(instance.getAnnotations());
      this.withEnvVars(instance.getEnvVars());
      this.withWorkingDir(instance.getWorkingDir());
      this.withCommand(instance.getCommand());
      this.withArguments(instance.getArguments());
      this.withServiceAccount(instance.getServiceAccount());
      this.withPorts(instance.getPorts());
      this.withServiceType(instance.getServiceType());
      this.withPvcVolumes(instance.getPvcVolumes());
      this.withSecretVolumes(instance.getSecretVolumes());
      this.withConfigMapVolumes(instance.getConfigMapVolumes());
      this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
      this.withGitRepoVolumes(instance.getGitRepoVolumes());
      this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
      this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
      this.withAzureFileVolumes(instance.getAzureFileVolumes());
      this.withMounts(instance.getMounts());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withImagePullSecrets(instance.getImagePullSecrets());
      this.withDeploymentStrategy(instance.getDeploymentStrategy());
      this.withRollingUpdate(instance.getRollingUpdate());
      this.withHostAliases(instance.getHostAliases());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withStartupProbe(instance.getStartupProbe());
      this.withRequestResources(instance.getRequestResources());
      this.withLimitResources(instance.getLimitResources());
      this.withSidecars(instance.getSidecars());
      this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
      this.withJobs(instance.getJobs());
      this.withCronJobs(instance.getCronJobs());
      this.withInitContainers(instance.getInitContainers());
      this.withReplicas(instance.getReplicas());
      this.withIngress(instance.getIngress());
      this.withHeadless(instance.getHeadless());
      this.withPartOf(instance.getPartOf());
      this.withName(instance.getName());
      this.withVersion(instance.getVersion());
      this.withProject(instance.getProject());
      this.withAttributes(instance.getAttributes());
    }
    this.validationEnabled = validationEnabled; 
  }
  KubernetesConfigFluent<?> fluent;
  Boolean validationEnabled;
  public EditableKubernetesConfig build() {
    EditableKubernetesConfig buildable = new EditableKubernetesConfig(fluent.buildProject(),fluent.getAttributes(),fluent.getPartOf(),fluent.getName(),fluent.getVersion(),fluent.getDeploymentKind(),fluent.buildLabels(),fluent.buildAnnotations(),fluent.buildEnvVars(),fluent.getWorkingDir(),fluent.getCommand(),fluent.getArguments(),fluent.getServiceAccount(),fluent.buildPorts(),fluent.getServiceType(),fluent.buildPvcVolumes(),fluent.buildSecretVolumes(),fluent.buildConfigMapVolumes(),fluent.buildEmptyDirVolumes(),fluent.buildGitRepoVolumes(),fluent.buildAwsElasticBlockStoreVolumes(),fluent.buildAzureDiskVolumes(),fluent.buildAzureFileVolumes(),fluent.buildMounts(),fluent.getImagePullPolicy(),fluent.getImagePullSecrets(),fluent.getDeploymentStrategy(),fluent.buildRollingUpdate(),fluent.buildHostAliases(),fluent.buildLivenessProbe(),fluent.buildReadinessProbe(),fluent.buildStartupProbe(),fluent.buildRequestResources(),fluent.buildLimitResources(),fluent.buildSidecars(),fluent.getAutoDeployEnabled(),fluent.buildJobs(),fluent.buildCronJobs(),fluent.buildInitContainers(),fluent.getReplicas(),fluent.buildIngress(),fluent.getHeadless());
    return buildable;
  }
  
}