/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.config.Annotation;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class AnnotationFluent<A extends AnnotationFluent<A>>
extends BaseFluent<A> {
    private String key;
    private String value;
    private List<String> kinds = new ArrayList<String>();

    public AnnotationFluent() {
    }

    public AnnotationFluent(Annotation instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Annotation instance) {
        Annotation annotation = instance = instance != null ? instance : new Annotation();
        if (instance != null) {
            this.withKey(instance.getKey());
            this.withValue(instance.getValue());
            this.withKinds(instance.getKinds());
        }
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public String getValue() {
        return this.value;
    }

    public A withValue(String value) {
        this.value = value;
        return (A)((Object)this);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public A withKinds(String ... kinds) {
        if (this.kinds != null) {
            this.kinds.clear();
            this._visitables.remove((Object)"kinds");
        }
        if (kinds != null) {
            for (String item : kinds) {
                this.addToKinds(item);
            }
        }
        return (A)((Object)this);
    }

    public String[] getKinds() {
        int size = this.kinds != null ? this.kinds.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.kinds) {
            result[index++] = item;
        }
        return result;
    }

    public A addToKinds(int index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.add(index, item);
        return (A)((Object)this);
    }

    public A setToKinds(int index, String item) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        this.kinds.set(index, item);
        return (A)((Object)this);
    }

    public A addToKinds(String ... items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToKinds(Collection<String> items) {
        if (this.kinds == null) {
            this.kinds = new ArrayList<String>();
        }
        for (String item : items) {
            this.kinds.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromKinds(String ... items) {
        if (this.kinds == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kinds.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKinds(Collection<String> items) {
        if (this.kinds == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.kinds.remove(item);
        }
        return (A)((Object)this);
    }

    public boolean hasKinds() {
        return this.kinds != null && !this.kinds.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnnotationFluent that = (AnnotationFluent)((Object)o);
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        return Objects.equals(this.kinds, that.kinds);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.kinds, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.kinds != null && !this.kinds.isEmpty()) {
            sb.append("kinds:");
            sb.append(this.kinds);
        }
        sb.append("}");
        return sb.toString();
    }
}

