/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.configurator;

import io.dekorate.kubernetes.config.BaseConfigFluent;
import io.dekorate.kubernetes.config.Configurator;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.PortBuilder;
import io.dekorate.utils.Ports;
import java.util.Map;
import java.util.function.Predicate;

public class ApplyPort
extends Configurator<BaseConfigFluent<?>> {
    private final Port port;
    private final Map<String, Integer> nameMappings;

    public ApplyPort(Port port) {
        this(port, Ports.webPortNameMappings());
    }

    public ApplyPort(Port port, Map<String, Integer> nameMappings) {
        this.port = port;
        this.nameMappings = nameMappings;
    }

    public void visit(BaseConfigFluent<?> config) {
        Port updated = Ports.populateHostPort((Port)this.port);
        Predicate<PortBuilder> matchingPortName = p -> updated.getName().equals(p.getName());
        Predicate<PortBuilder> matchingHostPort = p -> updated.getHostPort() != null && updated.getHostPort().equals(p.getHostPort());
        if (!config.hasMatchingPort(matchingPortName) && !config.hasMatchingPort(matchingHostPort)) {
            config.addToPorts(updated);
        }
    }
}

