package io.dekorate.kubernetes.config;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressRuleFluent<A extends IngressRuleFluent<A>> extends BaseFluent<A>{
  public IngressRuleFluent() {
  }
  
  public IngressRuleFluent(IngressRule instance) {
    this.copyInstance(instance);
  }
  private String host;
  private String path;
  private String pathType;
  private String serviceName;
  private String servicePortName;
  private Integer servicePortNumber;
  
  protected void copyInstance(IngressRule instance) {
    instance = (instance != null ? instance : new IngressRule());
    if (instance != null) {
          this.withHost(instance.getHost());
          this.withPath(instance.getPath());
          this.withPathType(instance.getPathType());
          this.withServiceName(instance.getServiceName());
          this.withServicePortName(instance.getServicePortName());
          this.withServicePortNumber(instance.getServicePortNumber());
        }
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host = host;
    return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public String getPathType() {
    return this.pathType;
  }
  
  public A withPathType(String pathType) {
    this.pathType = pathType;
    return (A) this;
  }
  
  public boolean hasPathType() {
    return this.pathType != null;
  }
  
  public String getServiceName() {
    return this.serviceName;
  }
  
  public A withServiceName(String serviceName) {
    this.serviceName = serviceName;
    return (A) this;
  }
  
  public boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  public String getServicePortName() {
    return this.servicePortName;
  }
  
  public A withServicePortName(String servicePortName) {
    this.servicePortName = servicePortName;
    return (A) this;
  }
  
  public boolean hasServicePortName() {
    return this.servicePortName != null;
  }
  
  public Integer getServicePortNumber() {
    return this.servicePortNumber;
  }
  
  public A withServicePortNumber(Integer servicePortNumber) {
    this.servicePortNumber = servicePortNumber;
    return (A) this;
  }
  
  public boolean hasServicePortNumber() {
    return this.servicePortNumber != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressRuleFluent that = (IngressRuleFluent) o;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(pathType, that.pathType)) return false;
    if (!java.util.Objects.equals(serviceName, that.serviceName)) return false;
    if (!java.util.Objects.equals(servicePortName, that.servicePortName)) return false;
    if (!java.util.Objects.equals(servicePortNumber, that.servicePortNumber)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(host,  path,  pathType,  serviceName,  servicePortName,  servicePortNumber,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (pathType != null) { sb.append("pathType:"); sb.append(pathType + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (servicePortName != null) { sb.append("servicePortName:"); sb.append(servicePortName + ","); }
    if (servicePortNumber != null) { sb.append("servicePortNumber:"); sb.append(servicePortNumber); }
    sb.append("}");
    return sb.toString();
  }
  

}