/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.ConfigReference;
import io.dekorate.WithConfigReferences;
import io.dekorate.kubernetes.decorator.ApplicationContainerDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import java.util.Arrays;
import java.util.List;

public class ApplyImageDecorator
extends ApplicationContainerDecorator<ContainerFluent>
implements WithConfigReferences {
    private final String image;

    public ApplyImageDecorator(String containerName, String image) {
        super(ANY, containerName);
        this.image = image;
    }

    public ApplyImageDecorator(String deploymentName, String containerName, String image) {
        super(deploymentName, containerName);
        this.image = image;
    }

    @Override
    public void andThenVisit(ContainerFluent container) {
        container.withImage(this.image);
    }

    public List<ConfigReference> getConfigReferences() {
        return Arrays.asList(this.buildConfigReferenceForImage());
    }

    private ConfigReference buildConfigReferenceForImage() {
        String property = "image";
        String path = "spec.template.spec.containers.image";
        if (!Strings.equals((String)this.getDeploymentName(), (String)ANY) && !Strings.equals((String)this.getContainerName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ")].spec.template.spec.containers.(name == " + this.getContainerName() + ").image";
        } else if (!Strings.equals((String)this.getDeploymentName(), (String)ANY)) {
            path = "(metadata.name == " + this.getDeploymentName() + ").spec.template.spec.containers.image";
        } else if (!Strings.equals((String)this.getContainerName(), (String)ANY)) {
            path = "spec.template.spec.containers.(name == " + this.getContainerName() + ").image";
        }
        return new ConfigReference.Builder(property, path).withDescription("The container image to use.").build();
    }
}

