/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.config.ContainerBuilder;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import java.util.Objects;

public class Container {
    private String image;
    private String name;
    private Env[] envVars = new Env[0];
    private String workingDir;
    private String[] command = new String[0];
    private String[] arguments = new String[0];
    private Port[] ports = new Port[0];
    private Mount[] mounts = new Mount[0];
    private ImagePullPolicy imagePullPolicy;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private Probe startupProbe;
    private ResourceRequirements requestResources;
    private ResourceRequirements limitResources;

    public Container() {
    }

    public Container(String image, String name, Env[] envVars, String workingDir, String[] command, String[] arguments, Port[] ports, Mount[] mounts, ImagePullPolicy imagePullPolicy, Probe livenessProbe, Probe readinessProbe, Probe startupProbe, ResourceRequirements requestResources, ResourceRequirements limitResources) {
        this.image = image;
        this.name = name;
        this.envVars = envVars != null ? envVars : new Env[]{};
        this.workingDir = workingDir;
        this.command = command != null ? command : new String[]{};
        this.arguments = arguments != null ? arguments : new String[]{};
        this.ports = ports != null ? ports : new Port[]{};
        this.mounts = mounts != null ? mounts : new Mount[]{};
        this.imagePullPolicy = imagePullPolicy;
        this.livenessProbe = livenessProbe;
        this.readinessProbe = readinessProbe;
        this.startupProbe = startupProbe;
        this.requestResources = requestResources;
        this.limitResources = limitResources;
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public Env[] getEnvVars() {
        return this.envVars;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public Mount[] getMounts() {
        return this.mounts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public Probe getStartupProbe() {
        return this.startupProbe;
    }

    public ResourceRequirements getRequestResources() {
        return this.requestResources;
    }

    public ResourceRequirements getLimitResources() {
        return this.limitResources;
    }

    public static ContainerBuilder newBuilder() {
        return new ContainerBuilder();
    }

    public static ContainerBuilder newBuilderFromDefaults() {
        return (ContainerBuilder)((Object)((ContainerBuilder)((Object)((ContainerBuilder)((Object)((ContainerBuilder)((Object)((ContainerBuilder)((Object)((ContainerBuilder)((Object)new ContainerBuilder().withImagePullPolicy(ImagePullPolicy.IfNotPresent))).withLivenessProbe(new Probe()))).withReadinessProbe(new Probe()))).withStartupProbe(new Probe()))).withRequestResources(new ResourceRequirements()))).withLimitResources(new ResourceRequirements()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Container that = (Container)o;
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.envVars, that.envVars)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.livenessProbe, that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals(this.readinessProbe, that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.startupProbe, that.startupProbe)) {
            return false;
        }
        if (!Objects.equals(this.requestResources, that.requestResources)) {
            return false;
        }
        return Objects.equals(this.limitResources, that.limitResources);
    }

    public int hashCode() {
        return Objects.hash(this.image, this.name, this.envVars, this.workingDir, this.command, this.arguments, this.ports, this.mounts, this.imagePullPolicy, this.livenessProbe, this.readinessProbe, this.startupProbe, this.requestResources, this.limitResources, super.hashCode());
    }
}

