/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.BaseConfigBuilder;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.NodeSelector;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.SecretVolume;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class BaseConfig
extends ApplicationConfiguration {
    private String deploymentKind;
    private Label[] labels = new Label[0];
    private Annotation[] annotations = new Annotation[0];
    private Env[] envVars = new Env[0];
    private String workingDir;
    private String[] command = new String[0];
    private String[] arguments = new String[0];
    private String serviceAccount;
    private Port[] ports = new Port[0];
    private ServiceType serviceType;
    private PersistentVolumeClaimVolume[] pvcVolumes = new PersistentVolumeClaimVolume[0];
    private SecretVolume[] secretVolumes = new SecretVolume[0];
    private ConfigMapVolume[] configMapVolumes = new ConfigMapVolume[0];
    private EmptyDirVolume[] emptyDirVolumes = new EmptyDirVolume[0];
    private GitRepoVolume[] gitRepoVolumes = new GitRepoVolume[0];
    private AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes = new AwsElasticBlockStoreVolume[0];
    private AzureDiskVolume[] azureDiskVolumes = new AzureDiskVolume[0];
    private AzureFileVolume[] azureFileVolumes = new AzureFileVolume[0];
    private Mount[] mounts = new Mount[0];
    private ImagePullPolicy imagePullPolicy;
    private String[] imagePullSecrets = new String[0];
    private DeploymentStrategy deploymentStrategy;
    private RollingUpdate rollingUpdate;
    private HostAlias[] hostAliases = new HostAlias[0];
    private NodeSelector nodeSelector;
    private Probe livenessProbe;
    private Probe readinessProbe;
    private Probe startupProbe;
    private ResourceRequirements requestResources;
    private ResourceRequirements limitResources;
    private Container[] sidecars = new Container[0];
    private Boolean autoDeployEnabled;
    private Job[] jobs = new Job[0];
    private CronJob[] cronJobs = new CronJob[0];

    public BaseConfig() {
    }

    public BaseConfig(Project project, Map<ConfigKey, Object> attributes, String partOf, String name, String version, String deploymentKind, Label[] labels, Annotation[] annotations, Env[] envVars, String workingDir, String[] command, String[] arguments, String serviceAccount, Port[] ports, ServiceType serviceType, PersistentVolumeClaimVolume[] pvcVolumes, SecretVolume[] secretVolumes, ConfigMapVolume[] configMapVolumes, EmptyDirVolume[] emptyDirVolumes, GitRepoVolume[] gitRepoVolumes, AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes, AzureDiskVolume[] azureDiskVolumes, AzureFileVolume[] azureFileVolumes, Mount[] mounts, ImagePullPolicy imagePullPolicy, String[] imagePullSecrets, DeploymentStrategy deploymentStrategy, RollingUpdate rollingUpdate, HostAlias[] hostAliases, NodeSelector nodeSelector, Probe livenessProbe, Probe readinessProbe, Probe startupProbe, ResourceRequirements requestResources, ResourceRequirements limitResources, Container[] sidecars, Boolean autoDeployEnabled, Job[] jobs, CronJob[] cronJobs) {
        super(project, attributes, partOf, name, version);
        this.deploymentKind = deploymentKind;
        this.labels = labels != null ? labels : new Label[]{};
        this.annotations = annotations != null ? annotations : new Annotation[]{};
        this.envVars = envVars != null ? envVars : new Env[]{};
        this.workingDir = workingDir;
        this.command = command != null ? command : new String[]{};
        this.arguments = arguments != null ? arguments : new String[]{};
        this.serviceAccount = serviceAccount;
        this.ports = ports != null ? ports : new Port[]{};
        this.serviceType = serviceType;
        this.pvcVolumes = pvcVolumes != null ? pvcVolumes : new PersistentVolumeClaimVolume[]{};
        this.secretVolumes = secretVolumes != null ? secretVolumes : new SecretVolume[]{};
        this.configMapVolumes = configMapVolumes != null ? configMapVolumes : new ConfigMapVolume[]{};
        this.emptyDirVolumes = emptyDirVolumes != null ? emptyDirVolumes : new EmptyDirVolume[]{};
        this.gitRepoVolumes = gitRepoVolumes != null ? gitRepoVolumes : new GitRepoVolume[]{};
        this.awsElasticBlockStoreVolumes = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes : new AwsElasticBlockStoreVolume[]{};
        this.azureDiskVolumes = azureDiskVolumes != null ? azureDiskVolumes : new AzureDiskVolume[]{};
        this.azureFileVolumes = azureFileVolumes != null ? azureFileVolumes : new AzureFileVolume[]{};
        this.mounts = mounts != null ? mounts : new Mount[]{};
        this.imagePullPolicy = imagePullPolicy;
        this.imagePullSecrets = imagePullSecrets != null ? imagePullSecrets : new String[]{};
        this.deploymentStrategy = deploymentStrategy;
        this.rollingUpdate = rollingUpdate;
        this.hostAliases = hostAliases != null ? hostAliases : new HostAlias[]{};
        this.nodeSelector = nodeSelector;
        this.livenessProbe = livenessProbe;
        this.readinessProbe = readinessProbe;
        this.startupProbe = startupProbe;
        this.requestResources = requestResources;
        this.limitResources = limitResources;
        this.sidecars = sidecars != null ? sidecars : new Container[]{};
        this.autoDeployEnabled = autoDeployEnabled;
        this.jobs = jobs != null ? jobs : new Job[]{};
        this.cronJobs = cronJobs != null ? cronJobs : new CronJob[]{};
    }

    public String getDeploymentKind() {
        return this.deploymentKind;
    }

    public Label[] getLabels() {
        return this.labels;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Env[] getEnvVars() {
        return this.envVars;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public PersistentVolumeClaimVolume[] getPvcVolumes() {
        return this.pvcVolumes;
    }

    public SecretVolume[] getSecretVolumes() {
        return this.secretVolumes;
    }

    public ConfigMapVolume[] getConfigMapVolumes() {
        return this.configMapVolumes;
    }

    public EmptyDirVolume[] getEmptyDirVolumes() {
        return this.emptyDirVolumes;
    }

    public GitRepoVolume[] getGitRepoVolumes() {
        return this.gitRepoVolumes;
    }

    public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes;
    }

    public AzureDiskVolume[] getAzureDiskVolumes() {
        return this.azureDiskVolumes;
    }

    public AzureFileVolume[] getAzureFileVolumes() {
        return this.azureFileVolumes;
    }

    public Mount[] getMounts() {
        return this.mounts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public String[] getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public DeploymentStrategy getDeploymentStrategy() {
        return this.deploymentStrategy;
    }

    public RollingUpdate getRollingUpdate() {
        return this.rollingUpdate;
    }

    public HostAlias[] getHostAliases() {
        return this.hostAliases;
    }

    public NodeSelector getNodeSelector() {
        return this.nodeSelector;
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public Probe getStartupProbe() {
        return this.startupProbe;
    }

    public ResourceRequirements getRequestResources() {
        return this.requestResources;
    }

    public ResourceRequirements getLimitResources() {
        return this.limitResources;
    }

    public Container[] getSidecars() {
        return this.sidecars;
    }

    public Boolean getAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled != null && this.autoDeployEnabled != false;
    }

    public Job[] getJobs() {
        return this.jobs;
    }

    public CronJob[] getCronJobs() {
        return this.cronJobs;
    }

    public static BaseConfigBuilder newBaseConfigBuilder() {
        return new BaseConfigBuilder();
    }

    public static BaseConfigBuilder newBaseConfigBuilderFromDefaults() {
        return (BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)((BaseConfigBuilder)((Object)new BaseConfigBuilder().withDeploymentKind("Deployment"))).withServiceType(ServiceType.ClusterIP))).withImagePullPolicy(ImagePullPolicy.IfNotPresent))).withDeploymentStrategy(DeploymentStrategy.None))).withLivenessProbe(new Probe()))).withReadinessProbe(new Probe()))).withStartupProbe(new Probe()))).withRequestResources(new ResourceRequirements()))).withLimitResources(new ResourceRequirements()))).withAutoDeployEnabled(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseConfig that = (BaseConfig)o;
        if (!Objects.equals(this.deploymentKind, that.deploymentKind)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.envVars, that.envVars)) {
            return false;
        }
        if (!Objects.equals(this.workingDir, that.workingDir)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.arguments, that.arguments)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals((Object)this.serviceType, (Object)that.serviceType)) {
            return false;
        }
        if (!Objects.equals(this.pvcVolumes, that.pvcVolumes)) {
            return false;
        }
        if (!Objects.equals(this.secretVolumes, that.secretVolumes)) {
            return false;
        }
        if (!Objects.equals(this.configMapVolumes, that.configMapVolumes)) {
            return false;
        }
        if (!Objects.equals(this.emptyDirVolumes, that.emptyDirVolumes)) {
            return false;
        }
        if (!Objects.equals(this.gitRepoVolumes, that.gitRepoVolumes)) {
            return false;
        }
        if (!Objects.equals(this.awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureDiskVolumes, that.azureDiskVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureFileVolumes, that.azureFileVolumes)) {
            return false;
        }
        if (!Objects.equals(this.mounts, that.mounts)) {
            return false;
        }
        if (!Objects.equals((Object)this.imagePullPolicy, (Object)that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.imagePullSecrets, that.imagePullSecrets)) {
            return false;
        }
        if (!Objects.equals((Object)this.deploymentStrategy, (Object)that.deploymentStrategy)) {
            return false;
        }
        if (!Objects.equals(this.rollingUpdate, that.rollingUpdate)) {
            return false;
        }
        if (!Objects.equals(this.hostAliases, that.hostAliases)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.livenessProbe, that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals(this.readinessProbe, that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.startupProbe, that.startupProbe)) {
            return false;
        }
        if (!Objects.equals(this.requestResources, that.requestResources)) {
            return false;
        }
        if (!Objects.equals(this.limitResources, that.limitResources)) {
            return false;
        }
        if (!Objects.equals(this.sidecars, that.sidecars)) {
            return false;
        }
        if (!Objects.equals(this.autoDeployEnabled, that.autoDeployEnabled)) {
            return false;
        }
        if (!Objects.equals(this.jobs, that.jobs)) {
            return false;
        }
        return Objects.equals(this.cronJobs, that.cronJobs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deploymentKind, this.labels, this.annotations, this.envVars, this.workingDir, this.command, this.arguments, this.serviceAccount, this.ports, this.serviceType, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.emptyDirVolumes, this.gitRepoVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.mounts, this.imagePullPolicy, this.imagePullSecrets, this.deploymentStrategy, this.rollingUpdate, this.hostAliases, this.nodeSelector, this.livenessProbe, this.readinessProbe, this.startupProbe, this.requestResources, this.limitResources, this.sidecars, this.autoDeployEnabled, this.jobs, this.cronJobs, super.hashCode()});
    }
}

