/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.JobBuilder;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.SecretVolume;
import java.util.Objects;

public class Job {
    private String name;
    private Integer parallelism;
    private Integer completions;
    private JobCompletionMode completionMode;
    private Integer backoffLimit;
    private Long activeDeadlineSeconds;
    private Integer ttlSecondsAfterFinished;
    private Boolean suspend;
    private JobRestartPolicy restartPolicy;
    private PersistentVolumeClaimVolume[] pvcVolumes = new PersistentVolumeClaimVolume[0];
    private SecretVolume[] secretVolumes = new SecretVolume[0];
    private ConfigMapVolume[] configMapVolumes = new ConfigMapVolume[0];
    private EmptyDirVolume[] emptyDirVolumes = new EmptyDirVolume[0];
    private AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes = new AwsElasticBlockStoreVolume[0];
    private AzureDiskVolume[] azureDiskVolumes = new AzureDiskVolume[0];
    private AzureFileVolume[] azureFileVolumes = new AzureFileVolume[0];
    private Container[] containers;

    public Job() {
    }

    public Job(String name, Integer parallelism, Integer completions, JobCompletionMode completionMode, Integer backoffLimit, Long activeDeadlineSeconds, Integer ttlSecondsAfterFinished, Boolean suspend, JobRestartPolicy restartPolicy, PersistentVolumeClaimVolume[] pvcVolumes, SecretVolume[] secretVolumes, ConfigMapVolume[] configMapVolumes, EmptyDirVolume[] emptyDirVolumes, AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes, AzureDiskVolume[] azureDiskVolumes, AzureFileVolume[] azureFileVolumes, Container[] containers) {
        this.name = name;
        this.parallelism = parallelism;
        this.completions = completions;
        this.completionMode = completionMode;
        this.backoffLimit = backoffLimit;
        this.activeDeadlineSeconds = activeDeadlineSeconds;
        this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
        this.suspend = suspend;
        this.restartPolicy = restartPolicy;
        this.pvcVolumes = pvcVolumes != null ? pvcVolumes : new PersistentVolumeClaimVolume[]{};
        this.secretVolumes = secretVolumes != null ? secretVolumes : new SecretVolume[]{};
        this.configMapVolumes = configMapVolumes != null ? configMapVolumes : new ConfigMapVolume[]{};
        this.emptyDirVolumes = emptyDirVolumes != null ? emptyDirVolumes : new EmptyDirVolume[]{};
        this.awsElasticBlockStoreVolumes = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes : new AwsElasticBlockStoreVolume[]{};
        this.azureDiskVolumes = azureDiskVolumes != null ? azureDiskVolumes : new AzureDiskVolume[]{};
        this.azureFileVolumes = azureFileVolumes != null ? azureFileVolumes : new AzureFileVolume[]{};
        this.containers = containers != null ? containers : new Container[]{};
    }

    public String getName() {
        return this.name;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public Integer getCompletions() {
        return this.completions;
    }

    public JobCompletionMode getCompletionMode() {
        return this.completionMode;
    }

    public Integer getBackoffLimit() {
        return this.backoffLimit;
    }

    public Long getActiveDeadlineSeconds() {
        return this.activeDeadlineSeconds;
    }

    public Integer getTtlSecondsAfterFinished() {
        return this.ttlSecondsAfterFinished;
    }

    public Boolean getSuspend() {
        return this.suspend;
    }

    public boolean isSuspend() {
        return this.suspend != null && this.suspend != false;
    }

    public JobRestartPolicy getRestartPolicy() {
        return this.restartPolicy;
    }

    public PersistentVolumeClaimVolume[] getPvcVolumes() {
        return this.pvcVolumes;
    }

    public SecretVolume[] getSecretVolumes() {
        return this.secretVolumes;
    }

    public ConfigMapVolume[] getConfigMapVolumes() {
        return this.configMapVolumes;
    }

    public EmptyDirVolume[] getEmptyDirVolumes() {
        return this.emptyDirVolumes;
    }

    public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes;
    }

    public AzureDiskVolume[] getAzureDiskVolumes() {
        return this.azureDiskVolumes;
    }

    public AzureFileVolume[] getAzureFileVolumes() {
        return this.azureFileVolumes;
    }

    public Container[] getContainers() {
        return this.containers;
    }

    public static JobBuilder newBuilder() {
        return new JobBuilder();
    }

    public static JobBuilder newBuilderFromDefaults() {
        return (JobBuilder)((Object)((JobBuilder)((Object)((JobBuilder)((Object)((JobBuilder)((Object)((JobBuilder)((Object)((JobBuilder)((Object)((JobBuilder)((Object)((JobBuilder)((Object)new JobBuilder().withParallelism(-1))).withCompletions(-1))).withCompletionMode(JobCompletionMode.NonIndexed))).withBackoffLimit(-1))).withActiveDeadlineSeconds(-1L))).withTtlSecondsAfterFinished(-1))).withSuspend(false))).withRestartPolicy(JobRestartPolicy.OnFailure));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Job that = (Job)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.parallelism, that.parallelism)) {
            return false;
        }
        if (!Objects.equals(this.completions, that.completions)) {
            return false;
        }
        if (!Objects.equals(this.completionMode, that.completionMode)) {
            return false;
        }
        if (!Objects.equals(this.backoffLimit, that.backoffLimit)) {
            return false;
        }
        if (!Objects.equals(this.activeDeadlineSeconds, that.activeDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.pvcVolumes, that.pvcVolumes)) {
            return false;
        }
        if (!Objects.equals(this.secretVolumes, that.secretVolumes)) {
            return false;
        }
        if (!Objects.equals(this.configMapVolumes, that.configMapVolumes)) {
            return false;
        }
        if (!Objects.equals(this.emptyDirVolumes, that.emptyDirVolumes)) {
            return false;
        }
        if (!Objects.equals(this.awsElasticBlockStoreVolumes, that.awsElasticBlockStoreVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureDiskVolumes, that.azureDiskVolumes)) {
            return false;
        }
        if (!Objects.equals(this.azureFileVolumes, that.azureFileVolumes)) {
            return false;
        }
        return Objects.equals(this.containers, that.containers);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.parallelism, this.completions, this.completionMode, this.backoffLimit, this.activeDeadlineSeconds, this.ttlSecondsAfterFinished, this.suspend, this.restartPolicy, this.pvcVolumes, this.secretVolumes, this.configMapVolumes, this.emptyDirVolumes, this.awsElasticBlockStoreVolumes, this.azureDiskVolumes, this.azureFileVolumes, this.containers, super.hashCode());
    }
}

