/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.config;

import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.config.Port;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Objects;

public class PortFluent<A extends PortFluent<A>>
extends BaseFluent<A> {
    private String name;
    private Integer containerPort;
    private Integer hostPort;
    private Integer nodePort;
    private String path;
    private Protocol protocol;

    public PortFluent() {
    }

    public PortFluent(Port instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Port instance) {
        Port port = instance = instance != null ? instance : new Port();
        if (instance != null) {
            this.withName(instance.getName());
            this.withContainerPort(instance.getContainerPort());
            this.withHostPort(instance.getHostPort());
            this.withNodePort(instance.getNodePort());
            this.withPath(instance.getPath());
            this.withProtocol(instance.getProtocol());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public A withContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
        return (A)((Object)this);
    }

    public boolean hasContainerPort() {
        return this.containerPort != null;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public A withHostPort(Integer hostPort) {
        this.hostPort = hostPort;
        return (A)((Object)this);
    }

    public boolean hasHostPort() {
        return this.hostPort != null;
    }

    public Integer getNodePort() {
        return this.nodePort;
    }

    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)((Object)this);
    }

    public boolean hasNodePort() {
        return this.nodePort != null;
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public A withProtocol(Protocol protocol) {
        this.protocol = protocol;
        return (A)((Object)this);
    }

    public boolean hasProtocol() {
        return this.protocol != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortFluent that = (PortFluent)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.containerPort, that.containerPort)) {
            return false;
        }
        if (!Objects.equals(this.hostPort, that.hostPort)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.protocol, that.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.containerPort, this.hostPort, this.nodePort, this.path, this.protocol, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.containerPort != null) {
            sb.append("containerPort:");
            sb.append(this.containerPort + ",");
        }
        if (this.hostPort != null) {
            sb.append("hostPort:");
            sb.append(this.hostPort + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol);
        }
        sb.append("}");
        return sb.toString();
    }
}

