/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.decorator;

import io.dekorate.kubernetes.config.NodeSelector;
import io.dekorate.kubernetes.decorator.NamedResourceDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PodSpecFluent;
import java.util.Objects;

public class AddNodeSelectorDecorator
extends NamedResourceDecorator<PodSpecFluent<?>> {
    private final NodeSelector nodeSelector;

    public AddNodeSelectorDecorator(String deploymentName, NodeSelector nodeSelector) {
        super(deploymentName);
        this.nodeSelector = nodeSelector;
    }

    @Override
    public void andThenVisit(PodSpecFluent<?> podSpec, ObjectMeta resourceMeta) {
        if (Strings.isNotNullOrEmpty((String)this.nodeSelector.getKey()) && Strings.isNotNullOrEmpty((String)this.nodeSelector.getValue())) {
            podSpec.removeFromNodeSelector(this.nodeSelector.getKey());
            podSpec.addToNodeSelector(this.nodeSelector.getKey(), this.nodeSelector.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddNodeSelectorDecorator that = (AddNodeSelectorDecorator)o;
        return Objects.equals(this.nodeSelector, that.nodeSelector);
    }

    public int hashCode() {
        return Objects.hash(this.nodeSelector);
    }
}

