package io.dekorate.kubernetes.config;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubernetesConfigFluent<A extends KubernetesConfigFluent<A>> extends BaseConfigFluent<A>{
  public KubernetesConfigFluent() {
  }
  
  public KubernetesConfigFluent(KubernetesConfig instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ContainerBuilder> initContainers = new ArrayList<ContainerBuilder>();
  private Integer replicas;
  private IngressBuilder ingress;
  private Boolean headless;
  
  protected void copyInstance(KubernetesConfig instance) {
    instance = (instance != null ? instance : new KubernetesConfig());
    if (instance != null) {
          this.withProject(instance.getProject());
          this.withAttributes(instance.getAttributes());
          this.withPartOf(instance.getPartOf());
          this.withName(instance.getName());
          this.withVersion(instance.getVersion());
          this.withDeploymentKind(instance.getDeploymentKind());
          this.withLabels(instance.getLabels());
          this.withAnnotations(instance.getAnnotations());
          this.withEnvVars(instance.getEnvVars());
          this.withWorkingDir(instance.getWorkingDir());
          this.withCommand(instance.getCommand());
          this.withArguments(instance.getArguments());
          this.withServiceAccount(instance.getServiceAccount());
          this.withPorts(instance.getPorts());
          this.withServiceType(instance.getServiceType());
          this.withPvcVolumes(instance.getPvcVolumes());
          this.withSecretVolumes(instance.getSecretVolumes());
          this.withConfigMapVolumes(instance.getConfigMapVolumes());
          this.withEmptyDirVolumes(instance.getEmptyDirVolumes());
          this.withGitRepoVolumes(instance.getGitRepoVolumes());
          this.withAwsElasticBlockStoreVolumes(instance.getAwsElasticBlockStoreVolumes());
          this.withAzureDiskVolumes(instance.getAzureDiskVolumes());
          this.withAzureFileVolumes(instance.getAzureFileVolumes());
          this.withMounts(instance.getMounts());
          this.withImagePullPolicy(instance.getImagePullPolicy());
          this.withImagePullSecrets(instance.getImagePullSecrets());
          this.withDeploymentStrategy(instance.getDeploymentStrategy());
          this.withRollingUpdate(instance.getRollingUpdate());
          this.withHostAliases(instance.getHostAliases());
          this.withNodeSelector(instance.getNodeSelector());
          this.withLivenessProbe(instance.getLivenessProbe());
          this.withReadinessProbe(instance.getReadinessProbe());
          this.withStartupProbe(instance.getStartupProbe());
          this.withRequestResources(instance.getRequestResources());
          this.withLimitResources(instance.getLimitResources());
          this.withSidecars(instance.getSidecars());
          this.withAutoDeployEnabled(instance.getAutoDeployEnabled());
          this.withJobs(instance.getJobs());
          this.withCronJobs(instance.getCronJobs());
          this.withInitContainers(instance.getInitContainers());
          this.withReplicas(instance.getReplicas());
          this.withIngress(instance.getIngress());
          this.withHeadless(instance.getHeadless());
        }
  }
  
  public A withInitContainers(io.dekorate.kubernetes.config.Container... initContainers) {
    if (this.initContainers != null) {
        this.initContainers.clear();
        _visitables.remove("initContainers");
    }
    if (initContainers != null) {
      for (Container item : initContainers) {
        this.addToInitContainers(item);
      }
    }
    return (A) this;
  }
  
  public Container[] buildInitContainers() {
    int size = initContainers != null ? initContainers.size() : 0;;
    Container[] result = new Container[size];;
    if (size == 0) {
      return result;
    }
    int index = 0;;
    for (VisitableBuilder<Container,ContainerBuilder> item : initContainers) {
      result[index++] = item.build();
    }
    return result;
  }
  
  public Container buildInitContainer(int index) {
    return this.initContainers.get(index).build();
  }
  
  public Container buildFirstInitContainer() {
    return this.initContainers.get(0).build();
  }
  
  public Container buildLastInitContainer() {
    return this.initContainers.get(initContainers.size() - 1).build();
  }
  
  public Container buildMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : initContainers) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
      for (ContainerBuilder item : initContainers) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A addToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) { _visitables.get("initContainers").add(builder); initContainers.add(builder); } else { _visitables.get("initContainers").add(index, builder); initContainers.add(index, builder);}
    return (A)this;
  }
  
  public A setToInitContainers(int index,Container item) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    ContainerBuilder builder = new ContainerBuilder(item);
    if (index < 0 || index >= initContainers.size()) { _visitables.get("initContainers").add(builder); initContainers.add(builder); } else { _visitables.get("initContainers").set(index, builder); initContainers.set(index, builder);}
    return (A)this;
  }
  
  public A addToInitContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  
  public A addAllToInitContainers(Collection<Container> items) {
    if (this.initContainers == null) {this.initContainers = new ArrayList<ContainerBuilder>();}
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").add(builder);this.initContainers.add(builder);} return (A)this;
  }
  
  public A removeFromInitContainers(io.dekorate.kubernetes.config.Container... items) {
    if (this.initContainers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder); this.initContainers.remove(builder);} return (A)this;
  }
  
  public A removeAllFromInitContainers(Collection<Container> items) {
    if (this.initContainers == null) return (A)this;
    for (Container item : items) {ContainerBuilder builder = new ContainerBuilder(item);_visitables.get("initContainers").remove(builder); this.initContainers.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromInitContainers(Predicate<ContainerBuilder> predicate) {
    if (initContainers == null) return (A) this;
    final Iterator<ContainerBuilder> each = initContainers.iterator();
    final List visitables = _visitables.get("initContainers");
    while (each.hasNext()) {
      ContainerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public boolean hasInitContainers() {
    return this.initContainers != null && !this.initContainers.isEmpty();
  }
  
  public InitContainersNested<A> addNewInitContainer() {
    return new InitContainersNested(-1, null);
  }
  
  public InitContainersNested<A> addNewInitContainerLike(Container item) {
    return new InitContainersNested(-1, item);
  }
  
  public InitContainersNested<A> setNewInitContainerLike(int index,Container item) {
    return new InitContainersNested(index, item);
  }
  
  public InitContainersNested<A> editInitContainer(int index) {
    if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  
  public InitContainersNested<A> editFirstInitContainer() {
    if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
    return setNewInitContainerLike(0, buildInitContainer(0));
  }
  
  public InitContainersNested<A> editLastInitContainer() {
    int index = initContainers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  
  public InitContainersNested<A> editMatchingInitContainer(Predicate<ContainerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<initContainers.size();i++) { 
    if (predicate.test(initContainers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
    return setNewInitContainerLike(index, buildInitContainer(index));
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public Ingress buildIngress() {
    return this.ingress != null ? this.ingress.build() : null;
  }
  
  public A withIngress(Ingress ingress) {
    this._visitables.remove("ingress");
    if (ingress != null) {
        this.ingress = new IngressBuilder(ingress);
        this._visitables.get("ingress").add(this.ingress);
    } else {
        this.ingress = null;
        this._visitables.get("ingress").remove(this.ingress);
    }
    return (A) this;
  }
  
  public boolean hasIngress() {
    return this.ingress != null;
  }
  
  public IngressNested<A> withNewIngress() {
    return new IngressNested(null);
  }
  
  public IngressNested<A> withNewIngressLike(Ingress item) {
    return new IngressNested(item);
  }
  
  public IngressNested<A> editIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(null));
  }
  
  public IngressNested<A> editOrNewIngress() {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(new IngressBuilder().build()));
  }
  
  public IngressNested<A> editOrNewIngressLike(Ingress item) {
    return withNewIngressLike(java.util.Optional.ofNullable(buildIngress()).orElse(item));
  }
  
  public Boolean getHeadless() {
    return this.headless;
  }
  
  public A withHeadless(Boolean headless) {
    this.headless = headless;
    return (A) this;
  }
  
  public boolean hasHeadless() {
    return this.headless != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesConfigFluent that = (KubernetesConfigFluent) o;
    if (!java.util.Objects.equals(initContainers, that.initContainers)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
    if (!java.util.Objects.equals(headless, that.headless)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(initContainers,  replicas,  ingress,  headless,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (initContainers != null && !initContainers.isEmpty()) { sb.append("initContainers:"); sb.append(initContainers + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (ingress != null) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (headless != null) { sb.append("headless:"); sb.append(headless); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withHeadless() {
    return withHeadless(true);
  }
  public class InitContainersNested<N> extends ContainerFluent<InitContainersNested<N>> implements Nested<N>{
    InitContainersNested(int index,Container item) {
      this.index = index;
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    int index;
    
    public N and() {
      return (N) KubernetesConfigFluent.this.setToInitContainers(index,builder.build());
    }
    
    public N endInitContainer() {
      return and();
    }
    
  
  }
  public class IngressNested<N> extends IngressFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(Ingress item) {
      this.builder = new IngressBuilder(this, item);
    }
    IngressBuilder builder;
    
    public N and() {
      return (N) KubernetesConfigFluent.this.withIngress(builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }

}