/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.kubernetes.adapter;

import io.dekorate.kubernetes.annotation.CronJobConcurrencyPolicy;
import io.dekorate.kubernetes.annotation.ImagePullPolicy;
import io.dekorate.kubernetes.annotation.JobCompletionMode;
import io.dekorate.kubernetes.annotation.JobRestartPolicy;
import io.dekorate.kubernetes.annotation.KubernetesApplication;
import io.dekorate.kubernetes.annotation.Protocol;
import io.dekorate.kubernetes.annotation.ServiceType;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.AwsElasticBlockStoreVolume;
import io.dekorate.kubernetes.config.AzureDiskVolume;
import io.dekorate.kubernetes.config.AzureFileVolume;
import io.dekorate.kubernetes.config.ConfigMapVolume;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.CronJob;
import io.dekorate.kubernetes.config.DeploymentStrategy;
import io.dekorate.kubernetes.config.EmptyDirVolume;
import io.dekorate.kubernetes.config.Env;
import io.dekorate.kubernetes.config.GitRepoVolume;
import io.dekorate.kubernetes.config.HostAlias;
import io.dekorate.kubernetes.config.Ingress;
import io.dekorate.kubernetes.config.IngressRule;
import io.dekorate.kubernetes.config.Item;
import io.dekorate.kubernetes.config.Job;
import io.dekorate.kubernetes.config.KubernetesConfig;
import io.dekorate.kubernetes.config.KubernetesConfigBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.config.Mount;
import io.dekorate.kubernetes.config.NodeSelector;
import io.dekorate.kubernetes.config.PersistentVolumeClaimVolume;
import io.dekorate.kubernetes.config.Port;
import io.dekorate.kubernetes.config.Probe;
import io.dekorate.kubernetes.config.ResourceRequirements;
import io.dekorate.kubernetes.config.RollingUpdate;
import io.dekorate.kubernetes.config.SecretVolume;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KubernetesConfigAdapter {
    public static KubernetesConfig adapt(KubernetesApplication instance) {
        return KubernetesConfigAdapter.newBuilder(instance).build();
    }

    public static KubernetesConfigBuilder newBuilder(KubernetesApplication instance) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, instance.partOf(), instance.name(), instance.version(), instance.deploymentKind(), Arrays.asList(instance.labels()).stream().map(i -> new Label(i.key(), i.value(), i.kinds())).collect(Collectors.toList()).toArray(new Label[0]), Arrays.asList(instance.annotations()).stream().map(i -> new Annotation(i.key(), i.value(), i.kinds())).collect(Collectors.toList()).toArray(new Annotation[0]), Arrays.asList(instance.envVars()).stream().map(i -> new Env(i.name(), i.value(), i.secret(), i.configmap(), i.field(), i.resourceField(), i.prefix())).collect(Collectors.toList()).toArray(new Env[0]), instance.workingDir(), instance.command(), instance.arguments(), instance.serviceAccount(), Arrays.asList(instance.ports()).stream().map(i -> new Port(i.name(), Integer.valueOf(i.containerPort()), Integer.valueOf(i.hostPort()), Integer.valueOf(i.nodePort()), i.path(), i.protocol())).collect(Collectors.toList()).toArray(new Port[0]), instance.serviceType(), Arrays.asList(instance.pvcVolumes()).stream().map(i -> new PersistentVolumeClaimVolume(i.volumeName(), i.claimName(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]), Arrays.asList(instance.secretVolumes()).stream().map(i -> new SecretVolume(i.volumeName(), i.secretName(), Integer.valueOf(i.defaultMode()), Boolean.valueOf(i.optional()), Arrays.asList(i.items()).stream().map(j -> new Item(j.key(), j.path(), Integer.valueOf(j.mode()))).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new SecretVolume[0]), Arrays.asList(instance.configMapVolumes()).stream().map(i -> new ConfigMapVolume(i.volumeName(), i.configMapName(), Integer.valueOf(i.defaultMode()), Boolean.valueOf(i.optional()), Arrays.asList(i.items()).stream().map(j -> new Item(j.key(), j.path(), Integer.valueOf(j.mode()))).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]), Arrays.asList(instance.emptyDirVolumes()).stream().map(i -> new EmptyDirVolume(i.volumeName())).collect(Collectors.toList()).toArray(new EmptyDirVolume[0]), Arrays.asList(instance.gitRepoVolumes()).stream().map(i -> new GitRepoVolume(i.volumeName(), i.repository(), i.directory(), i.revision())).collect(Collectors.toList()).toArray(new GitRepoVolume[0]), Arrays.asList(instance.awsElasticBlockStoreVolumes()).stream().map(i -> new AwsElasticBlockStoreVolume(i.volumeName(), i.volumeId(), Integer.valueOf(i.partition()), i.fsType(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]), Arrays.asList(instance.azureDiskVolumes()).stream().map(i -> new AzureDiskVolume(i.volumeName(), i.diskName(), i.diskURI(), i.kind(), i.cachingMode(), i.fsType(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]), Arrays.asList(instance.azureFileVolumes()).stream().map(i -> new AzureFileVolume(i.volumeName(), i.shareName(), i.secretName(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new AzureFileVolume[0]), Arrays.asList(instance.mounts()).stream().map(i -> new Mount(i.name(), i.path(), i.subPath(), Boolean.valueOf(i.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), instance.imagePullPolicy(), instance.imagePullSecrets(), instance.deploymentStrategy(), new RollingUpdate(instance.rollingUpdate().maxUnavailable(), instance.rollingUpdate().maxSurge()), Arrays.asList(instance.hostAliases()).stream().map(i -> new HostAlias(i.ip(), i.hostnames())).collect(Collectors.toList()).toArray(new HostAlias[0]), new NodeSelector(instance.nodeSelector().key(), instance.nodeSelector().value()), new Probe(instance.livenessProbe().httpActionPath(), instance.livenessProbe().execAction(), instance.livenessProbe().tcpSocketAction(), instance.livenessProbe().grpcAction(), Integer.valueOf(instance.livenessProbe().initialDelaySeconds()), Integer.valueOf(instance.livenessProbe().periodSeconds()), Integer.valueOf(instance.livenessProbe().timeoutSeconds()), Integer.valueOf(instance.livenessProbe().successThreshold()), Integer.valueOf(instance.livenessProbe().failureThreshold())), new Probe(instance.readinessProbe().httpActionPath(), instance.readinessProbe().execAction(), instance.readinessProbe().tcpSocketAction(), instance.readinessProbe().grpcAction(), Integer.valueOf(instance.readinessProbe().initialDelaySeconds()), Integer.valueOf(instance.readinessProbe().periodSeconds()), Integer.valueOf(instance.readinessProbe().timeoutSeconds()), Integer.valueOf(instance.readinessProbe().successThreshold()), Integer.valueOf(instance.readinessProbe().failureThreshold())), new Probe(instance.startupProbe().httpActionPath(), instance.startupProbe().execAction(), instance.startupProbe().tcpSocketAction(), instance.startupProbe().grpcAction(), Integer.valueOf(instance.startupProbe().initialDelaySeconds()), Integer.valueOf(instance.startupProbe().periodSeconds()), Integer.valueOf(instance.startupProbe().timeoutSeconds()), Integer.valueOf(instance.startupProbe().successThreshold()), Integer.valueOf(instance.startupProbe().failureThreshold())), new ResourceRequirements(instance.requestResources().memory(), instance.requestResources().cpu()), new ResourceRequirements(instance.limitResources().memory(), instance.limitResources().cpu()), Arrays.asList(instance.sidecars()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field(), j.resourceField(), j.prefix())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), Integer.valueOf(j.containerPort()), Integer.valueOf(j.hostPort()), Integer.valueOf(j.nodePort()), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), i.livenessProbe().grpcAction(), Integer.valueOf(i.livenessProbe().initialDelaySeconds()), Integer.valueOf(i.livenessProbe().periodSeconds()), Integer.valueOf(i.livenessProbe().timeoutSeconds()), Integer.valueOf(i.livenessProbe().successThreshold()), Integer.valueOf(i.livenessProbe().failureThreshold())), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), i.readinessProbe().grpcAction(), Integer.valueOf(i.readinessProbe().initialDelaySeconds()), Integer.valueOf(i.readinessProbe().periodSeconds()), Integer.valueOf(i.readinessProbe().timeoutSeconds()), Integer.valueOf(i.readinessProbe().successThreshold()), Integer.valueOf(i.readinessProbe().failureThreshold())), new Probe(i.startupProbe().httpActionPath(), i.startupProbe().execAction(), i.startupProbe().tcpSocketAction(), i.startupProbe().grpcAction(), Integer.valueOf(i.startupProbe().initialDelaySeconds()), Integer.valueOf(i.startupProbe().periodSeconds()), Integer.valueOf(i.startupProbe().timeoutSeconds()), Integer.valueOf(i.startupProbe().successThreshold()), Integer.valueOf(i.startupProbe().failureThreshold())), new ResourceRequirements(i.requestResources().memory(), i.requestResources().cpu()), new ResourceRequirements(i.limitResources().memory(), i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]), instance.autoDeployEnabled(), Arrays.asList(instance.jobs()).stream().map(i -> new Job(i.name(), Integer.valueOf(i.parallelism()), Integer.valueOf(i.completions()), i.completionMode(), Integer.valueOf(i.backoffLimit()), Long.valueOf(i.activeDeadlineSeconds()), Integer.valueOf(i.ttlSecondsAfterFinished()), Boolean.valueOf(i.suspend()), i.restartPolicy(), Arrays.asList(i.pvcVolumes()).stream().map(j -> new PersistentVolumeClaimVolume(j.volumeName(), j.claimName(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]), Arrays.asList(i.secretVolumes()).stream().map(j -> new SecretVolume(j.volumeName(), j.secretName(), Integer.valueOf(j.defaultMode()), Boolean.valueOf(j.optional()), Arrays.asList(j.items()).stream().map(k -> new Item(k.key(), k.path(), Integer.valueOf(k.mode()))).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new SecretVolume[0]), Arrays.asList(i.configMapVolumes()).stream().map(j -> new ConfigMapVolume(j.volumeName(), j.configMapName(), Integer.valueOf(j.defaultMode()), Boolean.valueOf(j.optional()), Arrays.asList(j.items()).stream().map(k -> new Item(k.key(), k.path(), Integer.valueOf(k.mode()))).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]), Arrays.asList(i.emptyDirVolumes()).stream().map(j -> new EmptyDirVolume(j.volumeName())).collect(Collectors.toList()).toArray(new EmptyDirVolume[0]), Arrays.asList(i.awsElasticBlockStoreVolumes()).stream().map(j -> new AwsElasticBlockStoreVolume(j.volumeName(), j.volumeId(), Integer.valueOf(j.partition()), j.fsType(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]), Arrays.asList(i.azureDiskVolumes()).stream().map(j -> new AzureDiskVolume(j.volumeName(), j.diskName(), j.diskURI(), j.kind(), j.cachingMode(), j.fsType(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]), Arrays.asList(i.azureFileVolumes()).stream().map(j -> new AzureFileVolume(j.volumeName(), j.shareName(), j.secretName(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new AzureFileVolume[0]), Arrays.asList(i.containers()).stream().map(j -> new Container(j.image(), j.name(), Arrays.asList(j.envVars()).stream().map(k -> new Env(k.name(), k.value(), k.secret(), k.configmap(), k.field(), k.resourceField(), k.prefix())).collect(Collectors.toList()).toArray(new Env[0]), j.workingDir(), j.command(), j.arguments(), Arrays.asList(j.ports()).stream().map(k -> new Port(k.name(), Integer.valueOf(k.containerPort()), Integer.valueOf(k.hostPort()), Integer.valueOf(k.nodePort()), k.path(), k.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(j.mounts()).stream().map(k -> new Mount(k.name(), k.path(), k.subPath(), Boolean.valueOf(k.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), j.imagePullPolicy(), new Probe(j.livenessProbe().httpActionPath(), j.livenessProbe().execAction(), j.livenessProbe().tcpSocketAction(), j.livenessProbe().grpcAction(), Integer.valueOf(j.livenessProbe().initialDelaySeconds()), Integer.valueOf(j.livenessProbe().periodSeconds()), Integer.valueOf(j.livenessProbe().timeoutSeconds()), Integer.valueOf(j.livenessProbe().successThreshold()), Integer.valueOf(j.livenessProbe().failureThreshold())), new Probe(j.readinessProbe().httpActionPath(), j.readinessProbe().execAction(), j.readinessProbe().tcpSocketAction(), j.readinessProbe().grpcAction(), Integer.valueOf(j.readinessProbe().initialDelaySeconds()), Integer.valueOf(j.readinessProbe().periodSeconds()), Integer.valueOf(j.readinessProbe().timeoutSeconds()), Integer.valueOf(j.readinessProbe().successThreshold()), Integer.valueOf(j.readinessProbe().failureThreshold())), new Probe(j.startupProbe().httpActionPath(), j.startupProbe().execAction(), j.startupProbe().tcpSocketAction(), j.startupProbe().grpcAction(), Integer.valueOf(j.startupProbe().initialDelaySeconds()), Integer.valueOf(j.startupProbe().periodSeconds()), Integer.valueOf(j.startupProbe().timeoutSeconds()), Integer.valueOf(j.startupProbe().successThreshold()), Integer.valueOf(j.startupProbe().failureThreshold())), new ResourceRequirements(j.requestResources().memory(), j.requestResources().cpu()), new ResourceRequirements(j.limitResources().memory(), j.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]))).collect(Collectors.toList()).toArray(new Job[0]), Arrays.asList(instance.cronJobs()).stream().map(i -> new CronJob(i.name(), i.schedule(), i.concurrencyPolicy(), Long.valueOf(i.startingDeadlineSeconds()), Integer.valueOf(i.failedJobsHistoryLimit()), Integer.valueOf(i.successfulJobsHistoryLimit()), Integer.valueOf(i.parallelism()), Integer.valueOf(i.completions()), i.completionMode(), Integer.valueOf(i.backoffLimit()), Long.valueOf(i.activeDeadlineSeconds()), Integer.valueOf(i.ttlSecondsAfterFinished()), Boolean.valueOf(i.suspend()), i.restartPolicy(), Arrays.asList(i.pvcVolumes()).stream().map(j -> new PersistentVolumeClaimVolume(j.volumeName(), j.claimName(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new PersistentVolumeClaimVolume[0]), Arrays.asList(i.secretVolumes()).stream().map(j -> new SecretVolume(j.volumeName(), j.secretName(), Integer.valueOf(j.defaultMode()), Boolean.valueOf(j.optional()), Arrays.asList(j.items()).stream().map(k -> new Item(k.key(), k.path(), Integer.valueOf(k.mode()))).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new SecretVolume[0]), Arrays.asList(i.configMapVolumes()).stream().map(j -> new ConfigMapVolume(j.volumeName(), j.configMapName(), Integer.valueOf(j.defaultMode()), Boolean.valueOf(j.optional()), Arrays.asList(j.items()).stream().map(k -> new Item(k.key(), k.path(), Integer.valueOf(k.mode()))).collect(Collectors.toList()).toArray(new Item[0]))).collect(Collectors.toList()).toArray(new ConfigMapVolume[0]), Arrays.asList(i.emptyDirVolumes()).stream().map(j -> new EmptyDirVolume(j.volumeName())).collect(Collectors.toList()).toArray(new EmptyDirVolume[0]), Arrays.asList(i.awsElasticBlockStoreVolumes()).stream().map(j -> new AwsElasticBlockStoreVolume(j.volumeName(), j.volumeId(), Integer.valueOf(j.partition()), j.fsType(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new AwsElasticBlockStoreVolume[0]), Arrays.asList(i.azureDiskVolumes()).stream().map(j -> new AzureDiskVolume(j.volumeName(), j.diskName(), j.diskURI(), j.kind(), j.cachingMode(), j.fsType(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new AzureDiskVolume[0]), Arrays.asList(i.azureFileVolumes()).stream().map(j -> new AzureFileVolume(j.volumeName(), j.shareName(), j.secretName(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new AzureFileVolume[0]), Arrays.asList(i.containers()).stream().map(j -> new Container(j.image(), j.name(), Arrays.asList(j.envVars()).stream().map(k -> new Env(k.name(), k.value(), k.secret(), k.configmap(), k.field(), k.resourceField(), k.prefix())).collect(Collectors.toList()).toArray(new Env[0]), j.workingDir(), j.command(), j.arguments(), Arrays.asList(j.ports()).stream().map(k -> new Port(k.name(), Integer.valueOf(k.containerPort()), Integer.valueOf(k.hostPort()), Integer.valueOf(k.nodePort()), k.path(), k.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(j.mounts()).stream().map(k -> new Mount(k.name(), k.path(), k.subPath(), Boolean.valueOf(k.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), j.imagePullPolicy(), new Probe(j.livenessProbe().httpActionPath(), j.livenessProbe().execAction(), j.livenessProbe().tcpSocketAction(), j.livenessProbe().grpcAction(), Integer.valueOf(j.livenessProbe().initialDelaySeconds()), Integer.valueOf(j.livenessProbe().periodSeconds()), Integer.valueOf(j.livenessProbe().timeoutSeconds()), Integer.valueOf(j.livenessProbe().successThreshold()), Integer.valueOf(j.livenessProbe().failureThreshold())), new Probe(j.readinessProbe().httpActionPath(), j.readinessProbe().execAction(), j.readinessProbe().tcpSocketAction(), j.readinessProbe().grpcAction(), Integer.valueOf(j.readinessProbe().initialDelaySeconds()), Integer.valueOf(j.readinessProbe().periodSeconds()), Integer.valueOf(j.readinessProbe().timeoutSeconds()), Integer.valueOf(j.readinessProbe().successThreshold()), Integer.valueOf(j.readinessProbe().failureThreshold())), new Probe(j.startupProbe().httpActionPath(), j.startupProbe().execAction(), j.startupProbe().tcpSocketAction(), j.startupProbe().grpcAction(), Integer.valueOf(j.startupProbe().initialDelaySeconds()), Integer.valueOf(j.startupProbe().periodSeconds()), Integer.valueOf(j.startupProbe().timeoutSeconds()), Integer.valueOf(j.startupProbe().successThreshold()), Integer.valueOf(j.startupProbe().failureThreshold())), new ResourceRequirements(j.requestResources().memory(), j.requestResources().cpu()), new ResourceRequirements(j.limitResources().memory(), j.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]))).collect(Collectors.toList()).toArray(new CronJob[0]), Arrays.asList(instance.initContainers()).stream().map(i -> new Container(i.image(), i.name(), Arrays.asList(i.envVars()).stream().map(j -> new Env(j.name(), j.value(), j.secret(), j.configmap(), j.field(), j.resourceField(), j.prefix())).collect(Collectors.toList()).toArray(new Env[0]), i.workingDir(), i.command(), i.arguments(), Arrays.asList(i.ports()).stream().map(j -> new Port(j.name(), Integer.valueOf(j.containerPort()), Integer.valueOf(j.hostPort()), Integer.valueOf(j.nodePort()), j.path(), j.protocol())).collect(Collectors.toList()).toArray(new Port[0]), Arrays.asList(i.mounts()).stream().map(j -> new Mount(j.name(), j.path(), j.subPath(), Boolean.valueOf(j.readOnly()))).collect(Collectors.toList()).toArray(new Mount[0]), i.imagePullPolicy(), new Probe(i.livenessProbe().httpActionPath(), i.livenessProbe().execAction(), i.livenessProbe().tcpSocketAction(), i.livenessProbe().grpcAction(), Integer.valueOf(i.livenessProbe().initialDelaySeconds()), Integer.valueOf(i.livenessProbe().periodSeconds()), Integer.valueOf(i.livenessProbe().timeoutSeconds()), Integer.valueOf(i.livenessProbe().successThreshold()), Integer.valueOf(i.livenessProbe().failureThreshold())), new Probe(i.readinessProbe().httpActionPath(), i.readinessProbe().execAction(), i.readinessProbe().tcpSocketAction(), i.readinessProbe().grpcAction(), Integer.valueOf(i.readinessProbe().initialDelaySeconds()), Integer.valueOf(i.readinessProbe().periodSeconds()), Integer.valueOf(i.readinessProbe().timeoutSeconds()), Integer.valueOf(i.readinessProbe().successThreshold()), Integer.valueOf(i.readinessProbe().failureThreshold())), new Probe(i.startupProbe().httpActionPath(), i.startupProbe().execAction(), i.startupProbe().tcpSocketAction(), i.startupProbe().grpcAction(), Integer.valueOf(i.startupProbe().initialDelaySeconds()), Integer.valueOf(i.startupProbe().periodSeconds()), Integer.valueOf(i.startupProbe().timeoutSeconds()), Integer.valueOf(i.startupProbe().successThreshold()), Integer.valueOf(i.startupProbe().failureThreshold())), new ResourceRequirements(i.requestResources().memory(), i.requestResources().cpu()), new ResourceRequirements(i.limitResources().memory(), i.limitResources().cpu()))).collect(Collectors.toList()).toArray(new Container[0]), instance.replicas(), new Ingress(instance.ingress().host(), instance.ingress().ingressClassName(), instance.ingress().targetPort(), instance.ingress().expose(), instance.ingress().tlsSecretName(), instance.ingress().tlsHosts(), Arrays.asList(instance.ingress().rules()).stream().map(i -> new IngressRule(i.host(), i.path(), i.pathType(), i.serviceName(), i.servicePortName(), i.servicePortNumber())).collect(Collectors.toList()).toArray(new IngressRule[0])), instance.headless()));
    }

    public static KubernetesConfig adapt(Map map) {
        return new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("partOf", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, map instanceof Map ? map.getOrDefault("deploymentKind", null) : null, (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env((String)(i instanceof Map ? i.getOrDefault("name", null) : null), i instanceof Map ? i.getOrDefault("value", "") : "", i instanceof Map ? i.getOrDefault("secret", "") : "", i instanceof Map ? i.getOrDefault("configmap", "") : "", i instanceof Map ? i.getOrDefault("field", "") : "", i instanceof Map ? i.getOrDefault("resourceField", "") : "", i instanceof Map ? i.getOrDefault("prefix", "") : "")).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("command")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("arguments")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("containerPort", null) : null), i instanceof Map ? i.getOrDefault("hostPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("nodePort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), map instanceof Map ? (map.getOrDefault("serviceType", null) != null ? ServiceType.valueOf((String)String.valueOf(map.getOrDefault("serviceType", null))) : null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("claimName", null) : null), i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(i instanceof Map ? i.getOrDefault("items", new Map[0]) : new Map[]{}).map(j -> new Item((String)(j instanceof Map ? j.getOrDefault("key", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("configMapName", null) : null), i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(i instanceof Map ? i.getOrDefault("items", new Map[0]) : new Map[]{}).map(j -> new Item((String)(j instanceof Map ? j.getOrDefault("key", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(ConfigMapVolume[]::new), (EmptyDirVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("emptyDirVolumes", new Map[0]) : new Map[]{}).map(i -> new EmptyDirVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null))).toArray(EmptyDirVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("repository", null) : null), i instanceof Map ? i.getOrDefault("directory", "") : "", i instanceof Map ? i.getOrDefault("revision", "") : "")).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("volumeId", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("partition", null) : null), i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskURI", null) : null), i instanceof Map ? i.getOrDefault("kind", "Managed") : "Managed", i instanceof Map ? i.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("shareName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("path", null) : null), i instanceof Map ? i.getOrDefault("subPath", "") : "", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), map instanceof Map ? (map.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(map.getOrDefault("imagePullPolicy", null))) : null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("imagePullSecrets")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? (map.getOrDefault("deploymentStrategy", null) != null ? DeploymentStrategy.valueOf((String)String.valueOf(map.getOrDefault("deploymentStrategy", null))) : null) : null, new RollingUpdate((Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxUnavailable", "25%") : "25%", (Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxSurge", "25%") : "25%"), (HostAlias[])Arrays.stream(map instanceof Map ? map.getOrDefault("hostAliases", new Map[0]) : new Map[]{}).map(i -> new HostAlias(i instanceof Map ? i.getOrDefault("ip", "") : "", i instanceof Map ? i.getOrDefault("hostnames", "") : "")).toArray(HostAlias[]::new), new NodeSelector((Map)(map instanceof Map ? map.get("nodeSelector") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("nodeSelector") : null)).getOrDefault("key", "") : "", (Map)(map instanceof Map ? map.get("nodeSelector") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("nodeSelector") : null)).getOrDefault("value", "") : ""), new Probe((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("cpu", "") : ""), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "", j instanceof Map ? j.getOrDefault("prefix", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("nodePort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("autoDeployEnabled", null) : null, (Job[])Arrays.stream(map instanceof Map ? map.getOrDefault("jobs", new Map[0]) : new Map[]{}).map(i -> new Job((String)(i instanceof Map ? i.getOrDefault("name", null) : null), i instanceof Map ? i.getOrDefault("parallelism", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("completions", -1) : Integer.valueOf(-1), JobCompletionMode.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("completionMode", "NonIndexed") : "NonIndexed")), i instanceof Map ? i.getOrDefault("backoffLimit", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("activeDeadlineSeconds", -1L) : Long.valueOf(-1L), i instanceof Map ? i.getOrDefault("ttlSecondsAfterFinished", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("suspend", false) : Boolean.valueOf(false), JobRestartPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("restartPolicy", "OnFailure") : "OnFailure")), (PersistentVolumeClaimVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(j -> new PersistentVolumeClaimVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("claimName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(j -> new SecretVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(j -> new ConfigMapVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("configMapName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(ConfigMapVolume[]::new), (EmptyDirVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("emptyDirVolumes", new Map[0]) : new Map[]{}).map(j -> new EmptyDirVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null))).toArray(EmptyDirVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(j -> new AwsElasticBlockStoreVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("volumeId", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("partition", null) : null), j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureDiskVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskURI", null) : null), j instanceof Map ? j.getOrDefault("kind", "Managed") : "Managed", j instanceof Map ? j.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureFileVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("shareName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Container[])Arrays.stream(i instanceof Map ? i.getOrDefault("containers", new Map[0]) : new Map[]{}).map(j -> new Container((String)(j instanceof Map ? j.getOrDefault("image", null) : null), j instanceof Map ? j.getOrDefault("name", "") : "", (Env[])Arrays.stream(j instanceof Map ? j.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(k -> new Env((String)(k instanceof Map ? k.getOrDefault("name", null) : null), k instanceof Map ? k.getOrDefault("value", "") : "", k instanceof Map ? k.getOrDefault("secret", "") : "", k instanceof Map ? k.getOrDefault("configmap", "") : "", k instanceof Map ? k.getOrDefault("field", "") : "", k instanceof Map ? k.getOrDefault("resourceField", "") : "", k instanceof Map ? k.getOrDefault("prefix", "") : "")).toArray(Env[]::new), j instanceof Map ? j.getOrDefault("workingDir", "") : "", j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("command")) : KubernetesConfigAdapter.toStringArray(j), j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("arguments")) : KubernetesConfigAdapter.toStringArray(j), (Port[])Arrays.stream(j instanceof Map ? j.getOrDefault("ports", new Map[0]) : new Map[]{}).map(k -> new Port((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (Integer)(k instanceof Map ? k.getOrDefault("containerPort", null) : null), k instanceof Map ? k.getOrDefault("hostPort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("nodePort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(k instanceof Map ? k.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(j instanceof Map ? j.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(k -> new Mount((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("subPath", "") : "", k instanceof Map ? k.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new))).toArray(Job[]::new), (CronJob[])Arrays.stream(map instanceof Map ? map.getOrDefault("cronJobs", new Map[0]) : new Map[]{}).map(i -> new CronJob((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("schedule", null) : null), CronJobConcurrencyPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("concurrencyPolicy", "Allow") : "Allow")), i instanceof Map ? i.getOrDefault("startingDeadlineSeconds", -1L) : Long.valueOf(-1L), i instanceof Map ? i.getOrDefault("failedJobsHistoryLimit", 1) : Integer.valueOf(1), i instanceof Map ? i.getOrDefault("successfulJobsHistoryLimit", 3) : Integer.valueOf(3), i instanceof Map ? i.getOrDefault("parallelism", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("completions", -1) : Integer.valueOf(-1), JobCompletionMode.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("completionMode", "NonIndexed") : "NonIndexed")), i instanceof Map ? i.getOrDefault("backoffLimit", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("activeDeadlineSeconds", -1L) : Long.valueOf(-1L), i instanceof Map ? i.getOrDefault("ttlSecondsAfterFinished", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("suspend", false) : Boolean.valueOf(false), JobRestartPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("restartPolicy", "OnFailure") : "OnFailure")), (PersistentVolumeClaimVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(j -> new PersistentVolumeClaimVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("claimName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(j -> new SecretVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(j -> new ConfigMapVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("configMapName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(ConfigMapVolume[]::new), (EmptyDirVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("emptyDirVolumes", new Map[0]) : new Map[]{}).map(j -> new EmptyDirVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null))).toArray(EmptyDirVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(j -> new AwsElasticBlockStoreVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("volumeId", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("partition", null) : null), j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureDiskVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskURI", null) : null), j instanceof Map ? j.getOrDefault("kind", "Managed") : "Managed", j instanceof Map ? j.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureFileVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("shareName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Container[])Arrays.stream(i instanceof Map ? i.getOrDefault("containers", new Map[0]) : new Map[]{}).map(j -> new Container((String)(j instanceof Map ? j.getOrDefault("image", null) : null), j instanceof Map ? j.getOrDefault("name", "") : "", (Env[])Arrays.stream(j instanceof Map ? j.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(k -> new Env((String)(k instanceof Map ? k.getOrDefault("name", null) : null), k instanceof Map ? k.getOrDefault("value", "") : "", k instanceof Map ? k.getOrDefault("secret", "") : "", k instanceof Map ? k.getOrDefault("configmap", "") : "", k instanceof Map ? k.getOrDefault("field", "") : "", k instanceof Map ? k.getOrDefault("resourceField", "") : "", k instanceof Map ? k.getOrDefault("prefix", "") : "")).toArray(Env[]::new), j instanceof Map ? j.getOrDefault("workingDir", "") : "", j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("command")) : KubernetesConfigAdapter.toStringArray(j), j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("arguments")) : KubernetesConfigAdapter.toStringArray(j), (Port[])Arrays.stream(j instanceof Map ? j.getOrDefault("ports", new Map[0]) : new Map[]{}).map(k -> new Port((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (Integer)(k instanceof Map ? k.getOrDefault("containerPort", null) : null), k instanceof Map ? k.getOrDefault("hostPort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("nodePort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(k instanceof Map ? k.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(j instanceof Map ? j.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(k -> new Mount((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("subPath", "") : "", k instanceof Map ? k.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new))).toArray(CronJob[]::new), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "", j instanceof Map ? j.getOrDefault("prefix", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("nodePort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("replicas", null) : null, new Ingress((Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("host", "") : "", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("ingressClassName", "") : "", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("targetPort", "http") : "http", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("expose", false) : Boolean.valueOf(false), (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("tlsSecretName", "") : "", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? KubernetesConfigAdapter.toStringArray(((Map)(map instanceof Map ? map.get("ingress") : null)).get("tlsHosts")) : KubernetesConfigAdapter.toStringArray(map instanceof Map ? map.get("ingress") : null), (IngressRule[])Arrays.stream((Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("rules", new Map[0]) : new Map[]{}).map(i -> new IngressRule(i instanceof Map ? i.getOrDefault("host", null) : null, i instanceof Map ? i.getOrDefault("path", "/") : "/", i instanceof Map ? i.getOrDefault("pathType", "Prefix") : "Prefix", i instanceof Map ? i.getOrDefault("serviceName", "") : "", i instanceof Map ? i.getOrDefault("servicePortName", "") : "", i instanceof Map ? i.getOrDefault("servicePortNumber", -1) : Integer.valueOf(-1))).toArray(IngressRule[]::new)), map instanceof Map ? map.getOrDefault("headless", null) : null);
    }

    public static KubernetesConfigBuilder newBuilder(Map map) {
        return new KubernetesConfigBuilder(new KubernetesConfig(null, null, map instanceof Map ? map.getOrDefault("partOf", null) : null, map instanceof Map ? map.getOrDefault("name", null) : null, map instanceof Map ? map.getOrDefault("version", null) : null, map instanceof Map ? map.getOrDefault("deploymentKind", null) : null, (Label[])Arrays.stream(map instanceof Map ? map.getOrDefault("labels", new Map[0]) : new Map[]{}).map(i -> new Label((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Label[]::new), (Annotation[])Arrays.stream(map instanceof Map ? map.getOrDefault("annotations", new Map[0]) : new Map[]{}).map(i -> new Annotation((String)(i instanceof Map ? i.getOrDefault("key", null) : null), (String)(i instanceof Map ? i.getOrDefault("value", null) : null), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("kinds")) : KubernetesConfigAdapter.toStringArray(i))).toArray(Annotation[]::new), (Env[])Arrays.stream(map instanceof Map ? map.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(i -> new Env((String)(i instanceof Map ? i.getOrDefault("name", null) : null), i instanceof Map ? i.getOrDefault("value", "") : "", i instanceof Map ? i.getOrDefault("secret", "") : "", i instanceof Map ? i.getOrDefault("configmap", "") : "", i instanceof Map ? i.getOrDefault("field", "") : "", i instanceof Map ? i.getOrDefault("resourceField", "") : "", i instanceof Map ? i.getOrDefault("prefix", "") : "")).toArray(Env[]::new), map instanceof Map ? map.getOrDefault("workingDir", null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("command")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("arguments")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? map.getOrDefault("serviceAccount", null) : null, (Port[])Arrays.stream(map instanceof Map ? map.getOrDefault("ports", new Map[0]) : new Map[]{}).map(i -> new Port((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("containerPort", null) : null), i instanceof Map ? i.getOrDefault("hostPort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("nodePort", 0) : Integer.valueOf(0), i instanceof Map ? i.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), map instanceof Map ? (map.getOrDefault("serviceType", null) != null ? ServiceType.valueOf((String)String.valueOf(map.getOrDefault("serviceType", null))) : null) : null, (PersistentVolumeClaimVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(i -> new PersistentVolumeClaimVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("claimName", null) : null), i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(i -> new SecretVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(i instanceof Map ? i.getOrDefault("items", new Map[0]) : new Map[]{}).map(j -> new Item((String)(j instanceof Map ? j.getOrDefault("key", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(i -> new ConfigMapVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("configMapName", null) : null), i instanceof Map ? i.getOrDefault("defaultMode", 384) : Integer.valueOf(384), i instanceof Map ? i.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(i instanceof Map ? i.getOrDefault("items", new Map[0]) : new Map[]{}).map(j -> new Item((String)(j instanceof Map ? j.getOrDefault("key", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(ConfigMapVolume[]::new), (EmptyDirVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("emptyDirVolumes", new Map[0]) : new Map[]{}).map(i -> new EmptyDirVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null))).toArray(EmptyDirVolume[]::new), (GitRepoVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("gitRepoVolumes", new Map[0]) : new Map[]{}).map(i -> new GitRepoVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("repository", null) : null), i instanceof Map ? i.getOrDefault("directory", "") : "", i instanceof Map ? i.getOrDefault("revision", "") : "")).toArray(GitRepoVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(i -> new AwsElasticBlockStoreVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("volumeId", null) : null), (Integer)(i instanceof Map ? i.getOrDefault("partition", null) : null), i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureDiskVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskName", null) : null), (String)(i instanceof Map ? i.getOrDefault("diskURI", null) : null), i instanceof Map ? i.getOrDefault("kind", "Managed") : "Managed", i instanceof Map ? i.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", i instanceof Map ? i.getOrDefault("fsType", "ext4") : "ext4", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(map instanceof Map ? map.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(i -> new AzureFileVolume((String)(i instanceof Map ? i.getOrDefault("volumeName", null) : null), (String)(i instanceof Map ? i.getOrDefault("shareName", null) : null), (String)(i instanceof Map ? i.getOrDefault("secretName", null) : null), i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Mount[])Arrays.stream(map instanceof Map ? map.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(i -> new Mount((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("path", null) : null), i instanceof Map ? i.getOrDefault("subPath", "") : "", i instanceof Map ? i.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), map instanceof Map ? (map.getOrDefault("imagePullPolicy", null) != null ? ImagePullPolicy.valueOf((String)String.valueOf(map.getOrDefault("imagePullPolicy", null))) : null) : null, map instanceof Map ? KubernetesConfigAdapter.toStringArray(map.get("imagePullSecrets")) : KubernetesConfigAdapter.toStringArray(map), map instanceof Map ? (map.getOrDefault("deploymentStrategy", null) != null ? DeploymentStrategy.valueOf((String)String.valueOf(map.getOrDefault("deploymentStrategy", null))) : null) : null, new RollingUpdate((Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxUnavailable", "25%") : "25%", (Map)(map instanceof Map ? map.get("rollingUpdate") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("rollingUpdate") : null)).getOrDefault("maxSurge", "25%") : "25%"), (HostAlias[])Arrays.stream(map instanceof Map ? map.getOrDefault("hostAliases", new Map[0]) : new Map[]{}).map(i -> new HostAlias(i instanceof Map ? i.getOrDefault("ip", "") : "", i instanceof Map ? i.getOrDefault("hostnames", "") : "")).toArray(HostAlias[]::new), new NodeSelector((Map)(map instanceof Map ? map.get("nodeSelector") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("nodeSelector") : null)).getOrDefault("key", "") : "", (Map)(map instanceof Map ? map.get("nodeSelector") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("nodeSelector") : null)).getOrDefault("value", "") : ""), new Probe((Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("livenessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("readinessProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(map instanceof Map ? map.get("startupProbe") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("requestResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(map instanceof Map ? map.get("limitResources") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("limitResources") : null)).getOrDefault("cpu", "") : ""), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("sidecars", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "", j instanceof Map ? j.getOrDefault("prefix", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("nodePort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("autoDeployEnabled", null) : null, (Job[])Arrays.stream(map instanceof Map ? map.getOrDefault("jobs", new Map[0]) : new Map[]{}).map(i -> new Job((String)(i instanceof Map ? i.getOrDefault("name", null) : null), i instanceof Map ? i.getOrDefault("parallelism", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("completions", -1) : Integer.valueOf(-1), JobCompletionMode.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("completionMode", "NonIndexed") : "NonIndexed")), i instanceof Map ? i.getOrDefault("backoffLimit", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("activeDeadlineSeconds", -1L) : Long.valueOf(-1L), i instanceof Map ? i.getOrDefault("ttlSecondsAfterFinished", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("suspend", false) : Boolean.valueOf(false), JobRestartPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("restartPolicy", "OnFailure") : "OnFailure")), (PersistentVolumeClaimVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(j -> new PersistentVolumeClaimVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("claimName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(j -> new SecretVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(j -> new ConfigMapVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("configMapName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(ConfigMapVolume[]::new), (EmptyDirVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("emptyDirVolumes", new Map[0]) : new Map[]{}).map(j -> new EmptyDirVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null))).toArray(EmptyDirVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(j -> new AwsElasticBlockStoreVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("volumeId", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("partition", null) : null), j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureDiskVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskURI", null) : null), j instanceof Map ? j.getOrDefault("kind", "Managed") : "Managed", j instanceof Map ? j.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureFileVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("shareName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Container[])Arrays.stream(i instanceof Map ? i.getOrDefault("containers", new Map[0]) : new Map[]{}).map(j -> new Container((String)(j instanceof Map ? j.getOrDefault("image", null) : null), j instanceof Map ? j.getOrDefault("name", "") : "", (Env[])Arrays.stream(j instanceof Map ? j.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(k -> new Env((String)(k instanceof Map ? k.getOrDefault("name", null) : null), k instanceof Map ? k.getOrDefault("value", "") : "", k instanceof Map ? k.getOrDefault("secret", "") : "", k instanceof Map ? k.getOrDefault("configmap", "") : "", k instanceof Map ? k.getOrDefault("field", "") : "", k instanceof Map ? k.getOrDefault("resourceField", "") : "", k instanceof Map ? k.getOrDefault("prefix", "") : "")).toArray(Env[]::new), j instanceof Map ? j.getOrDefault("workingDir", "") : "", j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("command")) : KubernetesConfigAdapter.toStringArray(j), j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("arguments")) : KubernetesConfigAdapter.toStringArray(j), (Port[])Arrays.stream(j instanceof Map ? j.getOrDefault("ports", new Map[0]) : new Map[]{}).map(k -> new Port((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (Integer)(k instanceof Map ? k.getOrDefault("containerPort", null) : null), k instanceof Map ? k.getOrDefault("hostPort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("nodePort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(k instanceof Map ? k.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(j instanceof Map ? j.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(k -> new Mount((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("subPath", "") : "", k instanceof Map ? k.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new))).toArray(Job[]::new), (CronJob[])Arrays.stream(map instanceof Map ? map.getOrDefault("cronJobs", new Map[0]) : new Map[]{}).map(i -> new CronJob((String)(i instanceof Map ? i.getOrDefault("name", null) : null), (String)(i instanceof Map ? i.getOrDefault("schedule", null) : null), CronJobConcurrencyPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("concurrencyPolicy", "Allow") : "Allow")), i instanceof Map ? i.getOrDefault("startingDeadlineSeconds", -1L) : Long.valueOf(-1L), i instanceof Map ? i.getOrDefault("failedJobsHistoryLimit", 1) : Integer.valueOf(1), i instanceof Map ? i.getOrDefault("successfulJobsHistoryLimit", 3) : Integer.valueOf(3), i instanceof Map ? i.getOrDefault("parallelism", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("completions", -1) : Integer.valueOf(-1), JobCompletionMode.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("completionMode", "NonIndexed") : "NonIndexed")), i instanceof Map ? i.getOrDefault("backoffLimit", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("activeDeadlineSeconds", -1L) : Long.valueOf(-1L), i instanceof Map ? i.getOrDefault("ttlSecondsAfterFinished", -1) : Integer.valueOf(-1), i instanceof Map ? i.getOrDefault("suspend", false) : Boolean.valueOf(false), JobRestartPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("restartPolicy", "OnFailure") : "OnFailure")), (PersistentVolumeClaimVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("pvcVolumes", new Map[0]) : new Map[]{}).map(j -> new PersistentVolumeClaimVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("claimName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(PersistentVolumeClaimVolume[]::new), (SecretVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("secretVolumes", new Map[0]) : new Map[]{}).map(j -> new SecretVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(SecretVolume[]::new), (ConfigMapVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("configMapVolumes", new Map[0]) : new Map[]{}).map(j -> new ConfigMapVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("configMapName", null) : null), j instanceof Map ? j.getOrDefault("defaultMode", 384) : Integer.valueOf(384), j instanceof Map ? j.getOrDefault("optional", false) : Boolean.valueOf(false), (Item[])Arrays.stream(j instanceof Map ? j.getOrDefault("items", new Map[0]) : new Map[]{}).map(k -> new Item((String)(k instanceof Map ? k.getOrDefault("key", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("mode", -1) : Integer.valueOf(-1))).toArray(Item[]::new))).toArray(ConfigMapVolume[]::new), (EmptyDirVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("emptyDirVolumes", new Map[0]) : new Map[]{}).map(j -> new EmptyDirVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null))).toArray(EmptyDirVolume[]::new), (AwsElasticBlockStoreVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("awsElasticBlockStoreVolumes", new Map[0]) : new Map[]{}).map(j -> new AwsElasticBlockStoreVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("volumeId", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("partition", null) : null), j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AwsElasticBlockStoreVolume[]::new), (AzureDiskVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureDiskVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureDiskVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskName", null) : null), (String)(j instanceof Map ? j.getOrDefault("diskURI", null) : null), j instanceof Map ? j.getOrDefault("kind", "Managed") : "Managed", j instanceof Map ? j.getOrDefault("cachingMode", "ReadWrite") : "ReadWrite", j instanceof Map ? j.getOrDefault("fsType", "ext4") : "ext4", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureDiskVolume[]::new), (AzureFileVolume[])Arrays.stream(i instanceof Map ? i.getOrDefault("azureFileVolumes", new Map[0]) : new Map[]{}).map(j -> new AzureFileVolume((String)(j instanceof Map ? j.getOrDefault("volumeName", null) : null), (String)(j instanceof Map ? j.getOrDefault("shareName", null) : null), (String)(j instanceof Map ? j.getOrDefault("secretName", null) : null), j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(AzureFileVolume[]::new), (Container[])Arrays.stream(i instanceof Map ? i.getOrDefault("containers", new Map[0]) : new Map[]{}).map(j -> new Container((String)(j instanceof Map ? j.getOrDefault("image", null) : null), j instanceof Map ? j.getOrDefault("name", "") : "", (Env[])Arrays.stream(j instanceof Map ? j.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(k -> new Env((String)(k instanceof Map ? k.getOrDefault("name", null) : null), k instanceof Map ? k.getOrDefault("value", "") : "", k instanceof Map ? k.getOrDefault("secret", "") : "", k instanceof Map ? k.getOrDefault("configmap", "") : "", k instanceof Map ? k.getOrDefault("field", "") : "", k instanceof Map ? k.getOrDefault("resourceField", "") : "", k instanceof Map ? k.getOrDefault("prefix", "") : "")).toArray(Env[]::new), j instanceof Map ? j.getOrDefault("workingDir", "") : "", j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("command")) : KubernetesConfigAdapter.toStringArray(j), j instanceof Map ? KubernetesConfigAdapter.toStringArray(j.get("arguments")) : KubernetesConfigAdapter.toStringArray(j), (Port[])Arrays.stream(j instanceof Map ? j.getOrDefault("ports", new Map[0]) : new Map[]{}).map(k -> new Port((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (Integer)(k instanceof Map ? k.getOrDefault("containerPort", null) : null), k instanceof Map ? k.getOrDefault("hostPort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("nodePort", 0) : Integer.valueOf(0), k instanceof Map ? k.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(k instanceof Map ? k.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(j instanceof Map ? j.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(k -> new Mount((String)(k instanceof Map ? k.getOrDefault("name", null) : null), (String)(k instanceof Map ? k.getOrDefault("path", null) : null), k instanceof Map ? k.getOrDefault("subPath", "") : "", k instanceof Map ? k.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("livenessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("readinessProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(j instanceof Map ? j.get("startupProbe") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("requestResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(j instanceof Map ? j.get("limitResources") : null) instanceof Map ? ((Map)(j instanceof Map ? j.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new))).toArray(CronJob[]::new), (Container[])Arrays.stream(map instanceof Map ? map.getOrDefault("initContainers", new Map[0]) : new Map[]{}).map(i -> new Container((String)(i instanceof Map ? i.getOrDefault("image", null) : null), i instanceof Map ? i.getOrDefault("name", "") : "", (Env[])Arrays.stream(i instanceof Map ? i.getOrDefault("envVars", new Map[0]) : new Map[]{}).map(j -> new Env((String)(j instanceof Map ? j.getOrDefault("name", null) : null), j instanceof Map ? j.getOrDefault("value", "") : "", j instanceof Map ? j.getOrDefault("secret", "") : "", j instanceof Map ? j.getOrDefault("configmap", "") : "", j instanceof Map ? j.getOrDefault("field", "") : "", j instanceof Map ? j.getOrDefault("resourceField", "") : "", j instanceof Map ? j.getOrDefault("prefix", "") : "")).toArray(Env[]::new), i instanceof Map ? i.getOrDefault("workingDir", "") : "", i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("command")) : KubernetesConfigAdapter.toStringArray(i), i instanceof Map ? KubernetesConfigAdapter.toStringArray(i.get("arguments")) : KubernetesConfigAdapter.toStringArray(i), (Port[])Arrays.stream(i instanceof Map ? i.getOrDefault("ports", new Map[0]) : new Map[]{}).map(j -> new Port((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (Integer)(j instanceof Map ? j.getOrDefault("containerPort", null) : null), j instanceof Map ? j.getOrDefault("hostPort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("nodePort", 0) : Integer.valueOf(0), j instanceof Map ? j.getOrDefault("path", "/") : "/", Protocol.valueOf((String)String.valueOf(j instanceof Map ? j.getOrDefault("protocol", "TCP") : "TCP")))).toArray(Port[]::new), (Mount[])Arrays.stream(i instanceof Map ? i.getOrDefault("mounts", new Map[0]) : new Map[]{}).map(j -> new Mount((String)(j instanceof Map ? j.getOrDefault("name", null) : null), (String)(j instanceof Map ? j.getOrDefault("path", null) : null), j instanceof Map ? j.getOrDefault("subPath", "") : "", j instanceof Map ? j.getOrDefault("readOnly", false) : Boolean.valueOf(false))).toArray(Mount[]::new), ImagePullPolicy.valueOf((String)String.valueOf(i instanceof Map ? i.getOrDefault("imagePullPolicy", "IfNotPresent") : "IfNotPresent")), new Probe((Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("livenessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("livenessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("readinessProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("readinessProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new Probe((Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("httpActionPath", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("execAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("tcpSocketAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("grpcAction", "") : "", (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("initialDelaySeconds", 0) : Integer.valueOf(0), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("periodSeconds", 30) : Integer.valueOf(30), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("timeoutSeconds", 10) : Integer.valueOf(10), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("successThreshold", 1) : Integer.valueOf(1), (Map)(i instanceof Map ? i.get("startupProbe") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("startupProbe") : null)).getOrDefault("failureThreshold", 3) : Integer.valueOf(3)), new ResourceRequirements((Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("requestResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("requestResources") : null)).getOrDefault("cpu", "") : ""), new ResourceRequirements((Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("memory", "") : "", (Map)(i instanceof Map ? i.get("limitResources") : null) instanceof Map ? ((Map)(i instanceof Map ? i.get("limitResources") : null)).getOrDefault("cpu", "") : ""))).toArray(Container[]::new), map instanceof Map ? map.getOrDefault("replicas", null) : null, new Ingress((Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("host", "") : "", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("ingressClassName", "") : "", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("targetPort", "http") : "http", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("expose", false) : Boolean.valueOf(false), (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("tlsSecretName", "") : "", (Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? KubernetesConfigAdapter.toStringArray(((Map)(map instanceof Map ? map.get("ingress") : null)).get("tlsHosts")) : KubernetesConfigAdapter.toStringArray(map instanceof Map ? map.get("ingress") : null), (IngressRule[])Arrays.stream((Map)(map instanceof Map ? map.get("ingress") : null) instanceof Map ? ((Map)(map instanceof Map ? map.get("ingress") : null)).getOrDefault("rules", new Map[0]) : new Map[]{}).map(i -> new IngressRule(i instanceof Map ? i.getOrDefault("host", null) : null, i instanceof Map ? i.getOrDefault("path", "/") : "/", i instanceof Map ? i.getOrDefault("pathType", "Prefix") : "Prefix", i instanceof Map ? i.getOrDefault("serviceName", "") : "", i instanceof Map ? i.getOrDefault("servicePortName", "") : "", i instanceof Map ? i.getOrDefault("servicePortNumber", -1) : Integer.valueOf(-1))).toArray(IngressRule[]::new)), map instanceof Map ? map.getOrDefault("headless", null) : null));
    }

    public static String[] toStringArray(Object o) {
        if (o instanceof String[]) {
            return (String[])o;
        }
        if (o instanceof String) {
            String s = (String)o;
            return s.split(",[ ]*");
        }
        if (o instanceof List) {
            List l = (List)o;
            String[] larray = new String[l.size()];
            for (int i = 0; i == l.size(); ++i) {
                larray[i] = String.valueOf(l.get(i));
            }
        }
        return new String[0];
    }
}

