/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.config;

import io.dekorate.testing.config.KubernetesIntegrationTestConfig;
import io.dekorate.testing.config.KubernetesIntegrationTestConfigFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class KubernetesIntegrationTestConfigFluentImpl<A extends KubernetesIntegrationTestConfigFluent<A>>
extends BaseFluent<A>
implements KubernetesIntegrationTestConfigFluent<A> {
    private boolean deployEnabled;
    private boolean buildEnabled;
    private long readinessTimeout;
    private List<String> additionalModules = new ArrayList<String>();

    public KubernetesIntegrationTestConfigFluentImpl() {
    }

    public KubernetesIntegrationTestConfigFluentImpl(KubernetesIntegrationTestConfig instance) {
        this.withDeployEnabled(instance.isDeployEnabled());
        this.withBuildEnabled(instance.isBuildEnabled());
        this.withReadinessTimeout(instance.getReadinessTimeout());
        this.withAdditionalModules(instance.getAdditionalModules());
    }

    @Override
    public boolean isDeployEnabled() {
        return this.deployEnabled;
    }

    @Override
    public A withDeployEnabled(boolean deployEnabled) {
        this.deployEnabled = deployEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasDeployEnabled() {
        return true;
    }

    @Override
    public boolean isBuildEnabled() {
        return this.buildEnabled;
    }

    @Override
    public A withBuildEnabled(boolean buildEnabled) {
        this.buildEnabled = buildEnabled;
        return (A)this;
    }

    @Override
    public Boolean hasBuildEnabled() {
        return true;
    }

    @Override
    public long getReadinessTimeout() {
        return this.readinessTimeout;
    }

    @Override
    public A withReadinessTimeout(long readinessTimeout) {
        this.readinessTimeout = readinessTimeout;
        return (A)this;
    }

    @Override
    public Boolean hasReadinessTimeout() {
        return true;
    }

    @Override
    public A withAdditionalModules(String ... additionalModules) {
        if (this.additionalModules != null) {
            this.additionalModules.clear();
        }
        if (additionalModules != null) {
            for (String item : additionalModules) {
                this.addToAdditionalModules(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getAdditionalModules() {
        int size = this.additionalModules != null ? this.additionalModules.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.additionalModules) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToAdditionalModules(Integer index, String item) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        this.additionalModules.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdditionalModules(Integer index, String item) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        this.additionalModules.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdditionalModules(String ... items) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalModules.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdditionalModules(Collection<String> items) {
        if (this.additionalModules == null) {
            this.additionalModules = new ArrayList<String>();
        }
        for (String item : items) {
            this.additionalModules.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalModules(String ... items) {
        for (String item : items) {
            if (this.additionalModules == null) continue;
            this.additionalModules.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdditionalModules(Collection<String> items) {
        for (String item : items) {
            if (this.additionalModules == null) continue;
            this.additionalModules.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalModules() {
        return this.additionalModules != null && !this.additionalModules.isEmpty();
    }

    @Override
    public A addNewAdditionalModule(String arg0) {
        return this.addToAdditionalModules(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KubernetesIntegrationTestConfigFluentImpl that = (KubernetesIntegrationTestConfigFluentImpl)o;
        if (this.deployEnabled != that.deployEnabled) {
            return false;
        }
        if (this.buildEnabled != that.buildEnabled) {
            return false;
        }
        if (this.readinessTimeout != that.readinessTimeout) {
            return false;
        }
        return !(this.additionalModules != null ? !this.additionalModules.equals(that.additionalModules) : that.additionalModules != null);
    }

    public int hashCode() {
        return Objects.hash(this.deployEnabled, this.buildEnabled, this.readinessTimeout, this.additionalModules, super.hashCode());
    }
}

