/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.testing.kubernetes;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.BuildServiceFactory;
import io.dekorate.DekorateException;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.project.Project;
import io.dekorate.testing.WithEvents;
import io.dekorate.testing.WithImageConfig;
import io.dekorate.testing.WithKubernetesClient;
import io.dekorate.testing.WithPod;
import io.dekorate.testing.WithProject;
import io.dekorate.testing.config.KubernetesIntegrationTestConfig;
import io.dekorate.testing.kubernetes.WithKubernetesConfig;
import io.dekorate.testing.kubernetes.WithKubernetesIntegrationTestConfig;
import io.dekorate.testing.kubernetes.WithKubernetesResources;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.VersionInfo;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.internal.readiness.Readiness;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class KubernetesExtension
implements ExecutionCondition,
BeforeAllCallback,
AfterAllCallback,
TestWatcher,
WithKubernetesIntegrationTestConfig,
WithPod,
WithKubernetesClient,
WithKubernetesResources,
WithEvents,
WithProject,
WithKubernetesConfig,
WithImageConfig {
    private final Logger LOGGER = LoggerFactory.getLogger();

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        try {
            VersionInfo version = this.getKubernetesClient(context).getVersion();
            String message = "Found version:" + version.getMajor() + "." + version.getMinor();
            this.LOGGER.info(message);
            return ConditionEvaluationResult.enabled((String)message);
        }
        catch (Throwable t) {
            String reason = "Could not communicate with KubernetesExtension API server.";
            this.LOGGER.error(reason);
            return ConditionEvaluationResult.disabled((String)reason);
        }
    }

    public void beforeAll(ExtensionContext context) throws Exception {
        List projects = this.getProjects(context);
        for (Project project : projects) {
            this.startProject(context, project);
        }
    }

    @Override
    public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        Arrays.stream(testInstance.getClass().getDeclaredFields()).forEach(f -> {
            this.injectKubernetesClient(context, testInstance, (Field)f);
            this.injectKubernetesResources(context, testInstance, (Field)f);
            this.injectPod(context, testInstance, (Field)f);
        });
        if (this.hasExtensionError(context)) {
            this.displayDiagnostics(context);
        }
    }

    public void testFailed(ExtensionContext context, Throwable throwable) {
        this.displayDiagnostics(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext context) {
        KubernetesIntegrationTestConfig config = this.getKubernetesIntegrationTestConfig(context);
        try {
            this.LOGGER.info("Cleaning up...");
            if (this.shouldDisplayDiagnostics(context)) {
                this.displayDiagnostics(context);
            }
            if (config.isDeployEnabled()) {
                List projects = this.getProjects(context);
                for (Project project : projects) {
                    this.deleteProject(context, project);
                }
            }
        }
        finally {
            this.closeKubernetesClient(context);
        }
    }

    public String[] getAdditionalModules(ExtensionContext context) {
        return this.getKubernetesIntegrationTestConfig(context).getAdditionalModules();
    }

    public String getName(ExtensionContext context) {
        List projects = this.getProjects(context);
        if (projects.size() != 1) {
            throw new IllegalStateException("Multiple projects found, can't use default name. Please, use `@Named` annotations for injecting instances.");
        }
        return this.getKubernetesConfig((Project)projects.get(0)).getName();
    }

    private void startProject(ExtensionContext context, Project project) throws InterruptedException {
        this.LOGGER.info("Starting project at " + project.getRoot());
        KubernetesIntegrationTestConfig config = this.getKubernetesIntegrationTestConfig(context);
        KubernetesClient client = this.getKubernetesClient(context);
        KubernetesList list = this.getKubernetesResources(context, project);
        if (this.hasKubernetesConfig(project) && this.hasImageConfig(project)) {
            ImageConfiguration imageConfig = (ImageConfiguration)this.getImageConfig(project).get();
            BuildService buildService = null;
            try {
                BuildServiceFactory buildServiceFactory = (BuildServiceFactory)BuildServiceFactories.find((Project)project, (ImageConfiguration)imageConfig).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
                buildService = buildServiceFactory.create(project, imageConfig, (Collection)list.getItems());
            }
            catch (Exception e) {
                throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
            }
            if (imageConfig.isAutoPushEnabled()) {
                buildService.prepare();
                buildService.build();
                buildService.push();
            } else if (imageConfig.isAutoBuildEnabled()) {
                buildService.prepare();
                buildService.build();
            } else if (config.isBuildEnabled()) {
                buildService.prepare();
                buildService.build();
            }
        }
        if (config.isDeployEnabled()) {
            list.getItems().stream().forEach(i -> {
                client.resourceList(new HasMetadata[]{i}).createOrReplace();
                this.LOGGER.info("Created: " + i.getKind() + " name:" + i.getMetadata().getName() + ".");
            });
            List waitables = list.getItems().stream().filter(i -> i instanceof Deployment || i instanceof Pod || i instanceof ReplicaSet || i instanceof ReplicationController).collect(Collectors.toList());
            long started = System.currentTimeMillis();
            this.LOGGER.info("Waiting until ready (" + config.getReadinessTimeout() + " ms)...");
            this.waitUntilCondition(context, waitables, i -> Readiness.getInstance().isReady(i), config.getReadinessTimeout(), TimeUnit.MILLISECONDS);
            long ended = System.currentTimeMillis();
            this.LOGGER.info("Waited: " + (ended - started) + " ms.");
            waitables.stream().map(r -> (HasMetadata)((Gettable)client.resource(r).fromServer()).get()).forEach(i -> {
                if (!Readiness.getInstance().isReady(i)) {
                    this.readinessFailed(context);
                    this.LOGGER.warning(i.getKind() + ":" + i.getMetadata().getName() + " not ready!");
                }
            });
            if (this.hasReadinessFailed(context)) {
                throw new IllegalStateException("Readiness Failed");
            }
        }
    }

    private void deleteProject(ExtensionContext context, Project project) {
        this.getKubernetesResources(context, project).getItems().stream().forEach(r -> this.LOGGER.info("Deleting: " + r.getKind() + " name:" + r.getMetadata().getName() + ". Deleted:" + ((Deletable)this.getKubernetesClient(context).resource(r).cascading(true)).delete()));
    }
}

