/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.handler;

import io.dekorate.AbstractKubernetesHandler;
import io.dekorate.BuildServiceFactories;
import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.EnvVarFluent;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpec;
import io.dekorate.deps.kubernetes.api.model.PodSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpec;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecFluent;
import io.dekorate.deps.openshift.api.model.DeploymentConfig;
import io.dekorate.deps.openshift.api.model.DeploymentConfigBuilder;
import io.dekorate.deps.openshift.api.model.DeploymentConfigFluent;
import io.dekorate.deps.openshift.api.model.DeploymentConfigSpecFluent;
import io.dekorate.deps.openshift.api.model.DeploymentTriggerImageChangeParamsFluent;
import io.dekorate.deps.openshift.api.model.DeploymentTriggerPolicyFluent;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddServiceDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.openshift.config.EditableOpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.openshift.decorator.ApplyDeploymentTriggerDecorator;
import io.dekorate.openshift.decorator.ApplyReplicasDecorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Labels;
import java.util.Map;
import java.util.Optional;

public class OpenshiftHandler
extends AbstractKubernetesHandler<OpenshiftConfig>
implements HandlerFactory,
WithProject {
    private static final String OPENSHIFT = "openshift";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    private static final String IMAGESTREAMTAG = "ImageStreamTag";
    private static final String IMAGECHANGE = "ImageChange";
    private static final String JAVA_APP_JAR = "JAVA_APP_JAR";
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final Configurators configurators;

    public OpenshiftHandler() {
        this(new Resources(), new Configurators());
    }

    public OpenshiftHandler(Resources resources, Configurators configurators) {
        super(resources);
        this.configurators = configurators;
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new OpenshiftHandler(resources, configurators);
    }

    public int order() {
        return 300;
    }

    public void handle(OpenshiftConfig config) {
        this.LOGGER.info("Processing openshift configuration.");
        ImageConfiguration imageConfig = OpenshiftHandler.getImageConfiguration(this.getProject(), config, this.configurators);
        Optional<DeploymentConfig> existingDeploymentConfig = this.resources.groups().getOrDefault(OPENSHIFT, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof DeploymentConfig).map(i -> (DeploymentConfig)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeploymentConfig.isPresent()) {
            this.resources.add(OPENSHIFT, (HasMetadata)this.createDeploymentConfig(config, imageConfig));
        }
        if (config.isHeadless()) {
            this.resources.decorate(OPENSHIFT, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        for (Container container : config.getInitContainers()) {
            this.resources.decorate(OPENSHIFT, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resources.decorate(OPENSHIFT, (Decorator)new AddServiceDecorator((BaseConfig)config));
        }
        this.addDecorators(OPENSHIFT, config);
    }

    public ConfigurationSupplier<OpenshiftConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((OpenshiftConfigBuilder)new OpenshiftConfigBuilder().accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(p)));
    }

    protected void addDecorators(String group, OpenshiftConfig config) {
        super.addDecorators(group, (BaseConfig)config);
        this.resources.decorate(group, (Decorator)new ApplyReplicasDecorator(config.getReplicas()));
        this.resources.decorate(group, (Decorator)new ApplyDeploymentTriggerDecorator(config.getName(), config.getName() + ":" + config.getVersion()));
        this.resources.decorate(group, (Decorator)new AddRouteDecorator(config));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(OpenshiftConfig.class) || type.equals(EditableOpenshiftConfig.class);
    }

    public DeploymentConfig createDeploymentConfig(OpenshiftConfig config, ImageConfiguration imageConfig) {
        Map labels = Labels.createLabels((BaseConfig)config);
        return ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerImageChangeParamsFluent.FromNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentTriggerPolicyFluent.ImageChangeParamsNested)((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(config.getName())).withLabels(labels)).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(this.createPodTemplateSpec(config, labels))).withSelector(labels)).addNewTrigger().withType(IMAGECHANGE)).withNewImageChangeParams().withAutomatic(Boolean.valueOf(true))).withContainerNames(new String[]{config.getName()})).withNewFrom().withKind(IMAGESTREAMTAG)).withName(imageConfig.getName() + ":" + imageConfig.getVersion())).endFrom()).endImageChangeParams()).endTrigger()).endSpec()).build();
    }

    public PodTemplateSpec createPodTemplateSpec(OpenshiftConfig config, Map<String, String> labels) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecFluent.MetadataNested)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(OpenshiftHandler.createPodSpec(config))).withNewMetadata().withLabels(labels)).endMetadata()).build();
    }

    public static PodSpec createPodSpec(OpenshiftConfig config) {
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage("")).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).addNewEnv().withName(JAVA_APP_JAR)).withValue("/deployments/" + config.getProject().getBuildInfo().getOutputFile().getFileName().toString())).endEnv()).endContainer()).build();
    }

    private static ImageConfiguration getImageConfiguration(Project project, OpenshiftConfig config, Configurators configurators) {
        return configurators.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> OpenshiftHandler.merge(config, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)config));
    }

    private static ImageConfiguration merge(OpenshiftConfig config, ImageConfiguration imageConfig) {
        if (config == null) {
            throw new NullPointerException("OpenshiftConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)config);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : config.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : config.getGroup())).withName(imageConfig.getName() != null ? imageConfig.getName() : config.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : config.getVersion())).withAutoBuildEnabled(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false)).withAutoPushEnabled(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false)).build();
    }
}

