/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.generator;

import io.dekorate.Generator;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.config.AnnotationConfiguration;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.config.PropertyConfiguration;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.openshift.adapter.OpenshiftConfigAdapter;
import io.dekorate.openshift.annotation.OpenshiftApplication;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import io.dekorate.openshift.handler.OpenshiftHandler;
import io.dekorate.openshift.listener.OpenshiftSessionListener;
import io.dekorate.project.ApplyProjectInfo;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.lang.model.element.Element;

public interface OpenshiftApplicationGenerator
extends Generator,
WithSession,
WithProject {
    public static final String OPENSHIFT = "openshift";
    public static final OpenshiftSessionListener LISTENER = new OpenshiftSessionListener();

    default public String getKey() {
        return OPENSHIFT;
    }

    default public Class<? extends Annotation> getAnnotation() {
        return OpenshiftApplication.class;
    }

    default public void add(Element element) {
        this.on((ConfigurationSupplier<OpenshiftConfig>)new AnnotationConfiguration((VisitableBuilder)((OpenshiftConfigBuilder)OpenshiftConfigAdapter.newBuilder(element.getAnnotation(OpenshiftApplication.class)).accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void add(Map map) {
        this.on((ConfigurationSupplier<OpenshiftConfig>)new PropertyConfiguration((VisitableBuilder)((OpenshiftConfigBuilder)OpenshiftConfigAdapter.newBuilder(this.propertiesMap(map, OpenshiftApplication.class)).accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(this.getProject()))));
    }

    default public void on(ConfigurationSupplier<OpenshiftConfig> config) {
        Session session = this.getSession();
        session.configurators().add(config);
        session.addListener((SessionListener)LISTENER);
        session.resources().groups().putIfAbsent(OPENSHIFT, new KubernetesListBuilder());
        session.handlers().add(new OpenshiftHandler(session.resources(), session.configurators()));
    }
}

