/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.listener;

import io.dekorate.BuildService;
import io.dekorate.BuildServiceFactories;
import io.dekorate.DekorateException;
import io.dekorate.Session;
import io.dekorate.SessionListener;
import io.dekorate.WithProject;
import io.dekorate.WithSession;
import io.dekorate.deps.kubernetes.api.model.KubernetesList;
import io.dekorate.hook.ImageBuildHook;
import io.dekorate.hook.OrderedHook;
import io.dekorate.hook.ProjectHook;
import io.dekorate.hook.ResourcesApplyHook;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class OpenshiftSessionListener
implements SessionListener,
WithProject,
WithSession {
    private final String OPENSHIFT = "openshift";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClosed() {
        Session session = this.getSession();
        Project project = this.getProject();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        ArrayList<Object> hooks = new ArrayList<Object>();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            Optional optionalAppConfig = session.configurators().get(OpenshiftConfig.class);
            Optional optionalImageConfig = session.configurators().getImageConfig(BuildServiceFactories.supplierMatches((Project)project));
            if (!optionalAppConfig.isPresent() || !optionalImageConfig.isPresent()) {
                return;
            }
            OpenshiftConfig openshiftConfig = (OpenshiftConfig)((Object)optionalAppConfig.get());
            ImageConfiguration imageConfig = (ImageConfiguration)optionalImageConfig.get();
            String name = session.configurators().get(OpenshiftConfig.class).map(c -> c.getName()).orElse(this.getProject().getBuildInfo().getName());
            if (imageConfig.isAutoBuildEnabled() || openshiftConfig.isAutoDeployEnabled()) {
                KubernetesList list = (KubernetesList)session.getGeneratedResources().get("openshift");
                List generated = list != null ? list.getItems() : Collections.emptyList();
                BuildService buildService = null;
                try {
                    buildService = (BuildService)optionalImageConfig.map(BuildServiceFactories.create((Project)this.getProject(), (Collection)generated)).orElseThrow(() -> new IllegalStateException("No applicable BuildServiceFactory found."));
                }
                catch (Exception e) {
                    BuildServiceFactories.log((Project)project, (Collection)session.configurators().getAll(ImageConfiguration.class));
                    throw DekorateException.launderThrowable((String)"Failed to lookup BuildService.", (Throwable)e);
                }
                hooks.add(new ImageBuildHook(this.getProject(), buildService));
            }
            if (openshiftConfig.isAutoDeployEnabled()) {
                hooks.add(new ResourcesApplyHook(this.getProject(), "openshift", "oc"));
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
            if (!hooks.isEmpty()) {
                OrderedHook hook = OrderedHook.create((ProjectHook[])hooks.toArray(new ProjectHook[hooks.size()]));
                hook.register();
            }
        }
    }
}

