/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.openshift.handler;

import io.dekorate.AbstractKubernetesHandler;
import io.dekorate.BuildServiceFactories;
import io.dekorate.Configurators;
import io.dekorate.Handler;
import io.dekorate.HandlerFactory;
import io.dekorate.Logger;
import io.dekorate.LoggerFactory;
import io.dekorate.Resources;
import io.dekorate.WithProject;
import io.dekorate.config.ConfigurationSupplier;
import io.dekorate.deps.kubernetes.api.builder.VisitableBuilder;
import io.dekorate.deps.kubernetes.api.builder.Visitor;
import io.dekorate.deps.kubernetes.api.model.ContainerFluent;
import io.dekorate.deps.kubernetes.api.model.EnvVarFluent;
import io.dekorate.deps.kubernetes.api.model.HasMetadata;
import io.dekorate.deps.kubernetes.api.model.KubernetesListBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpec;
import io.dekorate.deps.kubernetes.api.model.PodSpecBuilder;
import io.dekorate.deps.kubernetes.api.model.PodSpecFluent;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpec;
import io.dekorate.deps.kubernetes.api.model.PodTemplateSpecBuilder;
import io.dekorate.deps.openshift.api.model.DeploymentConfig;
import io.dekorate.deps.openshift.api.model.DeploymentConfigBuilder;
import io.dekorate.deps.openshift.api.model.DeploymentConfigFluent;
import io.dekorate.kubernetes.config.Annotation;
import io.dekorate.kubernetes.config.ApplicationConfiguration;
import io.dekorate.kubernetes.config.BaseConfig;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.kubernetes.config.Container;
import io.dekorate.kubernetes.config.ImageConfiguration;
import io.dekorate.kubernetes.config.ImageConfigurationBuilder;
import io.dekorate.kubernetes.config.Label;
import io.dekorate.kubernetes.configurator.ApplyDeployToApplicationConfiguration;
import io.dekorate.kubernetes.decorator.AddAnnotationDecorator;
import io.dekorate.kubernetes.decorator.AddInitContainerDecorator;
import io.dekorate.kubernetes.decorator.AddLabelDecorator;
import io.dekorate.kubernetes.decorator.AddServiceResourceDecorator;
import io.dekorate.kubernetes.decorator.ApplyHeadlessDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.RemoveAnnotationDecorator;
import io.dekorate.openshift.config.EditableOpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfig;
import io.dekorate.openshift.config.OpenshiftConfigBuilder;
import io.dekorate.openshift.decorator.AddRouteDecorator;
import io.dekorate.openshift.decorator.ApplyDeploymentTriggerDecorator;
import io.dekorate.openshift.decorator.ApplyReplicasDecorator;
import io.dekorate.project.ApplyProjectInfo;
import io.dekorate.project.Project;
import io.dekorate.utils.Images;
import io.dekorate.utils.Strings;
import java.util.Optional;

public class OpenshiftHandler
extends AbstractKubernetesHandler<OpenshiftConfig>
implements HandlerFactory,
WithProject {
    private static final String OPENSHIFT = "openshift";
    private static final String DEFAULT_REGISTRY = "docker.io";
    private static final String IF_NOT_PRESENT = "IfNotPresent";
    private static final String KUBERNETES_NAMESPACE = "KUBERNETES_NAMESPACE";
    private static final String METADATA_NAMESPACE = "metadata.namespace";
    public static final ConfigKey<String> RUNTIME_TYPE = new ConfigKey("RUNTIME_TYPE", String.class);
    private final Logger LOGGER = LoggerFactory.getLogger();
    private final Configurators configurators;

    public OpenshiftHandler() {
        this(new Resources(), new Configurators());
    }

    public OpenshiftHandler(Resources resources, Configurators configurators) {
        super(resources);
        this.configurators = configurators;
    }

    public Handler create(Resources resources, Configurators configurators) {
        return new OpenshiftHandler(resources, configurators);
    }

    public int order() {
        return 300;
    }

    public void handle(OpenshiftConfig config) {
        this.LOGGER.info("Processing openshift configuration.");
        ImageConfiguration imageConfig = OpenshiftHandler.getImageConfiguration(this.getProject(), config, this.configurators);
        Optional<DeploymentConfig> existingDeploymentConfig = this.resources.groups().getOrDefault(OPENSHIFT, new KubernetesListBuilder()).buildItems().stream().filter(i -> i instanceof DeploymentConfig).map(i -> (DeploymentConfig)i).filter(i -> i.getMetadata().getName().equals(config.getName())).findAny();
        if (!existingDeploymentConfig.isPresent()) {
            this.resources.add(OPENSHIFT, (HasMetadata)this.createDeploymentConfig(config, imageConfig));
        }
        if (config.isHeadless()) {
            this.resources.decorate(OPENSHIFT, (Decorator)new ApplyHeadlessDecorator(config.getName()));
        }
        for (Container container : config.getInitContainers()) {
            this.resources.decorate(OPENSHIFT, (Decorator)new AddInitContainerDecorator(config.getName(), container));
        }
        if (config.getPorts().length > 0) {
            this.resources.decorate(OPENSHIFT, (Decorator)new AddServiceResourceDecorator((BaseConfig)config));
        }
        this.addDecorators(OPENSHIFT, config, imageConfig);
    }

    public ConfigurationSupplier<OpenshiftConfig> getFallbackConfig() {
        Project p = this.getProject();
        return new ConfigurationSupplier((VisitableBuilder)((OpenshiftConfigBuilder)new OpenshiftConfigBuilder().accept((Visitor)new ApplyDeployToApplicationConfiguration())).accept((Visitor)new ApplyProjectInfo(p)));
    }

    protected void addDecorators(String group, OpenshiftConfig config, ImageConfiguration imageConfig) {
        super.addDecorators(group, (BaseConfig)config);
        if (config.getReplicas() != 1) {
            this.resources.decorate(group, (Decorator)new ApplyReplicasDecorator(config.getName(), config.getReplicas()));
        }
        this.resources.decorate(group, (Decorator)new ApplyDeploymentTriggerDecorator(config.getName(), imageConfig.getName() + ":" + imageConfig.getVersion()));
        this.resources.decorate(group, (Decorator)new AddRouteDecorator(config));
        if (config.hasAttribute(RUNTIME_TYPE)) {
            this.resources.decorate(group, (Decorator)new AddLabelDecorator(new Label("app.openshift.io/runtime", (String)config.getAttribute(RUNTIME_TYPE))));
        }
        this.resources.decorate(group, (Decorator)new RemoveAnnotationDecorator("app.dekorate.io/vcs-url"));
        Project p = this.getProject();
        String vcsUrl = p.getScmInfo() != null && Strings.isNotNullOrEmpty((String)p.getScmInfo().getUrl()) ? p.getScmInfo().getUrl() : "<<unknown>>";
        this.resources.decorate(group, (Decorator)new AddAnnotationDecorator(new Annotation("app.openshift.io/vcs-url", vcsUrl)));
    }

    public boolean canHandle(Class<? extends Configuration> type) {
        return type.equals(OpenshiftConfig.class) || type.equals(EditableOpenshiftConfig.class);
    }

    public DeploymentConfig createDeploymentConfig(OpenshiftConfig config, ImageConfiguration imageConfig) {
        return ((DeploymentConfigBuilder)((DeploymentConfigFluent.SpecNested)((DeploymentConfigFluent.SpecNested)((DeploymentConfigBuilder)((DeploymentConfigFluent.MetadataNested)new DeploymentConfigBuilder().withNewMetadata().withName(config.getName())).endMetadata()).withNewSpec().withReplicas(Integer.valueOf(1))).withTemplate(this.createPodTemplateSpec(config, imageConfig))).endSpec()).build();
    }

    public PodTemplateSpec createPodTemplateSpec(OpenshiftConfig config, ImageConfiguration imageConfig) {
        return ((PodTemplateSpecBuilder)((PodTemplateSpecBuilder)new PodTemplateSpecBuilder().withSpec(OpenshiftHandler.createPodSpec(config, imageConfig))).withNewMetadata().endMetadata()).build();
    }

    public static PodSpec createPodSpec(OpenshiftConfig config, ImageConfiguration imageConfig) {
        String image = Images.getImage((String)imageConfig.getRegistry(), (String)imageConfig.getGroup(), (String)imageConfig.getName(), (String)imageConfig.getVersion());
        return ((PodSpecBuilder)((PodSpecFluent.ContainersNested)((ContainerFluent.EnvNested)((EnvVarFluent.ValueFromNested)((ContainerFluent.EnvNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)((PodSpecFluent.ContainersNested)new PodSpecBuilder().addNewContainer().withName(config.getName())).withImage(image)).withImagePullPolicy(IF_NOT_PRESENT)).addNewEnv().withName(KUBERNETES_NAMESPACE)).withNewValueFrom().withNewFieldRef(null, METADATA_NAMESPACE)).endValueFrom()).endEnv()).endContainer()).build();
    }

    private static ImageConfiguration getImageConfiguration(Project project, OpenshiftConfig config, Configurators configurators) {
        return configurators.getImageConfig(BuildServiceFactories.supplierMatches((Project)project)).map(i -> OpenshiftHandler.merge(config, i)).orElse(ImageConfiguration.from((ApplicationConfiguration)config));
    }

    private static ImageConfiguration merge(OpenshiftConfig config, ImageConfiguration imageConfig) {
        if (config == null) {
            throw new NullPointerException("OpenshiftConfig is null.");
        }
        if (imageConfig == null) {
            return ImageConfiguration.from((ApplicationConfiguration)config);
        }
        return ((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)((ImageConfigurationBuilder)new ImageConfigurationBuilder().withProject(imageConfig.getProject() != null ? imageConfig.getProject() : config.getProject())).withGroup(imageConfig.getGroup() != null ? imageConfig.getGroup() : null)).withRegistry(imageConfig.getRegistry() != null ? imageConfig.getRegistry() : DEFAULT_REGISTRY)).withName(imageConfig.getName() != null ? imageConfig.getName() : config.getName())).withVersion(imageConfig.getVersion() != null ? imageConfig.getVersion() : config.getVersion())).withAutoBuildEnabled(imageConfig.isAutoBuildEnabled() ? imageConfig.isAutoBuildEnabled() : false)).withAutoPushEnabled(imageConfig.isAutoPushEnabled() ? imageConfig.isAutoPushEnabled() : false)).build();
    }
}

